/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import jdepend.framework.AbstractParser;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageFilter;

public class ClassFileParser
extends AbstractParser {
    public static final int JAVA_MAGIC = -889275714;
    public static final int CONSTANT_UTF8 = 1;
    public static final int CONSTANT_UNICODE = 2;
    public static final int CONSTANT_INTEGER = 3;
    public static final int CONSTANT_FLOAT = 4;
    public static final int CONSTANT_LONG = 5;
    public static final int CONSTANT_DOUBLE = 6;
    public static final int CONSTANT_CLASS = 7;
    public static final int CONSTANT_STRING = 8;
    public static final int CONSTANT_FIELD = 9;
    public static final int CONSTANT_METHOD = 10;
    public static final int CONSTANT_INTERFACEMETHOD = 11;
    public static final int CONSTANT_NAMEANDTYPE = 12;
    public static final char CLASS_DESCRIPTOR = 'L';
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    private String fileName;
    private String className;
    private String superClassName;
    private String[] interfaceNames;
    private boolean isAbstract;
    private JavaClass jClass;
    private Constant[] constantPool;
    private FieldOrMethodInfo[] fields;
    private FieldOrMethodInfo[] methods;
    private AttributeInfo[] attributes;
    private DataInputStream in;

    public ClassFileParser() {
        this(new PackageFilter());
    }

    public ClassFileParser(PackageFilter filter) {
        super(filter);
        this.reset();
    }

    private void reset() {
        this.className = null;
        this.superClassName = null;
        this.interfaceNames = new String[0];
        this.isAbstract = false;
        this.jClass = null;
        this.constantPool = new Constant[1];
        this.fields = new FieldOrMethodInfo[0];
        this.methods = new FieldOrMethodInfo[0];
        this.attributes = new AttributeInfo[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaClass parse(File classFile) throws IOException {
        this.fileName = classFile.getCanonicalPath();
        this.debug("\n\u30d5\u30a1\u30a4\u30eb\u300c" + this.fileName + "\u300d\u3092\u5206\u6790\u4e2d...");
        FileInputStream in = null;
        try {
            in = new FileInputStream(classFile);
            JavaClass javaClass = this.parse(in);
            return javaClass;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    @Override
    public JavaClass parse(InputStream is) throws IOException {
        this.reset();
        this.jClass = new JavaClass("Unknown");
        this.in = new DataInputStream(is);
        int magic = this.parseMagic();
        int minorVersion = this.parseMinorVersion();
        int majorVersion = this.parseMajorVersion();
        this.constantPool = this.parseConstantPool();
        this.parseAccessFlags();
        this.className = this.parseClassName();
        this.superClassName = this.parseSuperClassName();
        this.interfaceNames = this.parseInterfaces();
        this.fields = this.parseFields();
        this.methods = this.parseMethods();
        this.parseAttributes();
        this.addClassConstantReferences();
        this.onParsedJavaClass(this.jClass);
        return this.jClass;
    }

    private int parseMagic() throws IOException {
        int magic = this.in.readInt();
        if (magic != -889275714) {
            throw new IOException("\u4e0d\u6b63\u306a\u30af\u30e9\u30b9\u30d5\u30a1\u30a4\u30eb\uff1a " + this.fileName);
        }
        return magic;
    }

    private int parseMinorVersion() throws IOException {
        return this.in.readUnsignedShort();
    }

    private int parseMajorVersion() throws IOException {
        return this.in.readUnsignedShort();
    }

    private Constant[] parseConstantPool() throws IOException {
        int constantPoolSize = this.in.readUnsignedShort();
        Constant[] pool = new Constant[constantPoolSize];
        for (int i = 1; i < constantPoolSize; ++i) {
            Constant constant;
            pool[i] = constant = this.parseNextConstant();
            if (constant.getTag() != 6 && constant.getTag() != 5) continue;
            ++i;
        }
        return pool;
    }

    private void parseAccessFlags() throws IOException {
        int accessFlags = this.in.readUnsignedShort();
        boolean isAbstract = (accessFlags & 0x400) != 0;
        boolean isInterface = (accessFlags & 0x200) != 0;
        this.isAbstract = isAbstract || isInterface;
        this.jClass.isAbstract(this.isAbstract);
        this.debug("\u30d1\u30fc\u30b5\u30fc\uff1a \u62bd\u8c61 = " + this.isAbstract);
    }

    private String parseClassName() throws IOException {
        int entryIndex = this.in.readUnsignedShort();
        String className = this.getClassConstantName(entryIndex);
        this.jClass.setName(className);
        this.jClass.setPackageName(this.getPackageName(className));
        this.debug("\u30d1\u30fc\u30b5\u30fc\uff1a \u30af\u30e9\u30b9\u540d = " + className);
        this.debug("\u30d1\u30fc\u30b5\u30fc\uff1a \u30d1\u30c3\u30b1\u30fc\u30b8\u540d = " + this.getPackageName(className));
        return className;
    }

    private String parseSuperClassName() throws IOException {
        int entryIndex = this.in.readUnsignedShort();
        String superClassName = this.getClassConstantName(entryIndex);
        this.addImport(this.getPackageName(superClassName));
        this.debug("\u30d1\u30fc\u30b5\u30fc\uff1a \u30b9\u30fc\u30d1\u30af\u30e9\u30b9\u540d = " + superClassName);
        return superClassName;
    }

    private String[] parseInterfaces() throws IOException {
        int interfacesCount = this.in.readUnsignedShort();
        String[] interfaceNames = new String[interfacesCount];
        for (int i = 0; i < interfacesCount; ++i) {
            int entryIndex = this.in.readUnsignedShort();
            interfaceNames[i] = this.getClassConstantName(entryIndex);
            this.addImport(this.getPackageName(interfaceNames[i]));
            this.debug("\u30d1\u30fc\u30b5\u30fc\uff1a \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9 = " + interfaceNames[i]);
        }
        return interfaceNames;
    }

    private FieldOrMethodInfo[] parseFields() throws IOException {
        int fieldsCount = this.in.readUnsignedShort();
        FieldOrMethodInfo[] fields = new FieldOrMethodInfo[fieldsCount];
        for (int i = 0; i < fieldsCount; ++i) {
            fields[i] = this.parseFieldOrMethodInfo();
            String descriptor = this.toUTF8(fields[i].getDescriptorIndex());
            this.debug("\u30d1\u30fc\u30b5\u30fc\uff1a \u30d5\u30a3\u30fc\u30eb\u30c9\u30c7\u30a3\u30b9\u30af\u30ea\u30d7\u30bf = " + descriptor);
            String[] types = this.descriptorToTypes(descriptor);
            for (int t = 0; t < types.length; ++t) {
                this.addImport(this.getPackageName(types[t]));
                this.debug("\u30d1\u30fc\u30b5\u30fc\uff1a \u30d5\u30a3\u30fc\u30eb\u30c9\u30bf\u30a4\u30d7 = " + types[t]);
            }
        }
        return fields;
    }

    private FieldOrMethodInfo[] parseMethods() throws IOException {
        int methodsCount = this.in.readUnsignedShort();
        FieldOrMethodInfo[] methods = new FieldOrMethodInfo[methodsCount];
        for (int i = 0; i < methodsCount; ++i) {
            methods[i] = this.parseFieldOrMethodInfo();
            String descriptor = this.toUTF8(methods[i].getDescriptorIndex());
            this.debug("\u30d1\u30fc\u30b5\u30fc\uff1a \u30e1\u30bd\u30c3\u30c9\u30c7\u30a3\u30b9\u30af\u30ea\u30d7\u30bf = " + descriptor);
            String[] types = this.descriptorToTypes(descriptor);
            for (int t = 0; t < types.length; ++t) {
                if (types[t].length() <= 0) continue;
                this.addImport(this.getPackageName(types[t]));
                this.debug("\u30d1\u30fc\u30b5\u30fc\uff1a \u30e1\u30bd\u30c3\u30c9\u30bf\u30a4\u30d7 = " + types[t]);
            }
        }
        return methods;
    }

    private Constant parseNextConstant() throws IOException {
        Constant result;
        byte tag = this.in.readByte();
        switch (tag) {
            case 7: 
            case 8: {
                result = new Constant(tag, this.in.readUnsignedShort());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                result = new Constant(tag, this.in.readUnsignedShort(), this.in.readUnsignedShort());
                break;
            }
            case 3: {
                result = new Constant(tag, new Integer(this.in.readInt()));
                break;
            }
            case 4: {
                result = new Constant(tag, new Float(this.in.readFloat()));
                break;
            }
            case 5: {
                result = new Constant(tag, new Long(this.in.readLong()));
                break;
            }
            case 6: {
                result = new Constant(tag, new Double(this.in.readDouble()));
                break;
            }
            case 1: {
                result = new Constant(tag, this.in.readUTF());
                break;
            }
            default: {
                throw new IOException("\u4e0d\u660e\u306a\u5b9a\u6570\uff1a " + tag);
            }
        }
        return result;
    }

    private FieldOrMethodInfo parseFieldOrMethodInfo() throws IOException {
        FieldOrMethodInfo result = new FieldOrMethodInfo(this.in.readUnsignedShort(), this.in.readUnsignedShort(), this.in.readUnsignedShort());
        int attributesCount = this.in.readUnsignedShort();
        for (int a = 0; a < attributesCount; ++a) {
            this.parseAttribute();
        }
        return result;
    }

    private void parseAttributes() throws IOException {
        int attributesCount = this.in.readUnsignedShort();
        this.attributes = new AttributeInfo[attributesCount];
        for (int i = 0; i < attributesCount; ++i) {
            this.attributes[i] = this.parseAttribute();
            if (this.attributes[i].getName() == null || !this.attributes[i].getName().equals("SourceFile")) continue;
            byte[] b = this.attributes[i].getValue();
            int b0 = b[0] < 0 ? b[0] + 256 : b[0];
            int b1 = b[1] < 0 ? b[1] + 256 : b[1];
            int pe = b0 * 256 + b1;
            String descriptor = this.toUTF8(pe);
            this.jClass.setSourceFile(descriptor);
        }
    }

    private AttributeInfo parseAttribute() throws IOException {
        AttributeInfo result = new AttributeInfo();
        int nameIndex = this.in.readUnsignedShort();
        if (nameIndex != -1) {
            result.setName(this.toUTF8(nameIndex));
        }
        int attributeLength = this.in.readInt();
        byte[] value = new byte[attributeLength];
        for (int b = 0; b < attributeLength; ++b) {
            value[b] = this.in.readByte();
        }
        result.setValue(value);
        return result;
    }

    private Constant getConstantPoolEntry(int entryIndex) throws IOException {
        if (entryIndex < 0 || entryIndex >= this.constantPool.length) {
            throw new IOException("\u4e0d\u6b63\u306a\u5b9a\u6570\u30d7\u30fc\u30eb\u30a4\u30f3\u30c7\u30a3\u30af\u30b9\uff1a " + entryIndex);
        }
        return this.constantPool[entryIndex];
    }

    private void addClassConstantReferences() throws IOException {
        for (int j = 1; j < this.constantPool.length; ++j) {
            if (this.constantPool[j].getTag() == 7) {
                String name = this.toUTF8(this.constantPool[j].getNameIndex());
                this.addImport(this.getPackageName(name));
                this.debug("\u30d1\u30fc\u30b5\u30fc\uff1a \u30af\u30e9\u30b9\u30bf\u30a4\u30d7 = " + this.slashesToDots(name));
            }
            if (this.constantPool[j].getTag() != 6 && this.constantPool[j].getTag() != 5) continue;
            ++j;
        }
    }

    private String getClassConstantName(int entryIndex) throws IOException {
        Constant entry = this.getConstantPoolEntry(entryIndex);
        if (entry == null) {
            return "";
        }
        return this.slashesToDots(this.toUTF8(entry.getNameIndex()));
    }

    private String toUTF8(int entryIndex) throws IOException {
        Constant entry = this.getConstantPoolEntry(entryIndex);
        if (entry.getTag() == 1) {
            return (String)entry.getValue();
        }
        throw new IOException("\u5b9a\u6570\u30d7\u30fc\u30eb\u30a8\u30f3\u30c8\u30ea\u30fc\u304cUTF8\u30bf\u30a4\u30d7\u3067\u3042\u308a\u307e\u305b\u3093\uff1a " + entryIndex);
    }

    private void addImport(String importPackage) {
        if (importPackage != null && this.getFilter().accept(importPackage)) {
            this.jClass.addImportedPackage(new JavaPackage(importPackage));
        }
    }

    private String slashesToDots(String s) {
        return s.replace('/', '.');
    }

    private String getPackageName(String s) {
        int index;
        if (s.length() > 0 && s.charAt(0) == '[') {
            String[] types = this.descriptorToTypes(s);
            if (types.length == 0) {
                return null;
            }
            s = types[0];
        }
        if ((index = (s = this.slashesToDots(s)).lastIndexOf(".")) > 0) {
            return s.substring(0, index);
        }
        return "Default";
    }

    private String[] descriptorToTypes(String descriptor) {
        int startIndex;
        int typesCount = 0;
        for (int index = 0; index < descriptor.length(); ++index) {
            if (descriptor.charAt(index) != ';') continue;
            ++typesCount;
        }
        String[] types = new String[typesCount];
        int typeIndex = 0;
        for (int index = 0; index < descriptor.length() && (startIndex = descriptor.indexOf(76, index)) >= 0; ++index) {
            index = descriptor.indexOf(59, startIndex + 1);
            types[typeIndex++] = descriptor.substring(startIndex + 1, index);
        }
        return types;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        try {
            int i;
            s.append("\n" + this.className + ":\n");
            s.append("\n\u5b9a\u6570\uff1a\n");
            for (i = 1; i < this.constantPool.length; ++i) {
                Constant entry = this.getConstantPoolEntry(i);
                s.append("    " + i + ". " + entry.toString() + "\n");
                if (entry.getTag() != 6 && entry.getTag() != 5) continue;
                ++i;
            }
            s.append("\n\u30af\u30e9\u30b9\u540d\uff1a " + this.className + "\n");
            s.append("\u30b9\u30fc\u30d1\u30fc\u540d\uff1a " + this.superClassName + "\n\n");
            s.append(this.interfaceNames.length + " \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\n");
            for (i = 0; i < this.interfaceNames.length; ++i) {
                s.append("    " + this.interfaceNames[i] + "\n");
            }
            s.append("\n" + this.fields.length + " \u30d5\u30a3\u30fc\u30eb\u30c9\n");
            for (i = 0; i < this.fields.length; ++i) {
                s.append(this.fields[i].toString() + "\n");
            }
            s.append("\n" + this.methods.length + " \u30e1\u30bd\u30c3\u30c9\n");
            for (i = 0; i < this.methods.length; ++i) {
                s.append(this.methods[i].toString() + "\n");
            }
            s.append("\n\u4f9d\u5b58:\n");
            for (JavaPackage jPackage : this.jClass.getImportedPackages()) {
                s.append("    " + jPackage.getName() + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s.toString();
    }

    public static void main(String[] args) {
        try {
            DEBUG = true;
            if (args.length <= 0) {
                System.err.println("\u6587\u6cd5\uff1a ClassFileParser <class-file>");
                System.exit(0);
            }
            ClassFileParser parser = new ClassFileParser();
            parser.parse(new File(args[0]));
            System.err.println(parser.toString());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    class AttributeInfo {
        private String name;
        private byte[] value;

        AttributeInfo() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public byte[] getValue() {
            return this.value;
        }
    }

    class FieldOrMethodInfo {
        private int _accessFlags;
        private int _nameIndex;
        private int _descriptorIndex;

        FieldOrMethodInfo(int accessFlags, int nameIndex, int descriptorIndex) {
            this._accessFlags = accessFlags;
            this._nameIndex = nameIndex;
            this._descriptorIndex = descriptorIndex;
        }

        int accessFlags() {
            return this._accessFlags;
        }

        int getNameIndex() {
            return this._nameIndex;
        }

        int getDescriptorIndex() {
            return this._descriptorIndex;
        }

        public String toString() {
            StringBuffer s = new StringBuffer("");
            try {
                s.append("\n    \u540d\u524d (#" + this.getNameIndex() + ") = " + ClassFileParser.this.toUTF8(this.getNameIndex()));
                s.append("\n    \u30b7\u30b0\u30cd\u30c1\u30e3\u30fc (#" + this.getDescriptorIndex() + ") = " + ClassFileParser.this.toUTF8(this.getDescriptorIndex()));
                String[] types = ClassFileParser.this.descriptorToTypes(ClassFileParser.this.toUTF8(this.getDescriptorIndex()));
                for (int t = 0; t < types.length; ++t) {
                    s.append("\n        \u30bf\u30a4\u30d7 = " + types[t]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return s.toString();
        }
    }

    class Constant {
        private byte _tag;
        private int _nameIndex;
        private int _typeIndex;
        private Object _value;

        Constant(byte tag, int nameIndex) {
            this(tag, nameIndex, -1);
        }

        Constant(byte tag, Object value) {
            this(tag, -1, -1);
            this._value = value;
        }

        Constant(byte tag, int nameIndex, int typeIndex) {
            this._tag = tag;
            this._nameIndex = nameIndex;
            this._typeIndex = typeIndex;
            this._value = null;
        }

        byte getTag() {
            return this._tag;
        }

        int getNameIndex() {
            return this._nameIndex;
        }

        int getTypeIndex() {
            return this._typeIndex;
        }

        Object getValue() {
            return this._value;
        }

        public String toString() {
            StringBuffer s = new StringBuffer("");
            s.append("\u30bf\u30b0\uff1a " + this.getTag());
            if (this.getNameIndex() > -1) {
                s.append(" \u540d\u524d\u30a4\u30f3\u30c7\u30a3\u30af\u30b9\uff1a " + this.getNameIndex());
            }
            if (this.getTypeIndex() > -1) {
                s.append(" \u30bf\u30a4\u30d7\u30a4\u30f3\u30c7\u30a3\u30af\u30b9\uff1a " + this.getTypeIndex());
            }
            if (this.getValue() != null) {
                s.append(" \u5024\uff1a " + this.getValue());
            }
            return s.toString();
        }
    }
}

