/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context;

import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.db.Table;
import org.hibernate.cfg.NamingStrategy;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateJoinColumn;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;

public class NamingStrategyMappingTools
extends MappingTools {
    public static String buildJoinTableDefaultName(RelationshipMapping relationshipMapping) {
        if (relationshipMapping.getJpaProject().getDataSource().connectionProfileIsActive()) {
            return NamingStrategyMappingTools.buildDbJoinTableDefaultName(relationshipMapping);
        }
        String owningTableName = relationshipMapping.getTypeMapping().getPrimaryTableName();
        if (owningTableName == null) {
            return null;
        }
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        String targetTableName = targetEntity.getPrimaryTableName();
        if (targetTableName == null) {
            return null;
        }
        HibernateJpaProject hibernateJpaProject = (HibernateJpaProject)targetEntity.getJpaProject();
        NamingStrategy ns = hibernateJpaProject.getNamingStrategy();
        if (ns != null && hibernateJpaProject.isNamingStrategyEnabled()) {
            try {
                String name = ns.collectionTableName(relationshipMapping.getEntity().getPersistentType().getName(), relationshipMapping.getEntity().getTable().getName(), targetEntity.getPersistentType().getName(), targetEntity.getTable().getName(), relationshipMapping.getName());
                return name;
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return String.valueOf(owningTableName) + '_' + targetTableName;
    }

    protected static String buildDbJoinTableDefaultName(RelationshipMapping relationshipMapping) {
        Table owningTable = relationshipMapping.getTypeMapping().getPrimaryDbTable();
        if (owningTable == null) {
            return null;
        }
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        Table targetTable = targetEntity.getPrimaryDbTable();
        if (targetTable == null) {
            return null;
        }
        HibernateJpaProject hibernateJpaProject = (HibernateJpaProject)targetEntity.getJpaProject();
        NamingStrategy ns = hibernateJpaProject.getNamingStrategy();
        if (ns != null && hibernateJpaProject.isNamingStrategyEnabled()) {
            try {
                String name = ns.collectionTableName(relationshipMapping.getEntity().getPersistentType().getName(), relationshipMapping.getEntity().getTable().getName(), targetEntity.getPersistentType().getName(), targetEntity.getTable().getName(), relationshipMapping.getName());
                return name;
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        String name = String.valueOf(owningTable.getName()) + '_' + targetTable.getName();
        return owningTable.getDatabase().convertNameToIdentifier(name);
    }

    public static String buildJoinColumnDefaultName(HibernateJoinColumn joinColumn) {
        JoinColumn.Owner owner = joinColumn.getOwner();
        RelationshipMapping relationshipMapping = owner.getRelationshipMapping();
        if (relationshipMapping == null) {
            return null;
        }
        if (owner.joinColumnsSize() != 1) {
            return null;
        }
        String prefix = owner.getAttributeName();
        Entity targetEntity = owner.getTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        String targetEntityName = targetEntity.getName();
        String targetColumnName = joinColumn.getReferencedColumnName();
        if (targetColumnName == null) {
            return null;
        }
        HibernateJpaProject hibernateJpaProject = (HibernateJpaProject)targetEntity.getJpaProject();
        NamingStrategy ns = hibernateJpaProject.getNamingStrategy();
        if (ns != null && hibernateJpaProject.isNamingStrategyEnabled()) {
            String logicalTargetColumnName = null;
            String name = null;
            try {
                if (joinColumn.getSpecifiedName() != null) {
                    name = ns.columnName(joinColumn.getSpecifiedName());
                } else {
                    PersistentAttribute pattr = joinColumn.getReferencedPersistentAttribute();
                    if (pattr != null && pattr.getMapping() instanceof ColumnMapping) {
                        Column column = ((ColumnMapping)pattr.getMapping()).getColumn();
                        logicalTargetColumnName = column != null ? ns.logicalColumnName(column.getSpecifiedName(), pattr.getName()) : ns.logicalColumnName(null, pattr.getName());
                    }
                    name = ns.foreignKeyColumnName(prefix, targetEntity.getPersistentType().getName(), targetEntity.getTable().getName(), logicalTargetColumnName);
                }
                return name;
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        if (prefix == null) {
            prefix = targetEntityName;
        }
        String name = String.valueOf(prefix) + '_' + targetColumnName;
        return name;
    }
}

