/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.basic;

import java.util.Map;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnitProperties;
import org.jboss.tools.hibernate.jpt.core.internal.context.basic.BasicHibernateProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateBasic
extends HibernatePersistenceUnitProperties
implements BasicHibernateProperties {
    private String configFile;
    private String dialect;
    private String driver;
    private String url;
    private String schemaDefault;
    private String catalogDefault;
    private String username;
    private String password;

    public HibernateBasic(PersistenceUnit parent, ListValueModel<PersistenceUnit.Property> propertyListAdapter) {
        super(parent, propertyListAdapter);
    }

    @Override
    protected void initializeProperties() {
        this.configFile = this.getStringValue("hibernate.ejb.cfgfile");
        this.dialect = this.getStringValue("hibernate.dialect");
        this.driver = this.getStringValue("hibernate.connection.driver_class");
        this.url = this.getStringValue("hibernate.connection.url");
        this.schemaDefault = this.getStringValue("hibernate.default_schema");
        this.catalogDefault = this.getStringValue("hibernate.default_catalog");
        this.username = this.getStringValue("hibernate.connection.username");
        this.password = this.getStringValue("hibernate.connection.password");
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("hibernate.ejb.cfgfile", "confFileProperty");
        propertyNames.put("hibernate.dialect", "dialectProperty");
        propertyNames.put("hibernate.connection.driver_class", "driverProperty");
        propertyNames.put("hibernate.connection.url", "urlProperty");
        propertyNames.put("hibernate.default_schema", "schemaDefaultProperty");
        propertyNames.put("hibernate.default_catalog", "catalogDefaultProperty");
        propertyNames.put("hibernate.connection.username", "usernameProperty");
        propertyNames.put("hibernate.connection.password", "passwordProperty");
    }

    public void propertyChanged(PropertyChangeEvent event) {
        String aspectName = event.getAspectName();
        if (aspectName.equals("confFileProperty")) {
            this.configurationFileChanged(event);
        } else if (aspectName.equals("dialectProperty")) {
            this.dialectChanged(event);
        } else if (aspectName.equals("driverProperty")) {
            this.driverChanged(event);
        } else if (aspectName.equals("urlProperty")) {
            this.urlChanged(event);
        } else if (aspectName.equals("schemaDefaultProperty")) {
            this.schemaDefaultChanged(event);
        } else if (aspectName.equals("catalogDefaultProperty")) {
            this.catalogDefaultChanged(event);
        } else if (aspectName.equals("usernameProperty")) {
            this.usernameChanged(event);
        } else if (aspectName.equals("passwordProperty")) {
            this.passwordChanged(event);
        }
    }

    @Override
    public String getDefaultConfigurationFile() {
        return "";
    }

    @Override
    public String getConfigurationFile() {
        return this.configFile;
    }

    @Override
    public void setConfigurationFile(String newConfigFile) {
        if (!this.valueWasChanged(this.configFile, newConfigFile)) {
            return;
        }
        String old = this.configFile;
        this.configFile = newConfigFile;
        this.putProperty("confFileProperty", newConfigFile);
        this.firePropertyChanged("confFileProperty", old, newConfigFile);
    }

    private void configurationFileChanged(PropertyChangeEvent event) {
        String newFile = event.getNewValue() == null ? null : ((PersistenceUnit.Property)event.getNewValue()).getValue();
        String old = this.configFile;
        this.configFile = newFile;
        this.firePropertyChanged(event.getAspectName(), old, newFile);
    }

    @Override
    public String getDefaultDialect() {
        return "";
    }

    @Override
    public String getDialect() {
        return this.dialect;
    }

    @Override
    public void setDialect(String newDialect) {
        if (!this.valueWasChanged(this.dialect, newDialect)) {
            return;
        }
        String old = this.dialect;
        this.dialect = newDialect;
        this.putProperty("dialectProperty", newDialect);
        this.firePropertyChanged("dialectProperty", old, newDialect);
    }

    private void dialectChanged(PropertyChangeEvent event) {
        String newDialect = event.getNewValue() == null ? null : ((PersistenceUnit.Property)event.getNewValue()).getValue();
        String old = this.dialect;
        this.dialect = newDialect;
        this.firePropertyChanged(event.getAspectName(), old, newDialect);
    }

    @Override
    public String getDefaultDriver() {
        return "";
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public void setDriver(String newDriver) {
        if (!this.valueWasChanged(this.driver, newDriver)) {
            return;
        }
        String old = this.driver;
        this.driver = newDriver;
        this.putProperty("driverProperty", newDriver);
        this.firePropertyChanged("driverProperty", old, newDriver);
    }

    private void driverChanged(PropertyChangeEvent event) {
        String newDriver = event.getNewValue() == null ? null : ((PersistenceUnit.Property)event.getNewValue()).getValue();
        String old = this.driver;
        this.driver = newDriver;
        this.firePropertyChanged(event.getAspectName(), old, newDriver);
    }

    @Override
    public String getDefaultUrl() {
        return "";
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String newUrl) {
        if (!this.valueWasChanged(this.url, newUrl)) {
            return;
        }
        String old = this.url;
        this.url = newUrl;
        this.putProperty("urlProperty", newUrl);
        this.firePropertyChanged("urlProperty", old, newUrl);
    }

    private void urlChanged(PropertyChangeEvent event) {
        String newUrl = event.getNewValue() == null ? null : ((PersistenceUnit.Property)event.getNewValue()).getValue();
        String old = this.url;
        this.url = newUrl;
        this.firePropertyChanged(event.getAspectName(), old, newUrl);
    }

    @Override
    public String getDefaultSchemaDefault() {
        return "";
    }

    @Override
    public String getSchemaDefault() {
        return this.schemaDefault;
    }

    @Override
    public void setSchemaDefault(String newSchemaDefault) {
        if (!this.valueWasChanged(this.schemaDefault, newSchemaDefault)) {
            return;
        }
        String old = this.schemaDefault;
        this.schemaDefault = newSchemaDefault;
        this.putProperty("schemaDefaultProperty", newSchemaDefault);
        this.firePropertyChanged("schemaDefaultProperty", old, newSchemaDefault);
    }

    private void schemaDefaultChanged(PropertyChangeEvent event) {
        String newSchemaDefault = event.getNewValue() == null ? null : ((PersistenceUnit.Property)event.getNewValue()).getValue();
        String old = this.schemaDefault;
        this.schemaDefault = newSchemaDefault;
        this.firePropertyChanged(event.getAspectName(), old, newSchemaDefault);
    }

    @Override
    public String getDefaultCatalogDefault() {
        return "";
    }

    @Override
    public String getCatalogDefault() {
        return this.catalogDefault;
    }

    @Override
    public void setCatalogDefault(String newCatalogDefault) {
        if (!this.valueWasChanged(this.catalogDefault, newCatalogDefault)) {
            return;
        }
        String old = this.catalogDefault;
        this.catalogDefault = newCatalogDefault;
        this.putProperty("catalogDefaultProperty", newCatalogDefault);
        this.firePropertyChanged("catalogDefaultProperty", old, newCatalogDefault);
    }

    private void catalogDefaultChanged(PropertyChangeEvent event) {
        String newCatalogDefault = event.getNewValue() == null ? null : ((PersistenceUnit.Property)event.getNewValue()).getValue();
        String old = this.catalogDefault;
        this.catalogDefault = newCatalogDefault;
        this.firePropertyChanged(event.getAspectName(), old, newCatalogDefault);
    }

    @Override
    public String getDefaultUsername() {
        return "";
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String newUsername) {
        if (!this.valueWasChanged(this.username, newUsername)) {
            return;
        }
        String old = this.username;
        this.username = newUsername;
        this.putProperty("usernameProperty", newUsername);
        this.firePropertyChanged("usernameProperty", old, newUsername);
    }

    private void usernameChanged(PropertyChangeEvent event) {
        String newUsername = event.getNewValue() == null ? null : ((PersistenceUnit.Property)event.getNewValue()).getValue();
        String old = this.username;
        this.username = newUsername;
        this.firePropertyChanged(event.getAspectName(), old, newUsername);
    }

    @Override
    public String getDefaultPassword() {
        return "";
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String newPassword) {
        if (!this.valueWasChanged(this.password, newPassword)) {
            return;
        }
        String old = this.password;
        this.password = newPassword;
        this.putProperty("passwordProperty", newPassword);
        this.firePropertyChanged("passwordProperty", old, newPassword);
    }

    private void passwordChanged(PropertyChangeEvent event) {
        String newPassword = event.getNewValue() == null ? null : ((PersistenceUnit.Property)event.getNewValue()).getValue();
        String old = this.password;
        this.password = newPassword;
        this.firePropertyChanged(event.getAspectName(), old, newPassword);
    }

    @Override
    public void updateProperties() {
        this.setConfigurationFile(this.getStringValue("hibernate.ejb.cfgfile"));
        this.setDialect(this.getStringValue("hibernate.dialect"));
        this.setDriver(this.getStringValue("hibernate.connection.driver_class"));
        this.setUrl(this.getStringValue("hibernate.connection.url"));
        this.setSchemaDefault(this.getStringValue("hibernate.default_schema"));
        this.setCatalogDefault(this.getStringValue("hibernate.default_catalog"));
        this.setUsername(this.getStringValue("hibernate.connection.username"));
        this.setPassword(this.getStringValue("hibernate.connection.password"));
    }

    private boolean valueWasChanged(String oldValue, String newValue) {
        return oldValue == null ? newValue != null : !oldValue.equals(newValue);
    }
}

