/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaBasicMapping;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaFactory;
import org.jboss.tools.hibernate.jpt.core.internal.context.GenerationTime;
import org.jboss.tools.hibernate.jpt.core.internal.context.Index;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaBasicMapping;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.GeneratedAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.IndexAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateJavaBasicMappingImpl
extends AbstractJavaBasicMapping
implements HibernateJavaBasicMapping {
    protected GenerationTime specifiedGenerationTime;
    protected Index index;

    public HibernateJavaBasicMappingImpl(JavaPersistentAttribute parent) {
        super(parent);
    }

    public Iterator<String> supportingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.Column", "javax.persistence.Lob", "javax.persistence.Temporal", "javax.persistence.Enumerated", "org.hibernate.annotations.Generated", "org.hibernate.annotations.Index"});
    }

    protected HibernateJpaFactory getJpaFactory() {
        return (HibernateJpaFactory)super.getJpaFactory();
    }

    protected void initialize() {
        super.initialize();
        this.specifiedGenerationTime = this.getResourceGenerationTime();
        this.initializeIndex();
    }

    protected void update() {
        super.update();
        this.setGenerationTime_(this.getResourceGenerationTime());
        this.updateIndex();
    }

    public GeneratedAnnotation getResourceGenerated() {
        return (GeneratedAnnotation)this.getResourcePersistentAttribute().getSupportingAnnotation("org.hibernate.annotations.Generated");
    }

    public GeneratedAnnotation addResourceGenerated() {
        return (GeneratedAnnotation)this.getResourcePersistentAttribute().addSupportingAnnotation("org.hibernate.annotations.Generated");
    }

    public void removeResourceGenerated() {
        this.getResourcePersistentAttribute().removeSupportingAnnotation("org.hibernate.annotations.Generated");
    }

    protected GenerationTime getResourceGenerationTime() {
        GeneratedAnnotation geneatedAnnotation = this.getResourceGenerated();
        return geneatedAnnotation == null ? null : geneatedAnnotation.getValue();
    }

    @Override
    public GenerationTime getGenerationTime() {
        return this.specifiedGenerationTime;
    }

    @Override
    public void setGenerationTime(GenerationTime newValue) {
        GenerationTime oldValue = this.specifiedGenerationTime;
        this.specifiedGenerationTime = newValue;
        if (newValue != null) {
            GeneratedAnnotation annotation = this.getResourceGenerated() != null ? this.getResourceGenerated() : this.addResourceGenerated();
            annotation.setValue(newValue);
        } else {
            this.removeResourceGenerated();
        }
        this.firePropertyChanged("value", (Object)oldValue, (Object)newValue);
    }

    public void setGenerationTime_(GenerationTime newGenerationTime) {
        GenerationTime oldValue = this.specifiedGenerationTime;
        this.specifiedGenerationTime = newGenerationTime;
        this.firePropertyChanged("value", (Object)oldValue, (Object)newGenerationTime);
    }

    public void removeResourceIndex() {
        this.getResourcePersistentAttribute().removeSupportingAnnotation("org.hibernate.annotations.Index");
    }

    protected void initializeIndex() {
        IndexAnnotation indexResource = this.getResourceIndex();
        if (indexResource != null) {
            this.index = this.buildIndex(indexResource);
        }
    }

    protected void updateIndex() {
        IndexAnnotation indexResource = this.getResourceIndex();
        if (indexResource == null) {
            if (this.getIndex() != null) {
                this.setIndex(null);
            }
        } else if (this.getIndex() == null) {
            this.setIndex(this.buildIndex(indexResource));
        } else {
            this.getIndex().update(indexResource);
        }
    }

    @Override
    public Index addIndex() {
        if (this.getIndex() != null) {
            throw new IllegalStateException("index already exists");
        }
        this.index = this.getJpaFactory().buildIndex((JavaJpaContextNode)this);
        IndexAnnotation indexResource = (IndexAnnotation)this.getResourcePersistentAttribute().addSupportingAnnotation("org.hibernate.annotations.Index");
        this.index.initialize(indexResource);
        this.firePropertyChanged("index", null, this.index);
        return this.index;
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    protected void setIndex(Index newIndex) {
        Index oldIndex = this.index;
        this.index = newIndex;
        this.firePropertyChanged("index", oldIndex, newIndex);
    }

    @Override
    public void removeIndex() {
        if (this.getIndex() == null) {
            throw new IllegalStateException("index does not exist, cannot be removed");
        }
        Index oldIndex = this.index;
        this.index = null;
        this.getResourcePersistentAttribute().removeSupportingAnnotation("org.hibernate.annotations.Index");
        this.firePropertyChanged("index", oldIndex, null);
    }

    protected Index buildIndex(IndexAnnotation indexResource) {
        Index index = this.getJpaFactory().buildIndex((JavaJpaContextNode)this);
        index.initialize(indexResource);
        return index;
    }

    protected IndexAnnotation getResourceIndex() {
        return (IndexAnnotation)this.getResourcePersistentAttribute().getSupportingAnnotation("org.hibernate.annotations.Index");
    }
}

