/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.GenericJavaColumn;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;
import org.hibernate.cfg.NamingStrategy;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaColumn;

public class HibernateJavaColumnImpl
extends GenericJavaColumn
implements HibernateJavaColumn {
    public HibernateJavaColumnImpl(JavaJpaContextNode parent, JavaColumn.Owner owner) {
        super(parent, owner);
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    public void initialize(ColumnAnnotation column) {
        super.initialize(column);
    }

    public Column getDbColumn() {
        Table table = this.getDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getDBColumnName());
    }

    public String getDBColumnName() {
        return this.getSpecifiedDBColumnName() != null ? this.getSpecifiedDBColumnName() : this.getDefaultDBColumnName();
    }

    public String getSpecifiedDBColumnName() {
        if (this.getSpecifiedName() == null) {
            return null;
        }
        NamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.columnName(this.getSpecifiedName());
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.getSpecifiedName();
    }

    public String getDefaultDBColumnName() {
        return this.getDefaultName();
    }

    protected String buildDefaultName() {
        NamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null && super.buildDefaultName() != null) {
            try {
                return ns.propertyToColumnName(super.buildDefaultName());
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return super.buildDefaultName();
    }

    public String getDBTableName() {
        return this.getSpecifiedDBTableName() != null ? this.getSpecifiedDBTableName() : this.getDefaultDBTableName();
    }

    public String getDefaultDBTableName() {
        return this.getDefaultTable();
    }

    public String getSpecifiedDBTableName() {
        if (this.getSpecifiedTable() == null) {
            return null;
        }
        NamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.tableName(this.getSpecifiedTable());
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.getSpecifiedTable();
    }
}

