/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaDiscriminatorColumn;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.internal.context.java.GenericJavaDiscriminatorColumn;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.hibernate.cfg.NamingStrategy;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaDiscriminatorColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateJavaDiscriminatorColumnImpl
extends GenericJavaDiscriminatorColumn
implements HibernateJavaDiscriminatorColumn {
    public HibernateJavaDiscriminatorColumnImpl(JavaEntity parent, JavaDiscriminatorColumn.Owner owner) {
        super(parent, owner);
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    public Column getDbColumn() {
        Table table = this.getDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getDBColumnName());
    }

    @Override
    public String getDBColumnName() {
        return this.getSpecifiedDBColumnName() != null ? this.getSpecifiedDBColumnName() : this.getDefaultDBColumnName();
    }

    @Override
    public String getSpecifiedDBColumnName() {
        if (this.getSpecifiedName() == null) {
            return null;
        }
        NamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.columnName(this.getSpecifiedName());
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.getSpecifiedName();
    }

    @Override
    public String getDefaultDBColumnName() {
        return this.getDefaultName();
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.connectionProfileIsActive() && !this.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"DISCRIMINATOR_COLUMN_UNRESOLVED_NAME", (String[])new String[]{this.getDBColumnName()}, (Object)this, (TextRange)this.getNameTextRange(astRoot)));
        }
    }
}

