/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.GenericJavaNamedQuery;
import org.eclipse.jpt.core.resource.java.NamedQueryAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.context.CacheModeType;
import org.jboss.tools.hibernate.jpt.core.internal.context.FlushModeType;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateNamedQuery;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.HibernateNamedQueryAnnotation;

public class HibernateNamedQueryImpl
extends GenericJavaNamedQuery
implements HibernateNamedQuery {
    private FlushModeType specifiedFlushMode;
    private CacheModeType specifiedCacheMode;
    private Boolean specifiedCacheable;
    private String specifiedCacheRegion;
    private Integer specifiedFetchSize;
    private Integer specifiedTimeout;
    private String specifiedComment;
    private Boolean specifiedReadOnly;

    public HibernateNamedQueryImpl(JavaJpaContextNode parent) {
        super(parent);
    }

    public void initialize(HibernateNamedQueryAnnotation resourceQuery) {
        this.specifiedFlushMode = this.getResourceFlushMode(resourceQuery);
        this.specifiedCacheMode = this.getResourceCacheMode(resourceQuery);
        this.specifiedCacheable = resourceQuery.isCacheable();
        this.specifiedCacheRegion = resourceQuery.getCacheRegion();
        this.specifiedFetchSize = resourceQuery.getFetchSize();
        this.specifiedTimeout = resourceQuery.getTimeout();
        this.specifiedComment = resourceQuery.getComment();
        this.specifiedReadOnly = resourceQuery.isReadOnly();
        super.initialize((NamedQueryAnnotation)resourceQuery);
    }

    public void update(HibernateNamedQueryAnnotation resourceQuery) {
        this.setFlushMode_(resourceQuery.getFlushMode());
        this.setCacheMode_(resourceQuery.getCacheMode());
        this.setSpecifiedCacheable_(resourceQuery.isCacheable());
        this.setSpecifiedCacheRegion_(resourceQuery.getCacheRegion());
        this.setSpecifiedFetchSize_(resourceQuery.getFetchSize());
        this.setSpecifiedTimeout_(resourceQuery.getTimeout());
        this.setSpecifiedComment_(resourceQuery.getComment());
        this.setSpecifiedReadOnly_(resourceQuery.isReadOnly());
        super.update((NamedQueryAnnotation)resourceQuery);
    }

    private CacheModeType getResourceCacheMode(HibernateNamedQueryAnnotation resourceQuery) {
        return CacheModeType.fromJavaAnnotationValue(resourceQuery);
    }

    private FlushModeType getResourceFlushMode(HibernateNamedQueryAnnotation resourceQuery) {
        return FlushModeType.fromJavaAnnotationValue(resourceQuery);
    }

    protected HibernateNamedQueryAnnotation getResourceQuery() {
        return (HibernateNamedQueryAnnotation)super.getResourceQuery();
    }

    public FlushModeType getFlushMode() {
        return this.getSpecifiedFlushMode() == null ? this.getDefaultFlushMode() : this.getSpecifiedFlushMode();
    }

    public FlushModeType getSpecifiedFlushMode() {
        return this.specifiedFlushMode;
    }

    public FlushModeType getDefaultFlushMode() {
        return HibernateNamedQuery.DEFAULT_FLUSH_MODE_TYPE;
    }

    public void setSpecifiedFlushMode(FlushModeType flushMode) {
        FlushModeType oldFlushMode = this.specifiedFlushMode;
        this.specifiedFlushMode = flushMode;
        this.getResourceQuery().setFlushMode(flushMode);
        this.firePropertyChanged("specifiedFlushMode", (Object)oldFlushMode, (Object)flushMode);
    }

    protected void setFlushMode_(FlushModeType flushMode) {
        FlushModeType oldFlushMode = this.specifiedFlushMode;
        this.specifiedFlushMode = flushMode;
        this.firePropertyChanged("specifiedFlushMode", (Object)oldFlushMode, (Object)flushMode);
    }

    public CacheModeType getCacheMode() {
        return this.getSpecifiedCacheMode() == null ? this.getDefaultCacheMode() : this.getSpecifiedCacheMode();
    }

    public CacheModeType getDefaultCacheMode() {
        return HibernateNamedQuery.DEFAULT_CACHE_MODE_TYPE;
    }

    public CacheModeType getSpecifiedCacheMode() {
        return this.specifiedCacheMode;
    }

    public void setSpecifiedCacheMode(CacheModeType cacheMode) {
        CacheModeType oldCacheMode = this.specifiedCacheMode;
        this.specifiedCacheMode = cacheMode;
        this.getResourceQuery().setCacheMode(cacheMode);
        this.firePropertyChanged("specifiedCacheMode", (Object)oldCacheMode, (Object)cacheMode);
    }

    public void setCacheMode_(CacheModeType cacheMode) {
        CacheModeType oldCacheMode = this.specifiedCacheMode;
        this.specifiedCacheMode = cacheMode;
        this.firePropertyChanged("specifiedCacheMode", (Object)oldCacheMode, (Object)cacheMode);
    }

    public boolean isCacheable() {
        return this.getSpecifiedCacheable() == null ? this.isDefaultCacheable() : this.getSpecifiedCacheable().booleanValue();
    }

    public Boolean getSpecifiedCacheable() {
        return this.specifiedCacheable;
    }

    public void setSpecifiedCacheable(Boolean newSpecifiedCacheable) {
        Boolean oldSpecifiedCacheable = this.specifiedCacheable;
        this.specifiedCacheable = newSpecifiedCacheable;
        this.getResourceQuery().setCacheable(newSpecifiedCacheable);
        this.firePropertyChanged("specifiedCacheable", oldSpecifiedCacheable, newSpecifiedCacheable);
    }

    public void setSpecifiedCacheable_(Boolean newSpecifiedCacheable) {
        Boolean oldSpecifiedCacheable = this.specifiedCacheable;
        this.specifiedCacheable = newSpecifiedCacheable;
        this.firePropertyChanged("specifiedCacheable", oldSpecifiedCacheable, newSpecifiedCacheable);
    }

    public boolean isDefaultCacheable() {
        return false;
    }

    public String getCacheRegion() {
        return this.getSpecifiedCacheRegion() == null ? this.getDefaultCacheRegion() : this.getSpecifiedCacheRegion();
    }

    public String getSpecifiedCacheRegion() {
        return this.specifiedCacheRegion;
    }

    public void setSpecifiedCacheRegion(String cacheRegion) {
        String oldSpecifiedCacheRegion = this.specifiedCacheRegion;
        this.specifiedCacheRegion = cacheRegion;
        this.getResourceQuery().setCacheRegion(cacheRegion);
        this.firePropertyChanged("specifiedCacheRegion", oldSpecifiedCacheRegion, cacheRegion);
    }

    public void setSpecifiedCacheRegion_(String cacheRegion) {
        String oldSpecifiedCacheRegion = this.specifiedCacheRegion;
        this.specifiedCacheRegion = cacheRegion;
        this.firePropertyChanged("specifiedCacheRegion", oldSpecifiedCacheRegion, cacheRegion);
    }

    public String getDefaultCacheRegion() {
        return "";
    }

    public int getFetchSize() {
        return this.getSpecifiedFetchSize() == null ? this.getDefaultFetchSize() : this.getSpecifiedFetchSize().intValue();
    }

    public Integer getSpecifiedFetchSize() {
        return this.specifiedFetchSize;
    }

    public void setSpecifiedFetchSize(Integer newSpecifiedFetchSize) {
        Integer oldSpecifiedFetchSize = this.specifiedFetchSize;
        this.specifiedFetchSize = newSpecifiedFetchSize;
        this.getResourceQuery().setFetchSize(newSpecifiedFetchSize);
        this.firePropertyChanged("specifiedFetchSize", oldSpecifiedFetchSize, newSpecifiedFetchSize);
    }

    public void setSpecifiedFetchSize_(Integer fetchSize) {
        Integer oldSpecifiedFetchSize = this.specifiedFetchSize;
        this.specifiedFetchSize = fetchSize;
        this.firePropertyChanged("specifiedFetchSize", oldSpecifiedFetchSize, fetchSize);
    }

    public int getDefaultFetchSize() {
        return -1;
    }

    public int getTimeout() {
        return this.getSpecifiedTimeout() == null ? this.getDefaultTimeout() : this.getSpecifiedTimeout().intValue();
    }

    public Integer getSpecifiedTimeout() {
        return this.specifiedTimeout;
    }

    public void setSpecifiedTimeout(Integer newSpecifiedTimeout) {
        Integer oldSpecifiedTimeout = this.specifiedTimeout;
        this.specifiedTimeout = newSpecifiedTimeout;
        this.getResourceQuery().setTimeout(newSpecifiedTimeout);
        this.firePropertyChanged("specifiedTimeout", oldSpecifiedTimeout, newSpecifiedTimeout);
    }

    public void setSpecifiedTimeout_(Integer timeout) {
        Integer oldSpecifiedTimeout = this.specifiedTimeout;
        this.specifiedTimeout = timeout;
        this.firePropertyChanged("specifiedTimeout", oldSpecifiedTimeout, timeout);
    }

    public int getDefaultTimeout() {
        return -1;
    }

    public String getComment() {
        return this.getSpecifiedComment() == null ? this.getDefaultComment() : this.getSpecifiedComment();
    }

    public String getSpecifiedComment() {
        return this.specifiedComment;
    }

    public void setSpecifiedComment(String newSpecifiedComment) {
        String oldSpecifiedComment = this.specifiedComment;
        this.specifiedComment = newSpecifiedComment;
        this.getResourceQuery().setComment(newSpecifiedComment);
        this.firePropertyChanged("specifiedComment", oldSpecifiedComment, newSpecifiedComment);
    }

    public void setSpecifiedComment_(String comment) {
        String oldSpecifiedComment = this.specifiedComment;
        this.specifiedComment = comment;
        this.firePropertyChanged("specifiedComment", oldSpecifiedComment, comment);
    }

    public String getDefaultComment() {
        return "";
    }

    public boolean isReadOnly() {
        return this.getSpecifiedReadOnly() == null ? this.isDefaultReadOnly() : this.getSpecifiedReadOnly().booleanValue();
    }

    public Boolean getSpecifiedReadOnly() {
        return this.specifiedReadOnly;
    }

    public void setSpecifiedReadOnly(Boolean newSpecifiedReadOnly) {
        Boolean oldSpecifiedReadOnly = this.specifiedReadOnly;
        this.specifiedReadOnly = newSpecifiedReadOnly;
        this.getResourceQuery().setReadOnly(newSpecifiedReadOnly);
        this.firePropertyChanged("specifiedReadOnly", oldSpecifiedReadOnly, newSpecifiedReadOnly);
    }

    public void setSpecifiedReadOnly_(Boolean readOnly) {
        Boolean oldSpecifiedReadOnly = this.specifiedReadOnly;
        this.specifiedReadOnly = readOnly;
        this.firePropertyChanged("specifiedReadOnly", oldSpecifiedReadOnly, readOnly);
    }

    public boolean isDefaultReadOnly() {
        return false;
    }
}

