/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinColumnEnabledRelationshipReference;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumnsMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateJoinColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateOrmJoinColumnJoiningStrategy
extends GenericOrmJoinColumnJoiningStrategy {
    public HibernateOrmJoinColumnJoiningStrategy(OrmJoinColumnEnabledRelationshipReference parent, XmlJoinColumnsMapping resource) {
        super(parent, resource);
    }

    protected void validateJoinColumnName(OrmJoinColumn joinColumn, List<IMessage> messages) {
        if (!joinColumn.isResolved() && joinColumn.getDbTable() != null) {
            if (((HibernateJoinColumn)joinColumn).getDBColumnName() != null) {
                if (this.getRelationshipMapping().getPersistentAttribute().isVirtual()) {
                    messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_NAME", (String[])new String[]{this.getRelationshipMapping().getName(), ((HibernateJoinColumn)joinColumn).getDBColumnName()}, (Object)joinColumn, (TextRange)joinColumn.getNameTextRange()));
                } else {
                    messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"JOIN_COLUMN_UNRESOLVED_NAME", (String[])new String[]{((HibernateJoinColumn)joinColumn).getDBColumnName()}, (Object)joinColumn, (TextRange)joinColumn.getNameTextRange()));
                }
            } else if (joinColumn.getOwner().joinColumnsSize() > 1) {
                if (this.getRelationshipMapping().getPersistentAttribute().isVirtual()) {
                    messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_NAME_MULTIPLE_JOIN_COLUMNS", (String[])new String[]{this.getRelationshipMapping().getName()}, (Object)joinColumn, (TextRange)joinColumn.getNameTextRange()));
                } else {
                    messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"JOIN_COLUMN_UNRESOLVED_NAME_MULTIPLE_JOIN_COLUMNS", (Object)joinColumn, (TextRange)joinColumn.getNameTextRange()));
                }
            }
        }
    }

    protected void validationJoinColumnReferencedColumnName(OrmJoinColumn joinColumn, List<IMessage> messages) {
        if (!joinColumn.isReferencedColumnResolved() && joinColumn.getReferencedColumnDbTable() != null) {
            if (((HibernateJoinColumn)joinColumn).getReferencedDBColumnName() != null) {
                if (this.getRelationshipMapping().getPersistentAttribute().isVirtual()) {
                    messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"VIRTUAL_ATTRIBUTE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", (String[])new String[]{this.getRelationshipMapping().getName(), ((HibernateJoinColumn)joinColumn).getReferencedDBColumnName(), ((HibernateJoinColumn)joinColumn).getDBColumnName()}, (Object)joinColumn, (TextRange)joinColumn.getReferencedColumnNameTextRange()));
                } else {
                    messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", (String[])new String[]{((HibernateJoinColumn)joinColumn).getReferencedDBColumnName(), ((HibernateJoinColumn)joinColumn).getDBColumnName()}, (Object)joinColumn, (TextRange)joinColumn.getReferencedColumnNameTextRange()));
                }
            } else if (joinColumn.getOwner().joinColumnsSize() > 1) {
                if (this.getRelationshipMapping().getPersistentAttribute().isVirtual()) {
                    messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"VIRTUAL_ATTRIBUTE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME_MULTIPLE_JOIN_COLUMNS", (String[])new String[]{((HibernateJoinColumn)joinColumn).getReferencedDBColumnName(), ((HibernateJoinColumn)joinColumn).getDBColumnName()}, (Object)joinColumn, (TextRange)joinColumn.getReferencedColumnNameTextRange()));
                } else {
                    messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME_MULTIPLE_JOIN_COLUMNS", (Object)joinColumn, (TextRange)joinColumn.getReferencedColumnNameTextRange()));
                }
            }
        }
    }
}

