/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.orm.OrmJoinTableJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmJoinTable;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.XmlJoinTableMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.hibernate.cfg.NamingStrategy;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.orm.HibernateOrmJoinTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateOrmJoinTableImpl
extends GenericOrmJoinTable
implements HibernateOrmJoinTable {
    public HibernateOrmJoinTableImpl(OrmJoinTableJoiningStrategy parent, XmlJoinTableMapping resourceMapping) {
        super(parent, resourceMapping);
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    public Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getDBTableName());
    }

    @Override
    public String getDBTableName() {
        return this.getSpecifiedDBTableName() != null ? this.getSpecifiedDBTableName() : this.getDefaultDBTableName();
    }

    @Override
    public String getSpecifiedDBTableName() {
        if (this.getSpecifiedName() == null) {
            return null;
        }
        NamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.tableName(this.getSpecifiedName());
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.getName();
    }

    @Override
    public String getDefaultDBTableName() {
        return this.getDefaultName();
    }

    protected void validateAgainstDatabase(List<IMessage> messages, IReporter reporter) {
        OrmRelationshipMapping mapping = this.getRelationshipMapping();
        if (!this.hasResolvedCatalog()) {
            if (mapping.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_CATALOG", (String[])new String[]{mapping.getName(), this.getCatalog(), this.getDBTableName()}, (Object)this, (TextRange)this.getCatalogTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"JOIN_TABLE_UNRESOLVED_CATALOG", (String[])new String[]{this.getCatalog(), this.getDBTableName()}, (Object)this, (TextRange)this.getCatalogTextRange()));
            }
            return;
        }
        if (!this.hasResolvedSchema()) {
            if (mapping.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_SCHEMA", (String[])new String[]{mapping.getName(), this.getSchema(), this.getDBTableName()}, (Object)this, (TextRange)this.getSchemaTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"JOIN_TABLE_UNRESOLVED_SCHEMA", (String[])new String[]{this.getSchema(), this.getDBTableName()}, (Object)this, (TextRange)this.getSchemaTextRange()));
            }
            return;
        }
        if (!this.isResolved()) {
            if (this.getName() != null) {
                if (mapping.getPersistentAttribute().isVirtual()) {
                    messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_NAME", (String[])new String[]{mapping.getName(), this.getDBTableName()}, (Object)this, (TextRange)this.getNameTextRange()));
                } else {
                    messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"JOIN_TABLE_UNRESOLVED_NAME", (String[])new String[]{this.getName()}, (Object)this, (TextRange)this.getNameTextRange()));
                }
            }
            return;
        }
        this.validateJoinColumns(this.joinColumns(), messages, reporter);
        this.validateJoinColumns(this.inverseJoinColumns(), messages, reporter);
    }
}

