/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.DiscriminatorFormulaAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscriminatorFormulaAnnotationImpl
extends SourceAnnotation<Type>
implements DiscriminatorFormulaAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.hibernate.annotations.DiscriminatorFormula");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = DiscriminatorFormulaAnnotationImpl.buildValueAdapter(DECLARATION_ANNOTATION_ADAPTER);
    private final AnnotationElementAdapter<String> valueAdapter = this.buildAdapter(VALUE_ADAPTER);
    private String value;

    protected DiscriminatorFormulaAnnotationImpl(JavaResourceNode parent, Type type) {
        super(parent, (Member)type, DECLARATION_ANNOTATION_ADAPTER);
    }

    public void initialize(CompilationUnit astRoot) {
        this.value = this.buildValue(astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setValue(this.buildValue(astRoot));
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (this.attributeValueHasNotChanged(this.value, value)) {
            return;
        }
        String old = this.value;
        this.value = value;
        this.valueAdapter.setValue((Object)value);
        this.firePropertyChanged("value", old, value);
    }

    private String buildValue(CompilationUnit astRoot) {
        return (String)this.valueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    public String getAnnotationName() {
        return "org.hibernate.annotations.DiscriminatorFormula";
    }

    AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter(this.member, daea);
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter(DeclarationAnnotationAdapter adapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)adapter, (String)"value");
    }

    public static class DiscriminatorFormulaAnnotationDefinition
    implements AnnotationDefinition {
        private static final DiscriminatorFormulaAnnotationDefinition INSTANCE = new DiscriminatorFormulaAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private DiscriminatorFormulaAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member type) {
            return new DiscriminatorFormulaAnnotationImpl((JavaResourceNode)parent, (Type)type);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Type type) {
            throw new UnsupportedOperationException();
        }

        public String getAnnotationName() {
            return "org.hibernate.annotations.DiscriminatorFormula";
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember arg0, IAnnotation arg1) {
            throw new UnsupportedOperationException();
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent) {
            throw new UnsupportedOperationException();
        }
    }
}

