/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.resource.java;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.GenericGeneratorAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.NestableParameterAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.ParameterAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.SourceParameterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericGeneratorAnnotationImpl
extends SourceAnnotation<Member>
implements GenericGeneratorAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.hibernate.annotations.GenericGenerator");
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter;
    private String name;
    private final DeclarationAnnotationElementAdapter<String> strategyDeclarationAdapter;
    private final AnnotationElementAdapter<String> strategyAdapter;
    private String strategy;
    final Vector<NestableParameterAnnotation> parameters = new Vector();
    final ParametersAnnotationContainer parametersContainer = new ParametersAnnotationContainer();

    public GenericGeneratorAnnotationImpl(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameAdapter(daa);
        this.nameAdapter = new ShortCircuitAnnotationElementAdapter(member, this.nameDeclarationAdapter);
        this.strategyDeclarationAdapter = this.buildStrategyAdapter(daa);
        this.strategyAdapter = new ShortCircuitAnnotationElementAdapter(member, this.strategyDeclarationAdapter);
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.name(astRoot);
        this.strategy = this.strategy(astRoot);
        AnnotationContainerTools.initialize((AnnotationContainer)this.parametersContainer, (CompilationUnit)astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setStrategy(this.strategy(astRoot));
        this.setName(this.name(astRoot));
        AnnotationContainerTools.update((AnnotationContainer)this.parametersContainer, (CompilationUnit)astRoot);
    }

    public String getAnnotationName() {
        return "org.hibernate.annotations.GenericGenerator";
    }

    @Override
    public String getStrategy() {
        return this.strategy;
    }

    @Override
    public void setStrategy(String newStrategy) {
        if (this.attributeValueHasNotChanged(this.strategy, newStrategy)) {
            return;
        }
        String oldStrategy = this.strategy;
        this.strategy = newStrategy;
        this.strategyAdapter.setValue((Object)newStrategy);
        this.firePropertyChanged("strategyProperty", oldStrategy, newStrategy);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (this.attributeValueHasNotChanged(this.name, newName)) {
            return;
        }
        String oldName = this.name;
        this.name = newName;
        this.nameAdapter.setValue((Object)newName);
        this.firePropertyChanged("name", oldName, newName);
    }

    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public TextRange getStrategyTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.strategyDeclarationAdapter, astRoot);
    }

    public Integer getAllocationSize() {
        return null;
    }

    public TextRange getAllocationSizeTextRange(CompilationUnit astRoot) {
        return null;
    }

    public Integer getInitialValue() {
        return null;
    }

    public TextRange getInitialValueTextRange(CompilationUnit astRoot) {
        return null;
    }

    public void setAllocationSize(Integer allocationSize) {
        throw new UnsupportedOperationException();
    }

    public void setInitialValue(Integer initialValue) {
        throw new UnsupportedOperationException();
    }

    protected String strategy(CompilationUnit astRoot) {
        return (String)this.strategyAdapter.getValue(astRoot);
    }

    protected String name(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public NestableParameterAnnotation addParameter(int index) {
        return (NestableParameterAnnotation)AnnotationContainerTools.addNestedAnnotation((int)index, (AnnotationContainer)this.parametersContainer);
    }

    NestableParameterAnnotation addParameterInternal() {
        NestableParameterAnnotation parameter = this.buildParameter(this.parameters.size());
        this.parameters.add(parameter);
        return parameter;
    }

    NestableParameterAnnotation buildParameter(int index) {
        return SourceParameterAnnotation.createGenericGeneratorParameter((JavaResourceNode)this, this.member, this.daa, index);
    }

    ListIterator<NestableParameterAnnotation> nestableParameters() {
        return new CloneListIterator(this.parameters);
    }

    void parameterAdded(int index, NestableParameterAnnotation parameter) {
        this.fireItemAdded("parameters", index, parameter);
    }

    NestableParameterAnnotation moveParameterInternal(int targetIndex, int sourceIndex) {
        return (NestableParameterAnnotation)CollectionTools.move(this.parameters, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    void parameterMoved(int targetIndex, int sourceIndex) {
        this.fireItemMoved("parameters", targetIndex, sourceIndex);
    }

    @Override
    public int indexOfParameter(ParameterAnnotation parameter) {
        return this.parameters.indexOf(parameter);
    }

    @Override
    public void moveParameter(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation((int)targetIndex, (int)sourceIndex, (AnnotationContainer)this.parametersContainer);
    }

    @Override
    public ParameterAnnotation parameterAt(int index) {
        return this.parameters.get(index);
    }

    @Override
    public ListIterator<ParameterAnnotation> parameters() {
        return new CloneListIterator(this.parameters);
    }

    @Override
    public int parametersSize() {
        return this.parameters.size();
    }

    @Override
    public void removeParameter(int index) {
        AnnotationContainerTools.removeNestedAnnotation((int)index, (AnnotationContainer)this.parametersContainer);
    }

    NestableParameterAnnotation removeParameterInternal(int index) {
        return this.parameters.remove(index);
    }

    void parameterRemoved(int index, NestableParameterAnnotation parameter) {
        this.fireItemRemoved("parameters", index, parameter);
    }

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        GenericGeneratorAnnotation oldGenericGenerator = (GenericGeneratorAnnotation)oldAnnotation;
        this.setName(oldGenericGenerator.getName());
        this.setStrategy(oldGenericGenerator.getStrategy());
        for (ParameterAnnotation oldParameter : CollectionTools.iterable(oldGenericGenerator.parameters())) {
            NestableParameterAnnotation newParameter = this.addParameter(oldGenericGenerator.indexOfParameter(oldParameter));
            newParameter.initializeFrom((NestableParameterAnnotation)oldParameter);
        }
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.name);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"name", (boolean)false);
    }

    private DeclarationAnnotationElementAdapter<String> buildStrategyAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"strategy", (boolean)false);
    }

    public static GenericGeneratorAnnotation createNestedGenericGenerator(JavaResourceNode parent, Member member, int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = GenericGeneratorAnnotationImpl.buildNestedHibernateDeclarationAnnotationAdapter(index, attributeOverridesAdapter);
        MemberIndexedAnnotationAdapter annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        return new GenericGeneratorAnnotationImpl(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    private static IndexedDeclarationAnnotationAdapter buildNestedHibernateDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter hibernateGenericGeneratorsAdapter) {
        return new NestedIndexedDeclarationAnnotationAdapter(hibernateGenericGeneratorsAdapter, index, "org.hibernate.annotations.GenericGenerator");
    }

    public static class GenericGeneratorAnnotationDefinition
    implements AnnotationDefinition {
        private static final GenericGeneratorAnnotationDefinition INSTANCE = new GenericGeneratorAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private GenericGeneratorAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new GenericGeneratorAnnotationImpl((JavaResourceNode)parent, member, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new MemberAnnotationAdapter(member, DECLARATION_ANNOTATION_ADAPTER));
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            throw new UnsupportedOperationException();
        }

        public String getAnnotationName() {
            return "org.hibernate.annotations.GenericGenerator";
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember arg0, IAnnotation arg1) {
            throw new UnsupportedOperationException();
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember arg0) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ParametersAnnotationContainer
    implements AnnotationContainer<NestableParameterAnnotation> {
        ParametersAnnotationContainer() {
        }

        public String getContainerAnnotationName() {
            return GenericGeneratorAnnotationImpl.this.getAnnotationName();
        }

        public org.eclipse.jdt.core.dom.Annotation getContainerJdtAnnotation(CompilationUnit astRoot) {
            return GenericGeneratorAnnotationImpl.this.getJdtAnnotation(astRoot);
        }

        public String getElementName() {
            return "parameters";
        }

        public String getNestableAnnotationName() {
            return "org.hibernate.annotations.Parameter";
        }

        public ListIterator<NestableParameterAnnotation> nestedAnnotations() {
            return GenericGeneratorAnnotationImpl.this.nestableParameters();
        }

        public int nestedAnnotationsSize() {
            return GenericGeneratorAnnotationImpl.this.parametersSize();
        }

        public NestableParameterAnnotation addNestedAnnotationInternal() {
            return GenericGeneratorAnnotationImpl.this.addParameterInternal();
        }

        public void nestedAnnotationAdded(int index, NestableParameterAnnotation nestedAnnotation) {
            GenericGeneratorAnnotationImpl.this.parameterAdded(index, nestedAnnotation);
        }

        public NestableParameterAnnotation moveNestedAnnotationInternal(int targetIndex, int sourceIndex) {
            return GenericGeneratorAnnotationImpl.this.moveParameterInternal(targetIndex, sourceIndex);
        }

        public void nestedAnnotationMoved(int targetIndex, int sourceIndex) {
            GenericGeneratorAnnotationImpl.this.parameterMoved(targetIndex, sourceIndex);
        }

        public NestableParameterAnnotation removeNestedAnnotationInternal(int index) {
            return GenericGeneratorAnnotationImpl.this.removeParameterInternal(index);
        }

        public void nestedAnnotationRemoved(int index, NestableParameterAnnotation nestedAnnotation) {
            GenericGeneratorAnnotationImpl.this.parameterRemoved(index, nestedAnnotation);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

