/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.DOMWriter;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.osgi.util.NLS;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.console.ConsoleConfigClassLoader;
import org.hibernate.console.ConsoleConfigurationListener;
import org.hibernate.console.ConsoleMessages;
import org.hibernate.console.FakeDelegatingDriver;
import org.hibernate.console.HQLQueryPage;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.JavaPage;
import org.hibernate.console.QueryInputModel;
import org.hibernate.console.QueryPage;
import org.hibernate.console.execution.DefaultExecutionContext;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.console.execution.ExecutionContextHolder;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.DialectFactory;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.hibernate.util.XMLHelper;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class ConsoleConfiguration
implements ExecutionContextHolder {
    private ExecutionContext executionContext;
    private ConsoleConfigClassLoader classLoader = null;
    private Map<String, FakeDelegatingDriver> fakeDrivers = new HashMap<String, FakeDelegatingDriver>();
    private Configuration configuration;
    private SessionFactory sessionFactory;
    public ConsoleConfigurationPreferences prefs = null;
    int execcount;
    List<ConsoleConfigurationListener> consoleCfgListeners = new ArrayList<ConsoleConfigurationListener>();

    public String getName() {
        return this.prefs.getName();
    }

    public ConsoleConfiguration(ConsoleConfigurationPreferences config) {
        this.prefs = config;
    }

    public Object execute(ExecutionContext.Command c) {
        return this.executionContext.execute(c);
    }

    public void reset() {
        this.configuration = null;
        this.closeSessionFactory();
        if (this.executionContext != null) {
            this.executionContext.execute(new ExecutionContext.Command(){

                public Object execute() {
                    Iterator it = ConsoleConfiguration.this.fakeDrivers.values().iterator();
                    while (it.hasNext()) {
                        try {
                            DriverManager.deregisterDriver((Driver)it.next());
                        }
                        catch (SQLException sQLException) {}
                    }
                    return null;
                }
            });
        }
        this.fakeDrivers.clear();
        this.cleanUpClassLoader();
        this.fireConfigurationReset();
        this.executionContext = null;
    }

    public void cleanUpClassLoader() {
        ClassLoader classLoaderTmp = this.classLoader;
        while (classLoaderTmp != null) {
            if (classLoaderTmp instanceof ConsoleConfigClassLoader) {
                classLoaderTmp.close();
            }
            classLoaderTmp = classLoaderTmp.getParent();
        }
        this.classLoader = null;
    }

    public void build() {
        this.configuration = this.buildWith(null, true);
        this.fireConfigurationBuilt();
    }

    private Configuration buildJPAConfiguration(String persistenceUnit, Properties properties, String entityResolver, boolean includeMappings) {
        if (StringHelper.isEmpty((String)persistenceUnit)) {
            persistenceUnit = null;
        }
        try {
            HashMap<Object, Object> overrides = new HashMap<Object, Object>();
            if (properties != null) {
                overrides.putAll(properties);
            }
            if (StringHelper.isNotEmpty((String)this.prefs.getNamingStrategy())) {
                overrides.put("hibernate.ejb.naming_strategy", this.prefs.getNamingStrategy());
            }
            if (StringHelper.isNotEmpty((String)this.prefs.getDialectName())) {
                overrides.put("hibernate.dialect", this.prefs.getDialectName());
            }
            if (!includeMappings) {
                overrides.put("hibernate.archive.autodetection", "none");
            }
            Class clazz = ReflectHelper.classForName((String)"org.hibernate.ejb.Ejb3Configuration", ConsoleConfiguration.class);
            Object ejb3cfg = clazz.newInstance();
            if (StringHelper.isNotEmpty((String)entityResolver)) {
                Class resolver = ReflectHelper.classForName((String)entityResolver, this.getClass());
                Object object = resolver.newInstance();
                Method method = clazz.getMethod("setEntityResolver", EntityResolver.class);
                method.invoke(ejb3cfg, object);
            }
            Method method = clazz.getMethod("configure", String.class, Map.class);
            if (method.invoke(ejb3cfg, persistenceUnit, overrides) == null) {
                String out = NLS.bind((String)ConsoleMessages.ConsoleConfiguration_persistence_unit_not_found, (Object)persistenceUnit);
                throw new HibernateConsoleRuntimeException(out);
            }
            method = clazz.getMethod("getHibernateConfiguration", new Class[0]);
            Configuration invoke = (Configuration)method.invoke(ejb3cfg, null);
            invoke = this.configureConnectionProfile(invoke);
            return invoke;
        }
        catch (HibernateConsoleRuntimeException he) {
            throw he;
        }
        catch (Exception e) {
            throw new HibernateConsoleRuntimeException(ConsoleMessages.ConsoleConfiguration_could_not_create_jpa_based_configuration, e);
        }
    }

    private Configuration buildAnnotationConfiguration() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class clazz = ReflectHelper.classForName((String)"org.hibernate.cfg.AnnotationConfiguration");
        Configuration newInstance = (Configuration)clazz.newInstance();
        return newInstance;
    }

    protected void refreshProfile(IConnectionProfile profile) {
        if (profile.getConnectionState() == 1) {
            profile.disconnect(null);
        }
        profile.connect(null);
    }

    protected String getConnectionProfileDriverURL() {
        String connectionProfile = this.prefs.getConnectionProfileName();
        if (connectionProfile == null) {
            return null;
        }
        IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(connectionProfile);
        if (profile == null) {
            return null;
        }
        this.refreshProfile(profile);
        Properties cpProperties = profile.getProperties(profile.getProviderId());
        String driverJarPath = cpProperties.getProperty("jarList");
        return driverJarPath;
    }

    protected URL[] getCustomClassPathURLs() {
        boolean insertFlag;
        URL[] customClassPathURLsTmp = this.prefs.getCustomClassPathURLS();
        URL[] customClassPathURLs = null;
        String driverURL = this.getConnectionProfileDriverURL();
        URL url = null;
        if (driverURL != null) {
            try {
                url = new URL("file:/" + driverURL);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        boolean bl = insertFlag = url != null;
        if (insertFlag) {
            int i = 0;
            while (i < customClassPathURLsTmp.length) {
                if (url.equals(customClassPathURLsTmp[i])) {
                    insertFlag = false;
                    break;
                }
                ++i;
            }
        }
        if (insertFlag) {
            customClassPathURLs = new URL[customClassPathURLsTmp.length + 1];
            System.arraycopy(customClassPathURLsTmp, 0, customClassPathURLs, 0, customClassPathURLsTmp.length);
            customClassPathURLs[customClassPathURLsTmp.length] = url;
        } else {
            customClassPathURLs = customClassPathURLsTmp;
        }
        return customClassPathURLs;
    }

    protected ConsoleConfigClassLoader createClassLoader() {
        final URL[] customClassPathURLs = this.getCustomClassPathURLs();
        ConsoleConfigClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ConsoleConfigClassLoader>(){

            @Override
            public ConsoleConfigClassLoader run() {
                return new ConsoleConfigClassLoader(customClassPathURLs, ConsoleConfiguration.this.getParentClassLoader()){

                    @Override
                    protected Class<?> findClass(String name) throws ClassNotFoundException {
                        return super.findClass(name);
                    }

                    @Override
                    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                        return super.loadClass(name, resolve);
                    }

                    @Override
                    public Class<?> loadClass(String name) throws ClassNotFoundException {
                        return super.loadClass(name);
                    }
                };
            }
        });
        return classLoader;
    }

    public Configuration buildWith(final Configuration cfg, final boolean includeMappings) {
        if (this.classLoader == null) {
            this.classLoader = this.createClassLoader();
        }
        this.executionContext = new DefaultExecutionContext(this.getName(), this.classLoader);
        Configuration result = (Configuration)this.executionContext.execute(new ExecutionContext.Command(){

            public Object execute() {
                String str;
                Configuration localCfg = cfg;
                Properties properties = ConsoleConfiguration.this.prefs.getProperties();
                if (properties != null && (str = properties.getProperty("hibernate.transaction.manager_lookup_class")) != null && StringHelper.isEmpty((String)str)) {
                    properties.setProperty("hibernate.transaction.manager_lookup_class", "org.hibernate.console.FakeTransactionManagerLookup");
                }
                if (localCfg == null) {
                    localCfg = ConsoleConfiguration.this.buildConfiguration(properties, includeMappings);
                }
                ConsoleConfiguration.this.registerFakeDriver(localCfg.getProperty("hibernate.connection.driver_class"));
                if (includeMappings) {
                    File[] mappingFiles = ConsoleConfiguration.this.prefs.getMappingFiles();
                    int i = 0;
                    while (i < mappingFiles.length) {
                        File hbm = mappingFiles[i];
                        localCfg = localCfg.addFile(hbm);
                        ++i;
                    }
                }
                localCfg.setProperty("hibernate.temp.use_jdbc_metadata_defaults", "false");
                localCfg.setProperty("hibernate.hbm2ddl.auto", "false");
                if (localCfg.getProperty("hibernate.search.autoregister_listeners") == null) {
                    localCfg.setProperty("hibernate.search.autoregister_listeners", "false");
                }
                return localCfg;
            }

            private void autoConfigureDialect(Configuration localCfg) {
                if (localCfg.getProperty("hibernate.dialect") == null) {
                    String url = localCfg.getProperty("hibernate.connection.url");
                    String user = localCfg.getProperty("hibernate.connection.username");
                    String pass = localCfg.getProperty("hibernate.connection.password");
                    Connection connection = null;
                    try {
                        connection = DriverManager.getConnection(url, user, pass);
                        Dialect dialect = DialectFactory.buildDialect((Properties)localCfg.getProperties(), (Connection)connection);
                        localCfg.setProperty("hibernate.dialect", dialect.toString());
                    }
                    catch (SQLException sQLException) {}
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        });
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Configuration loadConfigurationXML(Configuration localCfg, boolean includeMappings, EntityResolver entityResolver) {
        File configXMLFile = this.prefs.getConfigXMLFile();
        if (!includeMappings) {
            Configuration configuration;
            XMLHelper xmlHelper = new XMLHelper();
            InputStream stream = null;
            String resourceName = "<unknown>";
            if (configXMLFile != null) {
                resourceName = configXMLFile.toString();
                try {
                    stream = new FileInputStream(configXMLFile);
                }
                catch (FileNotFoundException e1) {
                    throw new HibernateConsoleRuntimeException(String.valueOf(ConsoleMessages.ConsoleConfiguration_could_not_access) + configXMLFile, e1);
                }
            } else {
                resourceName = "/hibernate.cfg.xml";
                if (!this.checkHibernateResoureExistence(resourceName)) return localCfg;
                stream = ConfigHelper.getResourceAsStream((String)resourceName);
            }
            try {
                ArrayList errors = new ArrayList();
                Document doc = xmlHelper.createSAXReader(resourceName, errors, entityResolver).read(new InputSource(stream));
                if (errors.size() != 0) {
                    throw new MappingException(ConsoleMessages.ConsoleConfiguration_invalid_configuration, (Throwable)errors.get(0));
                }
                List list = doc.getRootElement().element("session-factory").elements("mapping");
                Iterator iterator = list.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        DOMWriter dw = new DOMWriter();
                        org.w3c.dom.Document document = dw.write(doc);
                        configuration = localCfg.configure(document);
                        break;
                    }
                    Node element = (Node)iterator.next();
                    element.getParent().remove(element);
                }
            }
            catch (DocumentException e) {
                try {
                    throw new HibernateException(String.valueOf(ConsoleMessages.ConsoleConfiguration_could_not_parse_configuration) + resourceName, (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (stream == null) throw throwable;
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                if (stream == null) return configuration;
                stream.close();
                return configuration;
            }
            catch (IOException iOException) {}
            return configuration;
        }
        if (configXMLFile != null) {
            return localCfg.configure(configXMLFile);
        }
        Configuration resultCfg = localCfg;
        if (!this.checkHibernateResoureExistence("/hibernate.cfg.xml")) return resultCfg;
        return localCfg.configure();
    }

    protected boolean checkHibernateResoureExistence(String resource) {
        InputStream is;
        block14: {
            is = null;
            try {
                try {
                    is = ConfigHelper.getResourceAsStream((String)resource);
                }
                catch (HibernateException hibernateException) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return is != null;
    }

    private void registerFakeDriver(String driverClassName) {
        if (driverClassName != null) {
            try {
                Class driverClass = ReflectHelper.classForName((String)driverClassName);
                if (!this.fakeDrivers.containsKey(driverClassName)) {
                    FakeDelegatingDriver fakeDelegatingDriver = new FakeDelegatingDriver((Driver)driverClass.newInstance());
                    DriverManager.registerDriver(fakeDelegatingDriver);
                    this.fakeDrivers.put(driverClassName, fakeDelegatingDriver);
                }
            }
            catch (ClassNotFoundException e) {
                String out = NLS.bind((String)ConsoleMessages.ConsoleConfiguration_problems_while_loading_database_driverclass, (Object)driverClassName);
                throw new HibernateConsoleRuntimeException(out, e);
            }
            catch (InstantiationException e) {
                String out = NLS.bind((String)ConsoleMessages.ConsoleConfiguration_problems_while_loading_database_driverclass, (Object)driverClassName);
                throw new HibernateConsoleRuntimeException(out, e);
            }
            catch (IllegalAccessException e) {
                String out = NLS.bind((String)ConsoleMessages.ConsoleConfiguration_problems_while_loading_database_driverclass, (Object)driverClassName);
                throw new HibernateConsoleRuntimeException(out, e);
            }
            catch (SQLException e) {
                String out = NLS.bind((String)ConsoleMessages.ConsoleConfiguration_problems_while_loading_database_driverclass, (Object)driverClassName);
                throw new HibernateConsoleRuntimeException(out, e);
            }
        }
    }

    protected ClassLoader getParentClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public void buildSessionFactory() {
        this.execute(new ExecutionContext.Command(){

            public Object execute() {
                if (ConsoleConfiguration.this.sessionFactory != null) {
                    throw new HibernateConsoleRuntimeException(ConsoleMessages.ConsoleConfiguration_factory_not_closed_before_build_new_factory);
                }
                ConsoleConfiguration.this.sessionFactory = ConsoleConfiguration.this.getConfiguration().buildSessionFactory();
                ConsoleConfiguration.this.fireFactoryBuilt();
                return null;
            }
        });
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public QueryPage executeHQLQuery(String hql) {
        return this.executeHQLQuery(hql, new QueryInputModel());
    }

    public QueryPage executeHQLQuery(final String hql, final QueryInputModel queryParameters) {
        return (QueryPage)this.executionContext.execute(new ExecutionContext.Command(){

            public Object execute() {
                org.hibernate.classic.Session session = ConsoleConfiguration.this.getSessionFactory().openSession();
                HQLQueryPage qp = new HQLQueryPage(ConsoleConfiguration.this, hql, queryParameters);
                qp.setSession((Session)session);
                qp.setId(++ConsoleConfiguration.this.execcount);
                ConsoleConfiguration.this.fireQueryPageCreated(qp);
                return qp;
            }
        });
    }

    public QueryPage executeBSHQuery(final String queryString, final QueryInputModel model) {
        return (QueryPage)this.executionContext.execute(new ExecutionContext.Command(){

            public Object execute() {
                org.hibernate.classic.Session session = ConsoleConfiguration.this.getSessionFactory().openSession();
                JavaPage qp = new JavaPage(ConsoleConfiguration.this, queryString, model);
                qp.setSession((Session)session);
                qp.setId(++ConsoleConfiguration.this.execcount);
                ConsoleConfiguration.this.fireQueryPageCreated(qp);
                return qp;
            }
        });
    }

    private void fireConfigurationBuilt() {
        for (ConsoleConfigurationListener view : this.consoleCfgListeners) {
            view.configurationBuilt(this);
        }
    }

    private void fireConfigurationReset() {
        for (ConsoleConfigurationListener view : this.consoleCfgListeners) {
            view.configurationReset(this);
        }
    }

    private void fireQueryPageCreated(QueryPage qp) {
        for (ConsoleConfigurationListener view : this.consoleCfgListeners) {
            view.queryPageCreated(qp);
        }
    }

    private void fireFactoryBuilt() {
        for (ConsoleConfigurationListener view : this.consoleCfgListeners) {
            view.sessionFactoryBuilt(this, this.sessionFactory);
        }
    }

    private void fireFactoryClosing(SessionFactory sessionFactory2) {
        for (ConsoleConfigurationListener view : this.consoleCfgListeners) {
            view.sessionFactoryClosing(this, sessionFactory2);
        }
    }

    public void addConsoleConfigurationListener(ConsoleConfigurationListener v) {
        this.consoleCfgListeners.add(v);
    }

    public void removeConsoleConfigurationListener(ConsoleConfigurationListener sfListener) {
        this.consoleCfgListeners.remove(sfListener);
    }

    public ConsoleConfigurationListener[] getConsoleConfigurationListeners() {
        return this.consoleCfgListeners.toArray(new ConsoleConfigurationListener[this.consoleCfgListeners.size()]);
    }

    public boolean isSessionFactoryCreated() {
        return this.sessionFactory != null;
    }

    public ConsoleConfigurationPreferences getPreferences() {
        return this.prefs;
    }

    public File getConfigXMLFile() {
        URI uri;
        URL url;
        File configXMLFile = null;
        if (this.prefs != null) {
            configXMLFile = this.prefs.getConfigXMLFile();
        }
        if (configXMLFile == null && this.classLoader != null && (url = this.classLoader.findResource("hibernate.cfg.xml")) != null) {
            uri = null;
            try {
                uri = url.toURI();
                configXMLFile = new File(uri);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        if (configXMLFile == null && (url = Environment.class.getClassLoader().getResource("hibernate.cfg.xml")) != null) {
            uri = null;
            try {
                uri = url.toURI();
                configXMLFile = new File(uri);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return configXMLFile;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ":" + this.getName();
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void closeSessionFactory() {
        if (this.sessionFactory != null) {
            this.fireFactoryClosing(this.sessionFactory);
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
    }

    public Settings getSettings(final Configuration cfg) {
        return (Settings)this.execute(new ExecutionContext.Command(){

            public Object execute() {
                return cfg.buildSettings();
            }
        });
    }

    private Configuration buildConfiguration(Properties properties, boolean includeMappings) {
        Configuration localCfg = null;
        if (this.prefs.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.ANNOTATIONS)) {
            try {
                localCfg = this.buildAnnotationConfiguration();
                localCfg = this.configureStandardConfiguration(includeMappings, localCfg, properties);
            }
            catch (HibernateConsoleRuntimeException he) {
                throw he;
            }
            catch (Exception e) {
                throw new HibernateConsoleRuntimeException(ConsoleMessages.ConsoleConfiguration_could_not_load_annotationconfiguration, e);
            }
        } else if (this.prefs.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.JPA)) {
            try {
                localCfg = this.buildJPAConfiguration(this.getPreferences().getPersistenceUnitName(), properties, this.prefs.getEntityResolverName(), includeMappings);
            }
            catch (HibernateConsoleRuntimeException he) {
                throw he;
            }
            catch (Exception e) {
                throw new HibernateConsoleRuntimeException(ConsoleMessages.ConsoleConfiguration_could_not_load_jpa_configuration, e);
            }
        } else {
            localCfg = new Configuration();
            localCfg = this.configureStandardConfiguration(includeMappings, localCfg, properties);
        }
        return localCfg;
    }

    private Configuration configureStandardConfiguration(boolean includeMappings, Configuration localCfg, Properties properties) {
        if (properties != null) {
            localCfg = localCfg.setProperties(properties);
        }
        EntityResolver entityResolver = XMLHelper.DEFAULT_DTD_RESOLVER;
        if (StringHelper.isNotEmpty((String)this.prefs.getEntityResolverName())) {
            try {
                entityResolver = (EntityResolver)ReflectHelper.classForName((String)this.prefs.getEntityResolverName()).newInstance();
            }
            catch (Exception c) {
                throw new HibernateConsoleRuntimeException(String.valueOf(ConsoleMessages.ConsoleConfiguration_could_not_configure_entity_resolver) + this.prefs.getEntityResolverName(), c);
            }
        }
        localCfg.setEntityResolver(entityResolver);
        if (StringHelper.isNotEmpty((String)this.prefs.getNamingStrategy())) {
            try {
                NamingStrategy ns = (NamingStrategy)ReflectHelper.classForName((String)this.prefs.getNamingStrategy()).newInstance();
                localCfg.setNamingStrategy(ns);
            }
            catch (Exception c) {
                throw new HibernateConsoleRuntimeException(String.valueOf(ConsoleMessages.ConsoleConfiguration_could_not_configure_naming_strategy) + this.prefs.getNamingStrategy(), c);
            }
        }
        localCfg = this.loadConfigurationXML(localCfg, includeMappings, entityResolver);
        localCfg = this.configureConnectionProfile(localCfg);
        if (StringHelper.isNotEmpty((String)this.prefs.getDialectName())) {
            localCfg.setProperty("hibernate.dialect", this.prefs.getDialectName());
        }
        return localCfg;
    }

    private Configuration configureConnectionProfile(Configuration localCfg) {
        String connectionProfile = this.prefs.getConnectionProfileName();
        if (connectionProfile == null) {
            return localCfg;
        }
        IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(connectionProfile);
        if (profile != null) {
            String pass;
            this.refreshProfile(profile);
            Properties invokeProperties = localCfg.getProperties();
            invokeProperties.remove("hibernate.connection.datasource");
            localCfg.setProperties(invokeProperties);
            Properties cpProperties = profile.getProperties(profile.getProviderId());
            String driver = cpProperties.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
            localCfg.setProperty("hibernate.connection.driver_class", driver);
            cpProperties.getProperty("jarList");
            String url = cpProperties.getProperty("org.eclipse.datatools.connectivity.db.URL");
            localCfg.setProperty("hibernate.connection.url", url);
            String user = cpProperties.getProperty("org.eclipse.datatools.connectivity.db.username");
            if (user != null && user.length() > 0) {
                localCfg.setProperty("hibernate.connection.username", user);
            }
            if ((pass = cpProperties.getProperty("org.eclipse.datatools.connectivity.db.password")) != null && pass.length() > 0) {
                localCfg.setProperty("hibernate.connection.password", pass);
            }
        } else {
            String out = NLS.bind((String)ConsoleMessages.ConsoleConfiguration_connection_profile_not_found, (Object)connectionProfile);
            throw new HibernateConsoleRuntimeException(out);
        }
        return localCfg;
    }
}

