/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.preferences;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Element;

public interface ConsoleConfigurationPreferences {
    public static final String PATH_TAG = "path";
    public static final String CLASSPATH_TAG = "classpath";
    public static final String MAPPING_TAG = "mapping";
    public static final String MAPPINGS_TAG = "mappings";
    public static final String HIBERNATE_PROPERTIES_TAG = "hibernate-properties";
    public static final String LOCATION_ATTRIB = "location";
    public static final String HIBERNATE_CONFIG_XML_TAG = "hibernate-config-xml";
    public static final String NAME_ATTRIB = "name";
    public static final String CONFIGURATION_TAG = "configuration";
    public static final String ANNOTATIONS_ATTRIB = "annotations";
    public static final String ENTITYRESOLVER_ATTRIB = "entityresolver";
    public static final String CONFIGURATION_MODE_ATTRIB = "configuration-factory";

    public ConfigurationMode getConfigurationMode();

    public String getName();

    public URL[] getCustomClassPathURLS();

    public File[] getMappingFiles();

    public Properties getProperties();

    public File getConfigXMLFile();

    public File getPropertyFile();

    public void writeStateTo(Element var1);

    public void readStateFrom(Element var1);

    public void setName(String var1);

    public String getEntityResolverName();

    public String getPersistenceUnitName();

    public String getNamingStrategy();

    public String getConnectionProfileName();

    public String getDialectName();

    public static class ConfigurationMode
    implements Serializable {
        private static final Map<String, ConfigurationMode> INSTANCES = new HashMap<String, ConfigurationMode>();
        public static final ConfigurationMode CORE = new ConfigurationMode("CORE");
        public static final ConfigurationMode ANNOTATIONS = new ConfigurationMode("ANNOTATIONS");
        public static final ConfigurationMode JPA = new ConfigurationMode("JPA");
        private final String name;

        static {
            INSTANCES.put(ConfigurationMode.CORE.name, CORE);
            INSTANCES.put(ConfigurationMode.ANNOTATIONS.name, ANNOTATIONS);
            INSTANCES.put(ConfigurationMode.JPA.name, JPA);
        }

        public ConfigurationMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        private Object readResolve() {
            return INSTANCES.get(this.name);
        }

        public static ConfigurationMode parse(String name) {
            ConfigurationMode rtn = INSTANCES.get(name);
            if (rtn == null) {
                rtn = CORE;
            }
            return rtn;
        }

        public static String[] values() {
            return INSTANCES.keySet().toArray(new String[INSTANCES.size()]);
        }
    }
}

