/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.extractor;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.eclipse.mapper.MapperMessages;
import org.hibernate.eclipse.mapper.extractor.ColumnNameHandler;
import org.hibernate.eclipse.mapper.extractor.FieldPropertyHandler;
import org.hibernate.eclipse.mapper.extractor.GeneratorTypeHandler;
import org.hibernate.eclipse.mapper.extractor.HBMInfoHandler;
import org.hibernate.eclipse.mapper.extractor.HibernateTypeDescriptor;
import org.hibernate.eclipse.mapper.extractor.HibernateTypeHandler;
import org.hibernate.eclipse.mapper.extractor.JavaTypeHandler;
import org.hibernate.eclipse.mapper.extractor.PackageHandler;
import org.hibernate.eclipse.mapper.extractor.PropertyAccessHandler;
import org.hibernate.eclipse.mapper.extractor.TableNameHandler;
import org.hibernate.util.StringHelper;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HBMInfoExtractor {
    HibernateTypeDescriptor[] hibernateTypes;
    final Map javaTypeProvider = new HashMap();
    final Map tableProvider = new HashMap();
    final Map attributeHandlers = new HashMap();
    private String[] hibernatePropertyNames;
    private Map hibernatePropertyValues;
    private HibernateTypeDescriptor[] generatorTypes;
    private HibernateTypeDescriptor[] propertyAccessors;
    String[] TRUE_FALSE = new String[]{"true", "false"};

    public HBMInfoExtractor() {
        this.setupTypeFinder();
        this.setupTableFinder();
        this.setupJavaTypeHandlers();
        this.setupPackageHandlers();
        this.setupFieldsPropertyHandlers();
        this.setupHibernateTypeHandlers();
        this.setupHibernateTypeDescriptors();
        this.setupTableNameHandlers();
        this.setupColumnNameHandlers();
        this.setupHibernateProperties();
        this.setupGeneratorClassHandlers();
        this.setupAccessHandlers();
    }

    private void setupHibernateProperties() {
        this.hibernatePropertyNames = this.extractHibernateProperties();
        this.hibernatePropertyValues = new HashMap();
        this.hibernatePropertyValues.put("bytecode.provider", new String[]{"cglib", "javassist"});
        this.hibernatePropertyValues.put("bytecode.use_reflection_optimizer", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("cache.use_minimal_puts", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("cache.use_query_cache", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("cache.use_second_level_cache", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("cache.use_structured_entries", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("connection.autocommit", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("connection.isolation", new String[]{"0", "1", "2", "4", "8"});
        this.hibernatePropertyValues.put("format_sql", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("generate_statistics", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("hbm2ddl.auto", new String[]{"validate", "update", "create", "create-drop"});
        this.hibernatePropertyValues.put("jdbc.batch_versioned_data", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("jdbc.use_get_generated_keys", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("jdbc.use_scrollable_resultset", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("jdbc.use_streams_for_binary", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("jdbc.wrap_result_sets", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("order_inserts", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("order_updates", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("query.jpaql_strict_compliance", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("query.startup_check", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("show_sql", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("transaction.auto_close_session", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("transaction.flush_before_completion", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("use_identifier_rollback", this.TRUE_FALSE);
        this.hibernatePropertyValues.put("use_sql_comments", this.TRUE_FALSE);
    }

    private String[] extractHibernateProperties() {
        try {
            Class<Environment> cl = Environment.class;
            ArrayList<String> names = new ArrayList<String>();
            Field[] fields = cl.getFields();
            int i = 0;
            while (i < fields.length) {
                String str;
                Field field = fields[i];
                if (Modifier.isStatic(field.getModifiers()) && field.getType().equals(String.class) && (str = (String)field.get(cl)).startsWith("hibernate.")) {
                    names.add(str);
                }
                ++i;
            }
            Object[] propertyNames = names.toArray(new String[names.size()]);
            Arrays.sort(propertyNames);
            return propertyNames;
        }
        catch (IllegalAccessException illegalAccessException) {
            return new String[0];
        }
    }

    private void setupTypeFinder() {
        this.javaTypeProvider.put("class", "name");
        this.javaTypeProvider.put("subclass", "name");
        this.javaTypeProvider.put("joined-subclass", "name");
        this.javaTypeProvider.put("union-subclass", "name");
        this.javaTypeProvider.put("composite-id", "class");
        this.javaTypeProvider.put("component", "class");
        this.javaTypeProvider.put("composite-element", "class");
        this.javaTypeProvider.put("many-to-one", "class");
        this.javaTypeProvider.put("one-to-many", "class");
        this.javaTypeProvider.put("many-to-many", "class");
        this.javaTypeProvider.put("composite-element", "class");
        this.javaTypeProvider.put("composite-id", "class");
        this.javaTypeProvider.put("key-many-to-one", "class");
        this.javaTypeProvider.put("one-to-many", "class");
    }

    private void setupTableFinder() {
        this.tableProvider.put("class", "table");
        this.tableProvider.put("join", "table");
        this.tableProvider.put("joined-subclass", "table");
        this.tableProvider.put("union-subclass", "table");
        this.tableProvider.put("map", "table");
        this.tableProvider.put("set", "table");
        this.tableProvider.put("bag", "table");
        this.tableProvider.put("idbag", "table");
        this.tableProvider.put("list", "table");
        this.tableProvider.put("array", "table");
        this.tableProvider.put("primitive-array", "table");
        this.tableProvider.put("synchronize", "table");
    }

    private void setupHibernateTypeDescriptors() {
        ArrayList types = new ArrayList();
        this.addType("long", "java.lang.Long", "long", types);
        this.addType("short", "java.lang.Short", "short", types);
        this.addType("integer", "java.lang.Integer", "int", types);
        this.addType("byte", "java.lang.Byte", "byte", types);
        this.addType("float", "java.lang.Float", "float", types);
        this.addType("double", "java.lang.Double", "double", types);
        this.addType("character", "java.lang.Character", "char", types);
        this.addType("string", "java.lang.String", null, types);
        this.addType("time", "java.util.Date", null, types);
        this.addType("date", "java.util.Date", null, types);
        this.addType("timestamp", "java.util.Date", null, types);
        this.addType("boolean", "java.lang.Boolean", "boolean", types);
        this.addType("true_false", "java.lang.Boolean", "boolean", types);
        this.addType("yes_no", "java.lang.Boolean", "boolean", types);
        this.addType("big_decimal", "java.math.BigDecimal", null, types);
        this.addType("binary", "byte[]", null, types);
        this.addType("text", "java.lang.String", null, types);
        this.addType("blob", "java.sql.Blob", null, types);
        this.addType("clob", "java.sql.Clob", null, types);
        this.addType("calendar", "java.util.Calendar", null, types);
        this.addType("calendar_date", "java.util.Calendar", null, types);
        this.addType("locale", "java.util.Locale", null, types);
        this.addType("currency", "java.util.Currency", null, types);
        this.addType("timezone", "java.util.TimeZone", null, types);
        this.addType("class", "java.lang.Class", null, types);
        this.addType("serializable", "java.io.Serializable", null, types);
        this.addType("object", "java.lang.Object", null, types);
        Collections.sort(types);
        this.hibernateTypes = types.toArray(new HibernateTypeDescriptor[types.size()]);
    }

    private void setupGeneratorClassHandlers() {
        ArrayList types = new ArrayList();
        this.addType("native", "Database dependent", null, types);
        this.addType("uuid", "UUIDHexGenerator", null, types);
        this.addType("hilo", "TableHiLoGenerator", null, types);
        this.addType("assigned", "Assigned", null, types);
        this.addType("identity", "IdentityGenerator", null, types);
        this.addType("select", "SelectGenerator", null, types);
        this.addType("sequence", "SequenceGenerator", null, types);
        this.addType("seqhilo", "SequenceHiLoGenerator", null, types);
        this.addType("increment", "IncrementGenerator", null, types);
        this.addType("foreign", "ForeignGenerator", null, types);
        this.addType("guid", "GUIDGenerator", null, types);
        Collections.sort(types);
        this.generatorTypes = types.toArray(new HibernateTypeDescriptor[types.size()]);
    }

    private void setupHibernateTypeHandlers() {
        HibernateTypeHandler hibernateTypeFinder = new HibernateTypeHandler(this);
        this.attributeHandlers.put("filter-param>type", hibernateTypeFinder);
        this.attributeHandlers.put("id>type", hibernateTypeFinder);
        this.attributeHandlers.put("discriminator>type", hibernateTypeFinder);
        this.attributeHandlers.put("version>type", hibernateTypeFinder);
        this.attributeHandlers.put("property>type", hibernateTypeFinder);
        this.attributeHandlers.put("key-property>type", hibernateTypeFinder);
        this.attributeHandlers.put("element>type", hibernateTypeFinder);
        this.attributeHandlers.put("map-key>type", hibernateTypeFinder);
        this.attributeHandlers.put("index>type", hibernateTypeFinder);
        this.attributeHandlers.put("collection-id>type", hibernateTypeFinder);
        this.attributeHandlers.put("return-scalar>type", hibernateTypeFinder);
        GeneratorTypeHandler generatorClassFinder = new GeneratorTypeHandler(this);
        this.attributeHandlers.put("generator>class", generatorClassFinder);
    }

    private void setupTableNameHandlers() {
        TableNameHandler hih = new TableNameHandler();
        this.attributeHandlers.put("class>table", hih);
        this.attributeHandlers.put("join>table", hih);
        this.attributeHandlers.put("joined-subclass>table", hih);
        this.attributeHandlers.put("union-subclass>table", hih);
        this.attributeHandlers.put("map>table", hih);
        this.attributeHandlers.put("set>table", hih);
        this.attributeHandlers.put("bag>table", hih);
        this.attributeHandlers.put("idbag>table", hih);
        this.attributeHandlers.put("list>table", hih);
        this.attributeHandlers.put("array>table", hih);
        this.attributeHandlers.put("primitive-array>table", hih);
        this.attributeHandlers.put("synchronize>table", hih);
    }

    private void setupColumnNameHandlers() {
        ColumnNameHandler hih = new ColumnNameHandler(this);
        this.attributeHandlers.put("id>column", hih);
        this.attributeHandlers.put("discriminator>column", hih);
        this.attributeHandlers.put("version>column", hih);
        this.attributeHandlers.put("timestamp>column", hih);
        this.attributeHandlers.put("property>column", hih);
        this.attributeHandlers.put("many-to-one>column", hih);
        this.attributeHandlers.put("key-property>column", hih);
        this.attributeHandlers.put("key-many-to-one>column", hih);
        this.attributeHandlers.put("element>column", hih);
        this.attributeHandlers.put("many-to-many>column", hih);
        this.attributeHandlers.put("key>column", hih);
        this.attributeHandlers.put("list-index>column", hih);
        this.attributeHandlers.put("map-key>column", hih);
        this.attributeHandlers.put("index>column", hih);
        this.attributeHandlers.put("map-key-many-to-many>column", hih);
        this.attributeHandlers.put("index-many-to-many>column", hih);
        this.attributeHandlers.put("collection-id>column", hih);
        this.attributeHandlers.put("column>name", hih);
        this.attributeHandlers.put("return-property>column", hih);
        this.attributeHandlers.put("return-column>column", hih);
        this.attributeHandlers.put("return-discriminator>column", hih);
        this.attributeHandlers.put("return-scalar>column", hih);
    }

    private void setupAccessHandlers() {
        ArrayList types = new ArrayList();
        this.addType("property", MapperMessages.HBMInfoExtractor_use_javabean_accessor_methods, null, types);
        this.addType("field", MapperMessages.HBMInfoExtractor_access_fields_directly, null, types);
        this.addType("noop", MapperMessages.HBMInfoExtractor_do_not_perform_any_access, null, types);
        Collections.sort(types);
        this.propertyAccessors = types.toArray(new HibernateTypeDescriptor[types.size()]);
        PropertyAccessHandler hih = new PropertyAccessHandler(this);
        this.attributeHandlers.put("hibernate-mapping>default-access", hih);
        this.attributeHandlers.put("id>access", hih);
        this.attributeHandlers.put("composite-id>access", hih);
        this.attributeHandlers.put("version>access", hih);
        this.attributeHandlers.put("timestamp>access", hih);
        this.attributeHandlers.put("property>access", hih);
        this.attributeHandlers.put("many-to-one>access", hih);
        this.attributeHandlers.put("one-to-one>access", hih);
        this.attributeHandlers.put("key-property>access", hih);
        this.attributeHandlers.put("key-many-to-one>access", hih);
        this.attributeHandlers.put("any>access", hih);
        this.attributeHandlers.put("component>access", hih);
        this.attributeHandlers.put("dynamic-component>access", hih);
        this.attributeHandlers.put("map>access", hih);
        this.attributeHandlers.put("set>access", hih);
        this.attributeHandlers.put("bag>access", hih);
        this.attributeHandlers.put("idbag>access", hih);
        this.attributeHandlers.put("list>access", hih);
        this.attributeHandlers.put("array>access", hih);
        this.attributeHandlers.put("primitive-array>access", hih);
        this.attributeHandlers.put("nested-composite-element>access", hih);
    }

    private void setupFieldsPropertyHandlers() {
        FieldPropertyHandler fieldsFinder = new FieldPropertyHandler(this);
        this.attributeHandlers.put("version>name", fieldsFinder);
        this.attributeHandlers.put("timestamp>name", fieldsFinder);
        this.attributeHandlers.put("property>name", fieldsFinder);
        this.attributeHandlers.put("key-property>name", fieldsFinder);
        this.attributeHandlers.put("id>name", fieldsFinder);
        this.attributeHandlers.put("composite-id>name", fieldsFinder);
        this.attributeHandlers.put("set>name", fieldsFinder);
        this.attributeHandlers.put("key-property>name", fieldsFinder);
        this.attributeHandlers.put("property>name", fieldsFinder);
        this.attributeHandlers.put("key-many-to-one>name", fieldsFinder);
        this.attributeHandlers.put("many-to-one>name", fieldsFinder);
        this.attributeHandlers.put("one-to-one>name", fieldsFinder);
        this.attributeHandlers.put("component>name", fieldsFinder);
        this.attributeHandlers.put("dynamic-component>name", fieldsFinder);
        this.attributeHandlers.put("properties>name", fieldsFinder);
        this.attributeHandlers.put("any>name", fieldsFinder);
        this.attributeHandlers.put("map>name", fieldsFinder);
        this.attributeHandlers.put("set>name", fieldsFinder);
        this.attributeHandlers.put("list>name", fieldsFinder);
        this.attributeHandlers.put("bag>name", fieldsFinder);
        this.attributeHandlers.put("idbag>name", fieldsFinder);
        this.attributeHandlers.put("array>name", fieldsFinder);
        this.attributeHandlers.put("primitive-array>name", fieldsFinder);
        this.attributeHandlers.put("query-list>name", fieldsFinder);
    }

    private void setupPackageHandlers() {
        PackageHandler packageFinder = new PackageHandler(this);
        this.attributeHandlers.put("hibernate-mapping>package", packageFinder);
    }

    private void setupJavaTypeHandlers() {
        JavaTypeHandler classFinder = new JavaTypeHandler(this);
        this.attributeHandlers.put("class>name", classFinder);
        this.attributeHandlers.put("subclass>name", classFinder);
        this.attributeHandlers.put("joined-subclass>name", classFinder);
        this.attributeHandlers.put("union-subclass>name", classFinder);
        this.attributeHandlers.put("many-to-one>class", classFinder);
        this.attributeHandlers.put("one-to-many>class", classFinder);
        this.attributeHandlers.put("many-to-many>class", classFinder);
        this.attributeHandlers.put("composite-element>class", classFinder);
        this.attributeHandlers.put("component>class", classFinder);
        this.attributeHandlers.put("composite-id>class", classFinder);
        this.attributeHandlers.put("key-many-to-one>class", classFinder);
    }

    List findMatchingHibernateTypes(String item) {
        return this.findInTypes(item, this.hibernateTypes);
    }

    private List findInTypes(String item, HibernateTypeDescriptor[] types) {
        ArrayList<HibernateTypeDescriptor> l = new ArrayList<HibernateTypeDescriptor>();
        boolean foundFirst = false;
        int i = 0;
        while (i < types.length) {
            HibernateTypeDescriptor element = types[i];
            if (element.getName().startsWith(item)) {
                foundFirst = true;
                l.add(element);
            } else if (foundFirst) {
                return l;
            }
            ++i;
        }
        return l;
    }

    public List findMatchingGenerators(String start) {
        return this.findInTypes(start, this.generatorTypes);
    }

    public List findMatchingPropertyTypes(String prefix) {
        ArrayList<String> l = new ArrayList<String>();
        boolean foundFirst = false;
        int i = 0;
        while (i < this.hibernatePropertyNames.length) {
            String element = this.hibernatePropertyNames[i];
            if (element.startsWith(prefix)) {
                foundFirst = true;
                l.add(element);
            } else if (element.startsWith("hibernate." + prefix)) {
                foundFirst = true;
                l.add(element.substring("hibernate.".length()));
            } else if (foundFirst) {
                return l;
            }
            ++i;
        }
        return l;
    }

    protected String getPackageName(Node root) {
        if (root != null) {
            while (!"hibernate-mapping".equals(root.getNodeName())) {
                if ((root = root.getParentNode()) != null) continue;
                return null;
            }
            NamedNodeMap attributes = root.getAttributes();
            int count = 0;
            while (count < attributes.getLength()) {
                Node att = attributes.item(count);
                if ("package".equals(att.getNodeName())) {
                    return att.getNodeValue();
                }
                ++count;
            }
        }
        return null;
    }

    protected boolean beginsWith(String aString, String prefix) {
        if (aString == null || prefix == null) {
            return true;
        }
        return aString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    void generateTypeProposals(String matchString, int offset, List proposals, Set alreadyFound, IType[] classes, String filterPackage) throws JavaModelException {
        int j = 0;
        while (j < classes.length) {
            IType type = classes[j];
            if (!(Flags.isAbstract((int)type.getFlags()) || filterPackage != null && type.getFullyQualifiedName().startsWith(filterPackage))) {
                String fullName = type.getFullyQualifiedName();
                String shortName = type.getElementName();
                if (!alreadyFound.contains(fullName)) {
                    alreadyFound.add(fullName);
                    if (this.beginsWith(fullName, matchString) || this.beginsWith(shortName, matchString)) {
                        CustomCompletionProposal proposal = new CustomCompletionProposal(fullName, offset, matchString.length(), fullName.length() + 1, null, fullName, null, null, 800);
                        proposals.add(proposal);
                    }
                }
            }
            ++j;
        }
    }

    private void addType(String name, String returnClass, String primitiveClass, Collection hibernateTypes) {
        hibernateTypes.add(new HibernateTypeDescriptor(name, returnClass, primitiveClass));
    }

    public HBMInfoHandler getAttributeHandler(String path) {
        HBMInfoHandler infoHandler = (HBMInfoHandler)this.attributeHandlers.get(path);
        return infoHandler;
    }

    /*
     * Unable to fully structure code
     */
    private String getNearestType(Node node) {
        map = this.javaTypeProvider;
        if (node != null) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            if ((node = node.getParentNode()) != null) continue;
            return null;
lbl6:
            // 2 sources

            ** while (!map.containsKey((Object)node.getNodeName()))
        }
lbl7:
        // 1 sources

        attributeName = (String)map.get(node.getNodeName());
        attributes = node.getAttributes();
        att = attributes.getNamedItem(attributeName);
        if (att != null && attributeName.equals(att.getNodeName())) {
            typename = att.getNodeValue();
            if (typename != null && typename.indexOf(46) < 0 && (packageName = this.getPackageName(node)) != null) {
                typename = String.valueOf(packageName) + "." + typename;
            }
            return typename;
        }
        return null;
    }

    public String getNearestType(IJavaProject project, Node parentNode) {
        String typename = this.getNearestType(parentNode);
        if (typename != null) {
            return typename;
        }
        try {
            String parentTypeName;
            Node componentPropertyNodeName;
            if ("component".equals(parentNode.getNodeName()) && (componentPropertyNodeName = parentNode.getAttributes().getNamedItem("name")) != null && (parentTypeName = this.getNearestType(project, parentNode.getParentNode())) != null) {
                IField field;
                String componentName = componentPropertyNodeName.getNodeValue();
                IType parentType = project.findType(parentTypeName);
                if (parentType != null && (field = parentType.getField(componentName)).exists()) {
                    String fieldTypeSignature = field.getTypeSignature();
                    String qualifier = Signature.getSignatureQualifier((String)fieldTypeSignature);
                    String simpleName = Signature.getSignatureSimpleName((String)fieldTypeSignature);
                    if (!StringHelper.isEmpty((String)qualifier)) {
                        simpleName = Signature.toQualifiedName((String[])new String[]{qualifier, simpleName});
                    }
                    String[][] possibleTypes = null;
                    possibleTypes = parentType.resolveType(simpleName);
                    if (possibleTypes != null && possibleTypes.length > 0) {
                        typename = Signature.toQualifiedName((String[])possibleTypes[0]);
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {
            typename = null;
        }
        return typename;
    }

    /*
     * Unable to fully structure code
     */
    public TableIdentifier getNearestTableName(Node node) {
        map = this.tableProvider;
        if (node != null) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            if ((node = node.getParentNode()) != null) continue;
            return null;
lbl6:
            // 2 sources

            ** while (!map.containsKey((Object)node.getNodeName()))
        }
lbl7:
        // 1 sources

        attributeName = (String)map.get(node.getNodeName());
        attributes = node.getAttributes();
        att = attributes.getNamedItem(attributeName);
        if (att != null && attributeName.equals(att.getNodeName())) {
            typename = att.getNodeValue();
            catalog = null;
            schema = null;
            namedItem = attributes.getNamedItem("catalog");
            if (namedItem != null) {
                catalog = namedItem.getNodeValue();
            }
            if ((namedItem = attributes.getNamedItem("schema")) != null) {
                schema = namedItem.getNodeValue();
            }
            return new TableIdentifier(catalog, schema, typename);
        }
        return null;
    }

    public IType getNearestTypeJavaElement(IJavaProject project, Node currentNode) {
        String nearestType = this.getNearestType(project, currentNode);
        if (nearestType != null) {
            try {
                IType type = project.findType(nearestType);
                return type;
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public List findMatchingAccessMethods(String start) {
        return this.findInTypes(start, this.propertyAccessors);
    }

    public List findMatchingPropertyValues(String matchString, Node node) {
        String[] strings;
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        NamedNodeMap attributes = node.getAttributes();
        Node namedItem = attributes.getNamedItem("name");
        String propName = namedItem.getNodeValue();
        if (propName.startsWith("hibernate.")) {
            propName = propName.substring("hibernate.".length());
        }
        if ((strings = (String[])this.hibernatePropertyValues.get(propName)) == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> matches = new ArrayList<String>(strings.length);
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string.startsWith(matchString)) {
                matches.add(string);
            }
            ++i;
        }
        return matches;
    }
}

