/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.BlockEvent;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.ExitEvent;
import org.jgroups.GetStateEvent;
import org.jgroups.Message;
import org.jgroups.SetStateEvent;
import org.jgroups.SuspectEvent;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.CondVar;
import org.jgroups.util.Promise;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.Util;
import org.w3c.dom.Element;

public class JChannel
extends Channel {
    public static final String DEFAULT_PROTOCOL_STACK = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=32):PING(timeout=3000;num_initial_members=6):FD(timeout=3000):VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=10;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=10000):FRAG:pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true)";
    static final String FORCE_PROPS = "force.properties";
    private String props = null;
    private Address local_addr = null;
    private String channel_name = null;
    private View my_view = null;
    private final Queue mq = new Queue();
    private ProtocolStack prot_stack = null;
    protected CloserThread closer = null;
    private final Promise local_addr_promise = new Promise();
    private final Promise connect_promise = new Promise();
    private final Promise disconnect_promise = new Promise();
    private final Promise state_promise = new Promise();
    private long LOCAL_ADDR_TIMEOUT = 30000L;
    private static final long GET_STATE_DEFAULT_TIMEOUT = 5000L;
    private boolean receive_views = true;
    private boolean receive_suspects = true;
    private boolean receive_blocks = false;
    private boolean receive_local_msgs = true;
    private boolean receive_get_states = false;
    private boolean auto_reconnect = false;
    private boolean auto_getstate = false;
    private boolean connected = false;
    private final CondVar block_sending = new CondVar("block_sending", Boolean.FALSE);
    private boolean closed = false;
    private boolean state_transfer_supported = false;
    private byte[] additional_data = null;
    protected final Log log = LogFactory.getLog(this.getClass());

    public JChannel() throws ChannelException {
        this(DEFAULT_PROTOCOL_STACK);
    }

    public JChannel(File properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(Element properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(URL properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(String properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    protected JChannel(ProtocolStackConfigurator configurator) throws ChannelException {
        this.props = configurator.getProtocolStackString();
        this.prot_stack = new ProtocolStack(this, this.props);
        try {
            this.prot_stack.setup();
        }
        catch (Throwable e) {
            throw new ChannelException("unable to setup the protocol stack", e);
        }
    }

    public JChannel(Object properties) throws ChannelException {
        if (properties == null) {
            properties = DEFAULT_PROTOCOL_STACK;
        }
        try {
            ProtocolStackConfigurator c = ConfiguratorFactory.getStackConfigurator(properties);
            this.props = c.getProtocolStackString();
        }
        catch (Exception x) {
            String strace = Util.getStackTrace(x);
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)strace);
            }
            throw new ChannelException("unable to load protocol stack: {" + x.getMessage() + ';' + strace + '}');
        }
        this.prot_stack = new ProtocolStack(this, this.props);
        try {
            this.prot_stack.setup();
        }
        catch (Throwable e) {
            throw new ChannelException("JChannel(): " + e);
        }
    }

    public ProtocolStack getProtocolStack() {
        return this.prot_stack;
    }

    public String getProperties() {
        return this.props;
    }

    public String printProtocolSpec(boolean include_properties) {
        return this.prot_stack != null ? this.prot_stack.printProtocolSpec(include_properties) : null;
    }

    public synchronized void connect(String channel_name) throws ChannelException, ChannelClosedException {
        this.checkClosed();
        if (this.connected) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("already connected to " + channel_name));
            }
            return;
        }
        if (channel_name == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"channel_name is null, assuming unicast channel");
            }
        } else {
            this.channel_name = channel_name;
        }
        try {
            this.prot_stack.startStack();
        }
        catch (Throwable e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception: " + e));
            }
            throw new ChannelException(e.toString());
        }
        try {
            this.LOCAL_ADDR_TIMEOUT = Long.parseLong(System.getProperty("local_addr.timeout", "30000"));
        }
        catch (SecurityException e1) {
            // empty catch block
        }
        this.local_addr = (Address)this.local_addr_promise.getResult(this.LOCAL_ADDR_TIMEOUT);
        if (this.local_addr == null) {
            this.log.fatal((Object)"local_addr is null; cannot connect");
            throw new ChannelException("local_addr is null");
        }
        Vector<Address> t = new Vector<Address>(1);
        t.addElement(this.local_addr);
        this.my_view = new View(this.local_addr, 0L, t);
        if (channel_name != null) {
            this.connect_promise.reset();
            Event connect_event = new Event(2, channel_name);
            this.down(connect_event);
            this.connect_promise.getResult();
        }
        this.connected = true;
        if (this.channel_listener != null) {
            this.channel_listener.channelConnected(this);
        }
    }

    public synchronized void disconnect() {
        if (this.closed) {
            return;
        }
        if (this.connected) {
            block6: {
                if (this.channel_name != null) {
                    Event disconnect_event = new Event(4, this.local_addr);
                    this.disconnect_promise.reset();
                    this.down(disconnect_event);
                    this.disconnect_promise.getResult();
                }
                this.down(new Event(23));
                this.connected = false;
                try {
                    this.prot_stack.stopStack();
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block6;
                    this.log.error((Object)("exception: " + e));
                }
            }
            if (this.channel_listener != null) {
                this.channel_listener.channelDisconnected(this);
            }
            this.init();
        }
    }

    public synchronized void close() {
        this._close(true, true);
    }

    public synchronized void open() throws ChannelException {
        if (!this.closed) {
            throw new ChannelException("JChannel.open(): channel is already open");
        }
        try {
            this.mq.reset();
            this.prot_stack = new ProtocolStack(this, this.props);
            this.prot_stack.setup();
            this.closed = false;
        }
        catch (Exception e) {
            throw new ChannelException("JChannel().open(): " + e.getMessage());
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getNumMessages() {
        return this.mq != null ? this.mq.size() : -1;
    }

    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        this.checkClosed();
        this.checkNotConnected();
        this.down(new Event(1, msg));
    }

    public void send(Address dst, Address src, Serializable obj) throws ChannelNotConnectedException, ChannelClosedException {
        this.send(new Message(dst, src, obj));
    }

    public Object receive(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        Object retval = null;
        this.checkClosed();
        this.checkNotConnected();
        try {
            Event evt = timeout <= 0L ? (Event)this.mq.remove() : (Event)this.mq.remove(timeout);
            retval = JChannel.getEvent(evt);
            evt = null;
            return retval;
        }
        catch (QueueClosedException queue_closed) {
            throw new ChannelClosedException();
        }
        catch (TimeoutException t) {
            throw t;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception: " + e));
            }
            return null;
        }
    }

    public Object peek(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        Object retval = null;
        this.checkClosed();
        this.checkNotConnected();
        try {
            Event evt = timeout <= 0L ? (Event)this.mq.peek() : (Event)this.mq.peek(timeout);
            retval = JChannel.getEvent(evt);
            evt = null;
            return retval;
        }
        catch (QueueClosedException queue_closed) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception: " + queue_closed));
            }
            return null;
        }
        catch (TimeoutException t) {
            return null;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception: " + e));
            }
            return null;
        }
    }

    public View getView() {
        return this.closed || !this.connected ? null : this.my_view;
    }

    public Address getLocalAddress() {
        return this.closed ? null : this.local_addr;
    }

    public String getChannelName() {
        return this.closed ? null : (!this.connected ? null : this.channel_name);
    }

    public void setOpt(int option, Object value) {
        if (this.closed) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"channel is closed; option not set !");
            }
            return;
        }
        switch (option) {
            case 1: {
                if (value instanceof Boolean) {
                    this.receive_views = (Boolean)value;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean"));
                break;
            }
            case 2: {
                if (value instanceof Boolean) {
                    this.receive_suspects = (Boolean)value;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean"));
                break;
            }
            case 0: {
                if (value instanceof Boolean) {
                    this.receive_blocks = (Boolean)value;
                } else if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean"));
                }
                if (!this.receive_blocks) break;
                this.receive_views = true;
                break;
            }
            case 4: {
                if (value instanceof Boolean) {
                    this.receive_get_states = (Boolean)value;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean"));
                break;
            }
            case 3: {
                if (value instanceof Boolean) {
                    this.receive_local_msgs = (Boolean)value;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean"));
                break;
            }
            case 5: {
                if (value instanceof Boolean) {
                    this.auto_reconnect = (Boolean)value;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean"));
                break;
            }
            case 6: {
                if (value instanceof Boolean) {
                    this.auto_getstate = (Boolean)value;
                    if (!this.auto_getstate) break;
                    this.auto_reconnect = true;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean"));
                break;
            }
            default: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " not known"));
            }
        }
    }

    public Object getOpt(int option) {
        switch (option) {
            case 1: {
                return this.receive_views ? Boolean.TRUE : Boolean.FALSE;
            }
            case 0: {
                return this.receive_blocks ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return this.receive_suspects ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.receive_get_states ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.receive_local_msgs ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)("option " + Channel.option2String(option) + " not known"));
        }
        return null;
    }

    public void blockOk() {
        this.down(new Event(11));
        this.down(new Event(22));
    }

    public boolean getState(Address target, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        StateTransferInfo info = new StateTransferInfo(1, target);
        info.timeout = timeout;
        return this._getState(new Event(19, info), timeout);
    }

    public boolean getAllStates(Vector targets, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        StateTransferInfo info = new StateTransferInfo(2, targets);
        return this._getState(new Event(19, info), timeout);
    }

    public void returnState(byte[] state) {
        this.down(new Event(18, state));
    }

    public void up(Event evt) {
        block26: {
            int type = evt.getType();
            if (this.mq == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"message queue is null");
                }
                return;
            }
            switch (type) {
                case 1: {
                    Message msg = (Message)evt.getArg();
                    if (this.receive_local_msgs || this.local_addr == null || msg.getSrc() == null || !this.local_addr.equals(msg.getSrc())) break;
                    return;
                }
                case 6: {
                    this.my_view = (View)evt.getArg();
                    if (!this.connected) {
                        this.connected = true;
                        this.connect_promise.setResult(Boolean.TRUE);
                    }
                    this.down(new Event(23));
                    if (this.receive_views) break;
                    return;
                }
                case 9: {
                    if (this.receive_suspects) break;
                    return;
                }
                case 17: {
                    if (this.receive_get_states) break;
                    this.down(new Event(18, null));
                    return;
                }
                case 56: {
                    HashMap config = (HashMap)evt.getArg();
                    if (config == null || !config.containsKey("state_transfer")) break;
                    this.state_transfer_supported = (Boolean)config.get("state_transfer");
                    break;
                }
                case 10: {
                    if (this.receive_blocks) break;
                    this.down(new Event(11));
                    this.down(new Event(22));
                    return;
                }
                case 3: {
                    this.connect_promise.setResult(Boolean.TRUE);
                    break;
                }
                case 5: {
                    this.disconnect_promise.setResult(Boolean.TRUE);
                    break;
                }
                case 20: {
                    try {
                        this.mq.add(new Event(21, evt.getArg()));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.state_promise.setResult(evt.getArg());
                    break;
                }
                case 8: {
                    this.local_addr_promise.setResult(evt.getArg());
                    break;
                }
                case 46: {
                    this.handleExit(evt);
                    return;
                }
                case 54: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)"received BLOCK_SEND");
                    }
                    this.block_sending.set(Boolean.TRUE);
                    break;
                }
                case 55: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)"received UNBLOCK_SEND");
                    }
                    this.block_sending.set(Boolean.FALSE);
                    break;
                }
            }
            if (this.up_handler != null) {
                this.up_handler.up(evt);
                return;
            }
            if (type == 1 || type == 6 || type == 9 || type == 17 || type == 10) {
                try {
                    this.mq.add(evt);
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block26;
                    this.log.error((Object)("exception: " + e));
                }
            }
        }
    }

    public void down(Event evt) {
        block10: {
            if (evt == null) {
                return;
            }
            if (evt.getType() == 1 && this.block_sending.get().equals(Boolean.TRUE)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"down() blocks because block_sending == true");
                }
                this.block_sending.waitUntil(Boolean.FALSE);
            }
            if (evt.getType() == 56) {
                try {
                    Map m = (Map)evt.getArg();
                    if (m != null && m.containsKey("additional_data")) {
                        this.additional_data = (byte[])m.get("additional_data");
                    }
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block10;
                    this.log.error((Object)("CONFIG event did not contain a hashmap: " + t));
                }
            }
        }
        if (this.prot_stack != null) {
            this.prot_stack.down(evt);
        } else if (this.log.isErrorEnabled()) {
            this.log.error((Object)"no protocol stack available");
        }
    }

    public String toString(boolean details) {
        StringBuffer sb = new StringBuffer();
        sb.append("local_addr=").append(this.local_addr).append('\n');
        sb.append("channel_name=").append(this.channel_name).append('\n');
        sb.append("my_view=").append(this.my_view).append('\n');
        sb.append("connected=").append(this.connected).append('\n');
        sb.append("closed=").append(this.closed).append('\n');
        if (this.mq != null) {
            sb.append("incoming queue size=").append(this.mq.size()).append('\n');
        }
        if (details) {
            sb.append("block_sending=").append(this.block_sending).append('\n');
            sb.append("receive_views=").append(this.receive_views).append('\n');
            sb.append("receive_suspects=").append(this.receive_suspects).append('\n');
            sb.append("receive_blocks=").append(this.receive_blocks).append('\n');
            sb.append("receive_local_msgs=").append(this.receive_local_msgs).append('\n');
            sb.append("receive_get_states=").append(this.receive_get_states).append('\n');
            sb.append("auto_reconnect=").append(this.auto_reconnect).append('\n');
            sb.append("auto_getstate=").append(this.auto_getstate).append('\n');
            sb.append("state_transfer_supported=").append(this.state_transfer_supported).append('\n');
            sb.append("props=").append(this.props).append('\n');
        }
        return sb.toString();
    }

    private void init() {
        this.local_addr = null;
        this.channel_name = null;
        this.my_view = null;
        this.connect_promise.reset();
        this.disconnect_promise.reset();
        this.connected = false;
        this.block_sending.set(Boolean.FALSE);
    }

    private final void checkNotConnected() throws ChannelNotConnectedException {
        if (!this.connected) {
            throw new ChannelNotConnectedException();
        }
    }

    private final void checkClosed() throws ChannelClosedException {
        if (this.closed) {
            throw new ChannelClosedException();
        }
    }

    static Object getEvent(Event evt) {
        if (evt == null) {
            return null;
        }
        switch (evt.getType()) {
            case 1: {
                return evt.getArg();
            }
            case 6: {
                return evt.getArg();
            }
            case 9: {
                return new SuspectEvent(evt.getArg());
            }
            case 10: {
                return new BlockEvent();
            }
            case 17: {
                return new GetStateEvent(evt.getArg());
            }
            case 21: {
                return new SetStateEvent((byte[])evt.getArg());
            }
            case 46: {
                return new ExitEvent();
            }
        }
        return evt;
    }

    boolean _getState(Event evt, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        this.checkClosed();
        this.checkNotConnected();
        if (!this.state_transfer_supported) {
            this.log.error((Object)"fetching state will fail as state transfer is not supported. Add one of the STATE_TRANSFER protocols to your protocol configuration");
            return false;
        }
        this.state_promise.reset();
        this.down(evt);
        byte[] state = (byte[])this.state_promise.getResult(timeout);
        return state != null;
    }

    void _close(boolean disconnect, boolean close_mq) {
        block11: {
            block10: {
                if (this.closed) {
                    return;
                }
                if (disconnect) {
                    this.disconnect();
                }
                if (close_mq) {
                    try {
                        if (this.mq != null) {
                            this.mq.close(false);
                        }
                    }
                    catch (Exception e) {
                        if (!this.log.isErrorEnabled()) break block10;
                        this.log.error((Object)("exception: " + e));
                    }
                }
            }
            if (this.prot_stack != null) {
                try {
                    this.prot_stack.stopStack();
                    this.prot_stack.destroy();
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block11;
                    this.log.error((Object)("exception: " + e));
                }
            }
        }
        this.closed = true;
        this.connected = false;
        if (this.channel_listener != null) {
            this.channel_listener.channelClosed(this);
        }
        this.init();
    }

    void handleExit(Event evt) {
        if (this.channel_listener != null) {
            this.channel_listener.channelShunned();
        }
        if (this.closer != null && !this.closer.isAlive()) {
            this.closer = null;
        }
        if (this.closer == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"received an EXIT event, will leave the channel");
            }
            this.closer = new CloserThread(evt);
            this.closer.start();
        }
    }

    class CloserThread
    extends Thread {
        final Event evt;
        final Thread t = null;

        CloserThread(Event evt) {
            this.evt = evt;
            this.setName("CloserThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String old_channel_name;
                block32: {
                    old_channel_name = JChannel.this.channel_name;
                    if (JChannel.this.log.isInfoEnabled()) {
                        JChannel.this.log.info((Object)"closing the channel");
                    }
                    JChannel.this._close(false, false);
                    if (JChannel.this.up_handler != null) {
                        JChannel.this.up_handler.up(this.evt);
                    } else {
                        try {
                            JChannel.this.mq.add(this.evt);
                        }
                        catch (Exception ex) {
                            if (!JChannel.this.log.isErrorEnabled()) break block32;
                            JChannel.this.log.error((Object)("exception: " + ex));
                        }
                    }
                }
                if (JChannel.this.mq != null) {
                    Util.sleep(500L);
                    try {
                        JChannel.this.mq.close(false);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (JChannel.this.auto_reconnect) {
                    try {
                        if (JChannel.this.log.isInfoEnabled()) {
                            JChannel.this.log.info((Object)("reconnecting to group " + old_channel_name));
                        }
                        JChannel.this.open();
                    }
                    catch (Exception ex) {
                        if (JChannel.this.log.isErrorEnabled()) {
                            JChannel.this.log.error((Object)("failure reopening channel: " + ex));
                        }
                        JChannel.this.closer = null;
                        return;
                    }
                    try {
                        if (JChannel.this.additional_data != null) {
                            HashMap<String, byte[]> m = new HashMap<String, byte[]>(11);
                            m.put("additional_data", JChannel.this.additional_data);
                            JChannel.this.down(new Event(56, m));
                        }
                        JChannel.this.connect(old_channel_name);
                        if (JChannel.this.channel_listener != null) {
                            JChannel.this.channel_listener.channelReconnected(JChannel.this.local_addr);
                        }
                    }
                    catch (Exception ex) {
                        if (JChannel.this.log.isErrorEnabled()) {
                            JChannel.this.log.error((Object)("failure reconnecting to channel: " + ex));
                        }
                        JChannel.this.closer = null;
                        return;
                    }
                }
                if (JChannel.this.auto_getstate) {
                    boolean rc;
                    if (JChannel.this.log.isInfoEnabled()) {
                        JChannel.this.log.info((Object)"fetching the state (auto_getstate=true)");
                    }
                    if (rc = JChannel.this.getState(null, 5000L)) {
                        if (JChannel.this.log.isInfoEnabled()) {
                            JChannel.this.log.info((Object)"state was retrieved successfully");
                        } else if (JChannel.this.log.isInfoEnabled()) {
                            JChannel.this.log.info((Object)"state transfer failed");
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (JChannel.this.log.isErrorEnabled()) {
                    JChannel.this.log.error((Object)("exception: " + ex));
                }
            }
            finally {
                JChannel.this.closer = null;
            }
        }
    }
}

