/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf.transports;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jgroups.stack.IpAddress;
import org.jgroups.tests.perf.Receiver;
import org.jgroups.tests.perf.Transport;

public class TcpTransport
implements Transport {
    Receiver receiver = null;
    Properties config = null;
    int max_receiver_buffer_size = 500000;
    int max_send_buffer_size = 500000;
    List nodes = new ArrayList();
    ConnectionTable ct;
    int srv_port = 7777;
    ServerSocket srv_sock = null;
    InetAddress bind_addr = null;
    IpAddress local_addr = null;
    List receivers = new ArrayList();

    public Object getLocalAddress() {
        return this.local_addr;
    }

    public void create(Properties properties) throws Exception {
        String bind_addr_str;
        this.config = properties;
        String tmp = this.config.getProperty("srv_port");
        if (tmp != null) {
            this.srv_port = Integer.parseInt(tmp);
        }
        this.bind_addr = (bind_addr_str = System.getProperty("udp.bind_addr", this.config.getProperty("bind_addr"))) != null ? InetAddress.getByName(bind_addr_str) : InetAddress.getLocalHost();
        String cluster_def = this.config.getProperty("cluster");
        if (cluster_def == null) {
            throw new Exception("TcpTransport.create(): property 'cluster' is not defined");
        }
        this.nodes = this.parseCommaDelimitedList(cluster_def);
        this.ct = new ConnectionTable(this.nodes);
    }

    public void start() throws Exception {
        this.srv_sock = new ServerSocket(this.srv_port, 50, this.bind_addr);
        this.local_addr = new IpAddress(this.srv_sock.getInetAddress(), this.srv_sock.getLocalPort());
        this.ct.init();
        Thread acceptor = new Thread(){

            public void run() {
                try {
                    while (true) {
                        Socket s = TcpTransport.this.srv_sock.accept();
                        ReceiverThread r = new ReceiverThread(s);
                        r.setDaemon(true);
                        TcpTransport.this.receivers.add(r);
                        r.start();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
            }
        };
        acceptor.setDaemon(true);
        acceptor.start();
    }

    public void stop() {
        this.ct.close();
        Iterator it = this.receivers.iterator();
        while (it.hasNext()) {
            ReceiverThread thread = (ReceiverThread)it.next();
            thread.stopThread();
        }
    }

    public void destroy() {
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    public void send(Object destination, byte[] payload) throws Exception {
        if (destination != null) {
            throw new Exception("TcpTransport.send(): unicasts not supported");
        }
        this.ct.writeMessage(payload);
    }

    public List parseCommaDelimitedList(String s) throws Exception {
        ArrayList<InetAddress> retval = new ArrayList<InetAddress>();
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            InetAddress host = InetAddress.getByName(tok.nextToken());
            retval.add(host);
        }
        return retval;
    }

    class ReceiverThread
    extends Thread {
        Socket sock;
        DataInputStream in;

        ReceiverThread(Socket sock) throws Exception {
            this.sock = sock;
            sock.setSoTimeout(5000);
            this.in = new DataInputStream(new BufferedInputStream(sock.getInputStream()));
        }

        public void run() {
            while (this.sock != null) {
                try {
                    int len = this.in.readInt();
                    byte[] buf = new byte[len];
                    this.in.readFully(buf, 0, len);
                    if (TcpTransport.this.receiver == null) continue;
                    TcpTransport.this.receiver.receive(this.sock.getInetAddress(), buf);
                }
                catch (EOFException eof) {
                    break;
                }
                catch (Exception ex) {
                    if (this.sock == null) {
                        return;
                    }
                    ex.printStackTrace();
                }
            }
        }

        void stopThread() {
            try {
                this.sock.close();
                this.sock = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class Connection {
        Socket sock;
        DataOutputStream out;

        Connection(InetAddress addr) throws Exception {
            this.sock = new Socket(addr, TcpTransport.this.srv_port);
            this.out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
        }

        void writeMessage(byte[] msg) throws Exception {
            this.out.writeInt(msg.length);
            this.out.write(msg, 0, msg.length);
            this.out.flush();
        }

        void close() {
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ConnectionTable {
        List nodes;
        Connection[] connections;

        ConnectionTable(List nodes) throws Exception {
            this.nodes = nodes;
            this.connections = new Connection[nodes.size()];
        }

        void init() throws Exception {
            int i = 0;
            Iterator it = this.nodes.iterator();
            while (it.hasNext()) {
                InetAddress addr = (InetAddress)it.next();
                if (this.connections[i] == null) {
                    try {
                        this.connections[i] = new Connection(addr);
                    }
                    catch (ConnectException connect_ex) {
                        System.err.println("Failed to connect to " + addr + ':' + TcpTransport.this.srv_port);
                        throw connect_ex;
                    }
                    catch (Exception all_others) {
                        throw all_others;
                    }
                    System.out.println("-- connected to " + addr);
                    System.out.flush();
                }
                ++i;
            }
        }

        void writeMessage(byte[] msg) throws Exception {
            for (int i = 0; i < this.connections.length; ++i) {
                Connection c = this.connections[i];
                if (c == null) continue;
                c.writeMessage(msg);
            }
        }

        void close() {
            for (int i = 0; i < this.connections.length; ++i) {
                Connection c = this.connections[i];
                if (c == null) continue;
                c.close();
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Iterator it = this.nodes.iterator();
            while (it.hasNext()) {
                InetAddress inetAddress = (InetAddress)it.next();
                sb.append(inetAddress).append(' ');
            }
            return sb.toString();
        }
    }
}

