/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.CacheStorage;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class SoftCacheStorage
implements CacheStorage {
    private final ReferenceQueue queue = new ReferenceQueue();
    private final Map map;

    public SoftCacheStorage() {
        this(new HashMap());
    }

    public SoftCacheStorage(Map backingMap) {
        this.map = backingMap;
    }

    public Object get(Object key) {
        this.processQueue();
        Reference ref = (Reference)this.map.get(key);
        return ref == null ? null : ref.get();
    }

    public void put(Object key, Object value) {
        this.processQueue();
        this.map.put(key, new SoftValueReference(key, value, this.queue));
    }

    public void remove(Object key) {
        this.processQueue();
        this.map.remove(key);
    }

    public void clear() {
        this.map.clear();
        this.processQueue();
    }

    private void processQueue() {
        SoftValueReference ref;
        while ((ref = (SoftValueReference)this.queue.poll()) != null) {
            Object key = ref.getKey();
            if (this.map.get(key) != ref) continue;
            this.map.remove(key);
        }
        return;
    }

    private static final class SoftValueReference
    extends SoftReference {
        private final Object key;

        SoftValueReference(Object key, Object value, ReferenceQueue queue) {
            super(value, queue);
            this.key = key;
        }

        Object getKey() {
            return this.key;
        }
    }
}

