/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mapping.details;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.ui.internal.util.ControlEnabler;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.hibernate.jpt.core.internal.context.GenericGenerator;
import org.jboss.tools.hibernate.jpt.core.internal.context.GenericGeneratorHolder;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaIdMapping;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaGenericGeneratorImpl;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateUIMappingMessages;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.ParametersComposite;
import org.jboss.tools.hibernate.jpt.ui.internal.widgets.EnterNameDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericGeneratorsComposite
extends Pane<GenericGeneratorHolder> {
    private AddRemoveListPane<GenericGeneratorHolder> listPane;
    private WritablePropertyValueModel<GenericGenerator> generatorHolder;

    public GenericGeneratorsComposite(Pane<? extends GenericGeneratorHolder> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    private void addGenericGenerator() {
        HashSet<String> generatorNames = new HashSet<String>();
        ListIterator generators = ((GenericGeneratorHolder)this.getSubject()).getPersistenceUnit().generators();
        while (generators.hasNext()) {
            generatorNames.add(((Generator)generators.next()).getName());
        }
        EnterNameDialog dialog = new EnterNameDialog(this.getControl().getShell(), HibernateUIMappingMessages.GenericGeneratorsComposite_addGeneratorNameDescription, null, generatorNames);
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getName();
        GenericGenerator generator = ((GenericGeneratorHolder)this.getSubject()).addGenericGenerator(((GenericGeneratorHolder)this.getSubject()).genericGeneratorsSize());
        generator.setName(name);
    }

    private ListValueModel<GenericGenerator> buildDisplayableGeneratorsListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildGeneratorsListHolder(), new String[]{"name"});
    }

    private ListValueModel<GenericGenerator> buildGeneratorsListHolder() {
        return new ListAspectAdapter<GenericGeneratorHolder, GenericGenerator>(this.getSubjectHolder(), new String[]{"genericGenerators"}){

            protected ListIterator<GenericGenerator> listIterator_() {
                return ((GenericGeneratorHolder)this.subject).genericGenerators();
            }

            protected int size_() {
                return ((GenericGeneratorHolder)this.subject).genericGeneratorsSize();
            }
        };
    }

    private AddRemoveListPane<GenericGeneratorHolder> addListPane(Composite container) {
        return new AddRemoveListPane((Pane)this, container, this.buildGenericGeneratorsAdapter(), this.buildDisplayableGeneratorsListHolder(), this.generatorHolder, this.buildGeneratorsListLabelProvider(), null);
    }

    private AddRemovePane.Adapter buildGenericGeneratorsAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                GenericGeneratorsComposite.this.addGenericGenerator();
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    ((GenericGeneratorHolder)GenericGeneratorsComposite.this.getSubject()).removeGenericGenerator((GenericGenerator)item);
                    ++n2;
                }
            }
        };
    }

    private ILabelProvider buildGeneratorsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                GenericGenerator genericGenerator = (GenericGenerator)element;
                String name = genericGenerator.getName();
                if (name == null) {
                    int index = CollectionTools.indexOf((Iterator)((GenericGeneratorHolder)GenericGeneratorsComposite.this.getSubject()).genericGenerators(), (Object)genericGenerator);
                    name = NLS.bind((String)HibernateUIMappingMessages.GenericGeneratorsComposite_generatorNullName, (Object)index);
                }
                return name;
            }
        };
    }

    private WritablePropertyValueModel<GenericGenerator> buildGenericGeneratorHolder() {
        return new SimplePropertyValueModel();
    }

    public void enableWidgets(boolean enabled) {
        super.enableWidgets(enabled);
        this.listPane.enableWidgets(enabled);
    }

    protected void initialize() {
        super.initialize();
        this.generatorHolder = this.buildGenericGeneratorHolder();
    }

    protected void initializeLayout(Composite container) {
        if (this.getSubject() instanceof HibernateJavaIdMapping) {
            this.addLabeledText(container, HibernateUIMappingMessages.GenericGeneratorComposite_name, this.buildGeneratorNameHolder(), null);
        } else {
            this.listPane = this.addListPane(container);
        }
        Combo c = this.addLabeledEditableCombo(container, HibernateUIMappingMessages.GenericGeneratorComposite_strategy, (ListValueModel)new SimpleListValueModel(JavaGenericGeneratorImpl.generatorClasses), this.buildStrategyHolder(), StringConverter.Default.instance(), null);
        new ControlEnabler(this.buildControlEnabler(), (Control)c);
        new ParametersComposite(this, container, this.generatorHolder);
    }

    private PropertyValueModel<Boolean> buildControlEnabler() {
        return new TransformationPropertyValueModel<GenericGenerator, Boolean>(this.generatorHolder){

            public Boolean transform(GenericGenerator generator) {
                if (generator != null) {
                    return true;
                }
                return false;
            }
        };
    }

    protected final WritablePropertyValueModel<String> buildGeneratorNameHolder() {
        return new PropertyAspectAdapter<GenericGenerator, String>(this.generatorHolder, new String[]{"name"}){

            protected String buildValue_() {
                return this.subject == null ? null : ((GenericGenerator)this.subject).getName();
            }

            public void setValue(String value) {
                if (this.subject != null) {
                    this.setValue_(value);
                    return;
                }
                if ("".equals(value)) {
                    return;
                }
                GenericGenerator generator = ((GenericGeneratorHolder)GenericGeneratorsComposite.this.getSubject()).genericGeneratorsSize() == 0 ? ((GenericGeneratorHolder)GenericGeneratorsComposite.this.getSubject()).addGenericGenerator(0) : (GenericGenerator)((GenericGeneratorHolder)GenericGeneratorsComposite.this.getSubject()).genericGenerators().next();
                generator.setName(value);
                GenericGeneratorsComposite.this.generatorHolder.setValue((Object)generator);
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((GenericGenerator)this.subject).setName(value);
            }
        };
    }

    protected WritablePropertyValueModel<String> buildStrategyHolder() {
        return new PropertyAspectAdapter<GenericGenerator, String>(this.generatorHolder, new String[]{"genericStrategyProperty"}){

            protected String buildValue_() {
                return this.subject == null ? null : ((GenericGenerator)this.subject).getStrategy();
            }

            public void setValue(String value) {
                if (this.subject != null) {
                    this.setValue_(value);
                    return;
                }
                if ("".equals(value)) {
                    return;
                }
                GenericGenerator generator = ((GenericGeneratorHolder)GenericGeneratorsComposite.this.getSubject()).genericGeneratorsSize() == 0 ? ((GenericGeneratorHolder)GenericGeneratorsComposite.this.getSubject()).addGenericGenerator(0) : (GenericGenerator)((GenericGeneratorHolder)GenericGeneratorsComposite.this.getSubject()).genericGenerators().next();
                generator.setStrategy(value);
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((GenericGenerator)this.subject).setStrategy(value);
            }
        };
    }
}

