/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mapping.details;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.IntegerCombo;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateColumn;
import org.jboss.tools.hibernate.jpt.ui.internal.mappings.db.xpl.ColumnCombo;
import org.jboss.tools.hibernate.jpt.ui.internal.mappings.db.xpl.DatabaseObjectCombo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateColumnComposite
extends FormPane<HibernateColumn> {
    public HibernateColumnComposite(FormPane<?> parentPane, PropertyValueModel<? extends HibernateColumn> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent, false);
    }

    public HibernateColumnComposite(FormPane<?> parentPane, PropertyValueModel<? extends HibernateColumn> subjectHolder, Composite parent, boolean automaticallyAlignWidgets) {
        super(parentPane, subjectHolder, parent, automaticallyAlignWidgets);
    }

    public HibernateColumnComposite(FormPane<?> parentPane, PropertyValueModel<? extends HibernateColumn> subjectHolder, Composite parent, boolean automaticallyAlignWidgets, boolean parentManagePane) {
        super(parentPane, subjectHolder, parent, automaticallyAlignWidgets, parentManagePane);
    }

    private ColumnCombo<HibernateColumn> addColumnCombo(Composite container) {
        return new ColumnCombo<HibernateColumn>((Pane)this, container){

            @Override
            protected void initializeLayout(Composite container) {
                super.initializeLayout(container);
                this.comboBox.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        if (comboBox.getSelectionIndex() != 0) {
                            this.setPopulating(true);
                            comboBox.setText(((HibernateColumn)this.getSubject()).getName());
                            this.setPopulating(false);
                        }
                    }

                    public void focusLost(FocusEvent e) {
                        if (comboBox.getSelectionIndex() != 0) {
                            this.setPopulating(true);
                            comboBox.setText(this.getValue());
                            this.setPopulating(false);
                        }
                    }
                });
            }

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultName");
                propertyNames.add("specifiedName");
                propertyNames.add("defaultTable");
                propertyNames.add("specifiedTable");
            }

            @Override
            protected void propertyChanged(String propertyName) {
                if (propertyName == "defaultTable" || propertyName == "specifiedTable") {
                    this.doPopulate();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            @Override
            protected String getDefaultValue() {
                return ((HibernateColumn)this.getSubject()).getDefaultDBColumnName();
            }

            @Override
            protected void setValue(String value) {
                ((HibernateColumn)this.getSubject()).setSpecifiedName(value);
            }

            @Override
            protected Table getDbTable_() {
                return ((HibernateColumn)this.getSubject()).getDbTable();
            }

            @Override
            protected String getValue() {
                String specifiedName = ((HibernateColumn)this.getSubject()).getSpecifiedName();
                if (specifiedName == null) {
                    return null;
                }
                String dbColumnName = ((HibernateColumn)this.getSubject()).getDBColumnName();
                if (specifiedName.equals(dbColumnName)) {
                    return specifiedName;
                }
                return String.valueOf(specifiedName) + " (" + dbColumnName + ")";
            }

            public String toString() {
                return "ColumnComposite.columnCombo";
            }
        };
    }

    private WritablePropertyValueModel<String> buildColumnDefinitionHolder() {
        return new PropertyAspectAdapter<Column, String>(this.getSubjectHolder(), new String[]{"columnDefinition"}){

            protected String buildValue_() {
                return ((Column)this.subject).getColumnDefinition();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Column)this.subject).setColumnDefinition(value);
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildInsertableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"specifiedInsertable"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedInsertable();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedInsertable(value);
            }
        };
    }

    private PropertyValueModel<String> buildInsertableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildInsertableHolder()){

            protected String transform(Boolean value) {
                if (HibernateColumnComposite.this.getSubject() != null && value == null) {
                    boolean defaultValue = ((HibernateColumn)HibernateColumnComposite.this.getSubject()).isDefaultInsertable();
                    String defaultStringValue = defaultValue ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_insertableWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_insertable;
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildNullableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"defaultNullable", "specifiedNullable"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedNullable();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedNullable(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildNullableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildNullableHolder()){

            protected String transform(Boolean value) {
                if (HibernateColumnComposite.this.getSubject() != null && value == null) {
                    boolean defaultValue = ((HibernateColumn)HibernateColumnComposite.this.getSubject()).isDefaultNullable();
                    String defaultStringValue = defaultValue ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_nullableWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_nullable;
            }
        };
    }

    private Pane<HibernateColumn> addTableCombo(Composite container) {
        return new DatabaseObjectCombo<HibernateColumn>((Pane)this, container){

            @Override
            protected void initializeLayout(Composite container) {
                super.initializeLayout(container);
                this.comboBox.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        if (comboBox.getSelectionIndex() != 0) {
                            this.setPopulating(true);
                            comboBox.setText(((HibernateColumn)this.getSubject()).getName());
                            this.setPopulating(false);
                        }
                    }

                    public void focusLost(FocusEvent e) {
                        if (comboBox.getSelectionIndex() != 0) {
                            this.setPopulating(true);
                            comboBox.setText(this.getValue());
                            this.setPopulating(false);
                        }
                    }
                });
            }

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultTable");
                propertyNames.add("specifiedTable");
            }

            @Override
            protected String getDefaultValue() {
                return ((HibernateColumn)this.getSubject()).getDefaultDBTableName();
            }

            @Override
            protected void setValue(String value) {
                ((HibernateColumn)this.getSubject()).setSpecifiedTable(value);
            }

            @Override
            protected String getValue() {
                String specifiedName = ((HibernateColumn)this.getSubject()).getSpecifiedTable();
                if (specifiedName == null) {
                    return null;
                }
                String dbTableName = ((HibernateColumn)this.getSubject()).getDBTableName();
                if (specifiedName.equals(dbTableName)) {
                    return specifiedName;
                }
                return String.valueOf(specifiedName) + " (" + dbTableName + ")";
            }

            @Override
            protected Iterator<String> values() {
                return ((HibernateColumn)this.getSubject()).getOwner().getTypeMapping().associatedTableNamesIncludingInherited();
            }

            public String toString() {
                return "ColumnComposite.tableCombo";
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildUniqueHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"defaultUnique", "specifiedUnique"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedUnique();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedUnique(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildUniqueStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildUniqueHolder()){

            protected String transform(Boolean value) {
                if (HibernateColumnComposite.this.getSubject() != null && value == null) {
                    boolean defaultValue = ((HibernateColumn)HibernateColumnComposite.this.getSubject()).isDefaultUnique();
                    String defaultStringValue = defaultValue ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_uniqueWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_unique;
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildUpdatableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"defaulUpdatable", "specifiedUpdatable"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedUpdatable();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedUpdatable(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildUpdatableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildUpdatableHolder()){

            protected String transform(Boolean value) {
                if (HibernateColumnComposite.this.getSubject() != null && value == null) {
                    boolean defaultValue = ((HibernateColumn)HibernateColumnComposite.this.getSubject()).isDefaultUpdatable();
                    String defaultStringValue = defaultValue ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_updatableWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_updatable;
            }
        };
    }

    protected void initializeLayout(Composite container) {
        container = this.addTitledGroup(container, JptUiMappingsMessages.ColumnComposite_columnSection);
        this.addLabeledComposite(container, JptUiMappingsMessages.ColumnComposite_name, this.addColumnCombo(container), "org.eclipse.jpt.ui.mapping_column");
        this.addLabeledComposite(container, JptUiMappingsMessages.ColumnComposite_table, this.addTableCombo(container), "org.eclipse.jpt.ui.mapping_columnTable");
        container = this.addCollapsableSubSection(container, JptUiMappingsMessages.ColumnComposite_details, (PropertyValueModel)new SimplePropertyValueModel((Object)Boolean.FALSE));
        new DetailsComposite(this, (PropertyValueModel<? extends HibernateColumn>)this.getSubjectHolder(), this.addSubPane(container, 0, 16));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DetailsComposite
    extends FormPane<HibernateColumn> {
        public DetailsComposite(FormPane<?> parentPane, PropertyValueModel<? extends HibernateColumn> subjectHolder, Composite parent) {
            super(parentPane, subjectHolder, parent, false);
        }

        protected void initializeLayout(Composite container) {
            this.addTriStateCheckBoxWithDefault(this.addSubPane(container, 4), JptUiMappingsMessages.ColumnComposite_insertable, HibernateColumnComposite.this.buildInsertableHolder(), HibernateColumnComposite.this.buildInsertableStringHolder(), "org.eclipse.jpt.ui.mapping_columnInsertable");
            this.addTriStateCheckBoxWithDefault(container, JptUiMappingsMessages.ColumnComposite_updatable, HibernateColumnComposite.this.buildUpdatableHolder(), HibernateColumnComposite.this.buildUpdatableStringHolder(), "org.eclipse.jpt.ui.mapping_columnUpdatable");
            this.addTriStateCheckBoxWithDefault(container, JptUiMappingsMessages.ColumnComposite_unique, HibernateColumnComposite.this.buildUniqueHolder(), HibernateColumnComposite.this.buildUniqueStringHolder(), "org.eclipse.jpt.ui.mapping_columnUnique");
            this.addTriStateCheckBoxWithDefault(container, JptUiMappingsMessages.ColumnComposite_nullable, HibernateColumnComposite.this.buildNullableHolder(), HibernateColumnComposite.this.buildNullableStringHolder(), "org.eclipse.jpt.ui.mapping_columnNullable");
            this.addLengthCombo(container);
            this.addPrecisionCombo(container);
            this.addScaleCombo(container);
            this.addLabeledText(container, JptUiMappingsMessages.ColumnComposite_columnDefinition, HibernateColumnComposite.this.buildColumnDefinitionHolder());
        }

        private void addLengthCombo(Composite container) {
            new IntegerCombo<HibernateColumn>((Pane)this, container){

                protected String getLabelText() {
                    return JptUiMappingsMessages.ColumnComposite_length;
                }

                protected String getHelpId() {
                    return "org.eclipse.jpt.ui.mapping_columnLength";
                }

                protected PropertyValueModel<Integer> buildDefaultHolder() {
                    return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"defaultLength"}){

                        protected Integer buildValue_() {
                            return ((Column)this.subject).getDefaultLength();
                        }
                    };
                }

                protected WritablePropertyValueModel<Integer> buildSelectedItemHolder() {
                    return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"specifiedLength"}){

                        protected Integer buildValue_() {
                            return ((Column)this.subject).getSpecifiedLength();
                        }

                        protected void setValue_(Integer value) {
                            ((Column)this.subject).setSpecifiedLength(value);
                        }
                    };
                }
            };
        }

        private void addPrecisionCombo(Composite container) {
            new IntegerCombo<HibernateColumn>((Pane)this, container){

                protected String getLabelText() {
                    return JptUiMappingsMessages.ColumnComposite_precision;
                }

                protected String getHelpId() {
                    return "org.eclipse.jpt.ui.mapping_columnPrecision";
                }

                protected PropertyValueModel<Integer> buildDefaultHolder() {
                    return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"defaultPrecision"}){

                        protected Integer buildValue_() {
                            return ((Column)this.subject).getDefaultPrecision();
                        }
                    };
                }

                protected WritablePropertyValueModel<Integer> buildSelectedItemHolder() {
                    return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"specifiedPrecision"}){

                        protected Integer buildValue_() {
                            return ((Column)this.subject).getSpecifiedPrecision();
                        }

                        protected void setValue_(Integer value) {
                            ((Column)this.subject).setSpecifiedPrecision(value);
                        }
                    };
                }
            };
        }

        private void addScaleCombo(Composite container) {
            new IntegerCombo<HibernateColumn>((Pane)this, container){

                protected String getLabelText() {
                    return JptUiMappingsMessages.ColumnComposite_scale;
                }

                protected String getHelpId() {
                    return "org.eclipse.jpt.ui.mapping_columnScale";
                }

                protected PropertyValueModel<Integer> buildDefaultHolder() {
                    return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"defaultScale"}){

                        protected Integer buildValue_() {
                            return ((Column)this.subject).getDefaultScale();
                        }
                    };
                }

                protected WritablePropertyValueModel<Integer> buildSelectedItemHolder() {
                    return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"specifiedScale"}){

                        protected Integer buildValue_() {
                            return ((Column)this.subject).getSpecifiedScale();
                        }

                        protected void setValue_(Integer value) {
                            ((Column)this.subject).setSpecifiedScale(value);
                        }
                    };
                }
            };
        }
    }
}

