/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mapping.details;

import org.eclipse.jpt.core.context.java.JavaGeneratedValue;
import org.eclipse.jpt.core.context.java.JavaSequenceGenerator;
import org.eclipse.jpt.core.context.java.JavaTableGenerator;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.GeneratedValueComposite;
import org.eclipse.jpt.ui.internal.mappings.details.SequenceGeneratorComposite;
import org.eclipse.jpt.ui.internal.mappings.details.TableGeneratorComposite;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.hibernate.jpt.core.internal.context.GenericGenerator;
import org.jboss.tools.hibernate.jpt.core.internal.context.GenericGeneratorHolder;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaIdMapping;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.GenericGeneratorsComposite;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateUIMappingMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateGenerationComposite
extends FormPane<HibernateJavaIdMapping> {
    private WritablePropertyValueModel<Boolean> sequenceGeneratorExpansionStateHolder;
    private WritablePropertyValueModel<Boolean> tableGeneratorExpansionStateHolder;
    private WritablePropertyValueModel<Boolean> genericGeneratorExpansionStateHolder;

    public HibernateGenerationComposite(FormPane<? extends HibernateJavaIdMapping> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    private WritablePropertyValueModel<Boolean> buildPrimaryKeyGenerationHolder() {
        return new PropertyAspectAdapter<HibernateJavaIdMapping, Boolean>(this.getSubjectHolder(), new String[]{"generatedValue"}){

            protected Boolean buildValue_() {
                if (((HibernateJavaIdMapping)this.subject).getGeneratedValue() != null) {
                    return true;
                }
                return false;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue() && ((HibernateJavaIdMapping)this.subject).getGeneratedValue() == null) {
                    ((HibernateJavaIdMapping)this.subject).addGeneratedValue();
                } else if (!value.booleanValue() && ((HibernateJavaIdMapping)this.subject).getGeneratedValue() != null) {
                    ((HibernateJavaIdMapping)this.subject).removeGeneratedValue();
                }
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildSequenceGeneratorBooleanHolder() {
        return new PropertyAspectAdapter<HibernateJavaIdMapping, Boolean>(this.getSubjectHolder(), new String[]{"sequenceGenerator"}){

            protected Boolean buildValue_() {
                if (((HibernateJavaIdMapping)this.subject).getSequenceGenerator() != null) {
                    return true;
                }
                return false;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue() && ((HibernateJavaIdMapping)this.subject).getSequenceGenerator() == null) {
                    JavaSequenceGenerator sequenceGenerator = ((HibernateJavaIdMapping)this.subject).addSequenceGenerator();
                    JavaGeneratedValue generatedValue = ((HibernateJavaIdMapping)this.subject).getGeneratedValue();
                    if (generatedValue != null && generatedValue.getGenerator() != null) {
                        sequenceGenerator.setName(generatedValue.getGenerator());
                    }
                } else if (!value.booleanValue() && ((HibernateJavaIdMapping)this.subject).getSequenceGenerator() != null) {
                    ((HibernateJavaIdMapping)this.subject).removeSequenceGenerator();
                }
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildTableGeneratorBooleanHolder() {
        return new PropertyAspectAdapter<HibernateJavaIdMapping, Boolean>(this.getSubjectHolder(), new String[]{"tableGenerator"}){

            protected Boolean buildValue_() {
                if (((HibernateJavaIdMapping)this.subject).getTableGenerator() != null) {
                    return true;
                }
                return false;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue() && ((HibernateJavaIdMapping)this.subject).getTableGenerator() == null) {
                    JavaTableGenerator tableGenerator = ((HibernateJavaIdMapping)this.subject).addTableGenerator();
                    JavaGeneratedValue generatedValue = ((HibernateJavaIdMapping)this.subject).getGeneratedValue();
                    if (generatedValue != null && generatedValue.getGenerator() != null) {
                        tableGenerator.setName(generatedValue.getGenerator());
                    }
                } else if (!value.booleanValue() && ((HibernateJavaIdMapping)this.subject).getTableGenerator() != null) {
                    ((HibernateJavaIdMapping)this.subject).removeTableGenerator();
                }
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildGenericGeneratorBooleanHolder() {
        return new PropertyAspectAdapter<HibernateJavaIdMapping, Boolean>(this.getSubjectHolder(), new String[]{"genericGenerators"}){

            protected Boolean buildValue_() {
                if (((HibernateJavaIdMapping)this.subject).genericGeneratorsSize() > 0) {
                    return true;
                }
                return false;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue() && ((HibernateJavaIdMapping)this.subject).genericGeneratorsSize() > 0) {
                    GenericGenerator genericGenerator = ((HibernateJavaIdMapping)this.subject).addGenericGenerator(0);
                    JavaGeneratedValue generatedValue = ((HibernateJavaIdMapping)this.subject).getGeneratedValue();
                    if (generatedValue != null && generatedValue.getGenerator() != null) {
                        genericGenerator.setName(generatedValue.getGenerator());
                    }
                } else if (!value.booleanValue() && ((HibernateJavaIdMapping)this.subject).genericGeneratorsSize() > 0) {
                    ((HibernateJavaIdMapping)this.subject).removeGenericGenerator(0);
                }
            }
        };
    }

    protected void doPopulate() {
        super.doPopulate();
        this.sequenceGeneratorExpansionStateHolder.setValue((Object)(this.getSubject() != null && ((HibernateJavaIdMapping)this.getSubject()).getSequenceGenerator() != null ? 1 : 0));
        this.tableGeneratorExpansionStateHolder.setValue((Object)(this.getSubject() != null && ((HibernateJavaIdMapping)this.getSubject()).getTableGenerator() != null ? 1 : 0));
        this.genericGeneratorExpansionStateHolder.setValue((Object)(this.getSubject() != null && ((HibernateJavaIdMapping)this.getSubject()).genericGeneratorsSize() > 0 ? 1 : 0));
    }

    protected void initialize() {
        super.initialize();
        this.sequenceGeneratorExpansionStateHolder = new SimplePropertyValueModel((Object)false);
        this.tableGeneratorExpansionStateHolder = new SimplePropertyValueModel((Object)false);
        this.genericGeneratorExpansionStateHolder = new SimplePropertyValueModel((Object)false);
    }

    protected void initializeLayout(Composite container) {
        container = this.addCollapsableSection(container, JptUiMappingsMessages.IdMappingComposite_primaryKeyGenerationSection, (PropertyValueModel)new SimplePropertyValueModel((Object)Boolean.TRUE));
        Button primaryKeyGenerationCheckBox = this.addCheckBox(container, JptUiMappingsMessages.IdMappingComposite_primaryKeyGenerationCheckBox, this.buildPrimaryKeyGenerationHolder(), "org.eclipse.jpt.ui.mapping_primaryKeyGeneration");
        GeneratedValueComposite generatedValueComposite = new GeneratedValueComposite((FormPane)this, container);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = primaryKeyGenerationCheckBox.getBorderWidth() + 16;
        generatedValueComposite.getControl().setLayoutData((Object)gridData);
        this.initializeTableGeneratorPane(this.addSubPane(container, 10));
        this.initializeSequenceGeneratorPane(this.addSubPane(container, 10));
        this.initializeGenericGeneratorPane(this.addSubPane(container, 10));
    }

    private void initializeSequenceGeneratorPane(Composite container) {
        container = this.addCollapsableSubSection(container, JptUiMappingsMessages.IdMappingComposite_sequenceGeneratorSection, (PropertyValueModel)this.sequenceGeneratorExpansionStateHolder);
        Button sequenceGeneratorCheckBox = this.addCheckBox(container, JptUiMappingsMessages.IdMappingComposite_sequenceGeneratorCheckBox, this.buildSequenceGeneratorBooleanHolder(), "org.eclipse.jpt.ui.mapping_sequenceGenerator");
        new SequenceGeneratorComposite((Pane)this, this.addSubPane(container, 0, sequenceGeneratorCheckBox.getBorderWidth() + 16));
    }

    private void initializeTableGeneratorPane(Composite container) {
        container = this.addCollapsableSubSection(container, JptUiMappingsMessages.IdMappingComposite_tableGeneratorSection, (PropertyValueModel)this.tableGeneratorExpansionStateHolder);
        Button tableGeneratorCheckBox = this.addCheckBox(container, JptUiMappingsMessages.IdMappingComposite_tableGeneratorCheckBox, this.buildTableGeneratorBooleanHolder(), "org.eclipse.jpt.ui.mapping_tableGenerator");
        new TableGeneratorComposite((Pane)this, this.addSubPane(container, 0, tableGeneratorCheckBox.getBorderWidth() + 16));
    }

    private void initializeGenericGeneratorPane(Composite container) {
        container = this.addCollapsableSubSection(container, HibernateUIMappingMessages.HibernateIdMappingComposite_genericGeneratorSection, (PropertyValueModel)this.genericGeneratorExpansionStateHolder);
        Button genericGeneratorCheckBox = this.addCheckBox(container, HibernateUIMappingMessages.HibernateIdMappingComposite_genericGeneratorCheckBox, this.buildGenericGeneratorBooleanHolder(), null);
        new GenericGeneratorsComposite((Pane<? extends GenericGeneratorHolder>)this, this.addSubPane(container, 0, genericGeneratorCheckBox.getBorderWidth() + 16));
    }
}

