/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mapping.details;

import org.eclipse.jpt.core.context.Converter;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.TemporalConverter;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.JpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.GenerationComposite;
import org.eclipse.jpt.ui.internal.mappings.details.TemporalTypeComposite;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateColumn;
import org.jboss.tools.hibernate.jpt.core.internal.context.IndexHolder;
import org.jboss.tools.hibernate.jpt.core.internal.context.basic.HibernateIdMapping;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaIdMapping;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateColumnComposite;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateGenerationComposite;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateUIMappingMessages;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.IndexHolderComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateIdMappingComposite
extends FormPane<HibernateIdMapping>
implements JpaComposite {
    public HibernateIdMappingComposite(PropertyValueModel<? extends HibernateIdMapping> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    private PropertyValueModel<? extends HibernateColumn> buildColumnHolder() {
        return new TransformationPropertyValueModel<IdMapping, HibernateColumn>(this.getSubjectHolder()){

            protected HibernateColumn transform_(IdMapping value) {
                return (HibernateColumn)value.getColumn();
            }
        };
    }

    protected void initializeLayout(Composite container) {
        new HibernateColumnComposite(this, this.buildColumnHolder(), container);
        this.initializeTypePane(container);
        if (this.getSubject() instanceof HibernateJavaIdMapping) {
            new HibernateGenerationComposite(this, this.addSubPane(container, 10));
        } else {
            new GenerationComposite((FormPane)this, this.addSubPane(container, 10));
        }
        if (this.getSubject() instanceof IndexHolder) {
            container = this.addCollapsableSection(container, HibernateUIMappingMessages.Index_section_index);
            ((GridLayout)container.getLayout()).numColumns = 2;
            new IndexHolderComposite(this, container);
        }
    }

    private void initializeTypePane(Composite container) {
        container = this.addCollapsableSection(container, JptUiMappingsMessages.TypeSection_type);
        ((GridLayout)container.getLayout()).numColumns = 2;
        Button noConverterButton = this.addRadioButton(container, JptUiMappingsMessages.TypeSection_default, this.buildNoConverterHolder(), null);
        ((GridData)noConverterButton.getLayoutData()).horizontalSpan = 2;
        PropertyValueModel<Converter> specifiedConverterHolder = this.buildSpecifiedConverterHolder();
        this.addRadioButton(container, JptUiMappingsMessages.TypeSection_temporal, this.buildTemporalBooleanHolder(), null);
        this.registerSubPane((Pane)new TemporalTypeComposite(this.buildTemporalConverterHolder(specifiedConverterHolder), container, this.getWidgetFactory()));
    }

    private WritablePropertyValueModel<Boolean> buildNoConverterHolder() {
        return new PropertyAspectAdapter<IdMapping, Boolean>(this.getSubjectHolder(), new String[]{"specifiedConverter"}){

            protected Boolean buildValue_() {
                return ((IdMapping)this.subject).getSpecifiedConverter() == null;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((IdMapping)this.subject).setSpecifiedConverter("noConverter");
                }
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildTemporalBooleanHolder() {
        return new PropertyAspectAdapter<IdMapping, Boolean>(this.getSubjectHolder(), new String[]{"specifiedConverter"}){

            protected Boolean buildValue_() {
                Converter converter = ((IdMapping)this.subject).getSpecifiedConverter();
                if (converter == null) {
                    return Boolean.FALSE;
                }
                return converter.getType() == "temporalConverter";
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((IdMapping)this.subject).setSpecifiedConverter("temporalConverter");
                }
            }
        };
    }

    private PropertyValueModel<Converter> buildSpecifiedConverterHolder() {
        return new PropertyAspectAdapter<IdMapping, Converter>(this.getSubjectHolder(), new String[]{"specifiedConverter"}){

            protected Converter buildValue_() {
                return ((IdMapping)this.subject).getSpecifiedConverter();
            }
        };
    }

    private PropertyValueModel<TemporalConverter> buildTemporalConverterHolder(PropertyValueModel<Converter> converterHolder) {
        return new TransformationPropertyValueModel<Converter, TemporalConverter>(converterHolder){

            protected TemporalConverter transform_(Converter converter) {
                return converter != null && converter.getType() == "temporalConverter" ? (TemporalConverter)converter : null;
            }
        };
    }
}

