/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.persistence.details;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.JpaPageComposite;
import org.eclipse.jpt.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.utils.DialogSelectionHelper;
import org.hibernate.eclipse.console.utils.DriverClassHelpers;
import org.hibernate.eclipse.console.wizards.NewConfigurationWizard;
import org.hibernate.eclipse.console.wizards.NewConfigurationWizardPage;
import org.hibernate.eclipse.launch.PathHelper;
import org.jboss.tools.hibernate.jpt.core.internal.context.basic.BasicHibernateProperties;
import org.jboss.tools.hibernate.jpt.ui.wizard.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatePropertiesComposite
extends FormPane<BasicHibernateProperties>
implements JpaPageComposite {
    private Text cfgFile;
    DriverClassHelpers helper;

    public HibernatePropertiesComposite(PropertyValueModel<BasicHibernateProperties> subjectHolder, Composite container, WidgetFactory widgetFactory) {
        super(subjectHolder, container, widgetFactory);
    }

    protected void initializeLayout(Composite container) {
        Composite section = this.addSection(container, Messages.HibernatePropertiesComposite_basic_properties);
        this.helper = new DriverClassHelpers();
        SimpleListValueModel lvmDialect = new SimpleListValueModel(Arrays.asList(this.helper.getDialectNames()));
        PropertyValueModel p = this.getSubjectHolder();
        ArrayList<String> drivers = new ArrayList<String>();
        BasicHibernateProperties props = (BasicHibernateProperties)p.getValue();
        if (props != null) {
            String dialectClass = this.helper.getDialectClass(props.getDialect());
            String[] driverClasses = this.helper.getDriverClasses(dialectClass);
            drivers.addAll(Arrays.asList(driverClasses));
        }
        final SimpleListValueModel lvmDriver = new SimpleListValueModel(drivers);
        ArrayList<String> urls = new ArrayList<String>();
        if (props != null) {
            String driverClass = props.getDriver();
            String[] connectionURLS = this.helper.getConnectionURLS(driverClass);
            urls.addAll(Arrays.asList(connectionURLS));
        }
        final SimpleListValueModel lvmUrl = new SimpleListValueModel(urls);
        WritablePropertyValueModel<String> dialectHolder = this.buildDialectHolder();
        final WritablePropertyValueModel<String> driverHolder = this.buildDriverHolder();
        final WritablePropertyValueModel<String> urlHolder = this.buildUrlHolder();
        Button b = this.addButton(section, HibernateConsoleMessages.CodeGenerationSettingsTab_setup, this.createSetupAction());
        this.cfgFile = this.addLabeledText(section, String.valueOf(HibernateConsoleMessages.ConsoleConfigurationPropertySource_config_file) + ':', this.buildConfigFileHolder(), (Control)b, null);
        this.addLabeledEditableCombo(section, HibernateConsoleMessages.NewConfigurationWizardPage_database_dialect, (ListValueModel)lvmDialect, dialectHolder, StringConverter.Default.instance(), null);
        this.addLabeledEditableCombo(section, HibernateConsoleMessages.NewConfigurationWizardPage_driver_class, (ListValueModel)lvmDriver, driverHolder, StringConverter.Default.instance(), null);
        this.addLabeledEditableCombo(section, HibernateConsoleMessages.NewConfigurationWizardPage_connection_url, (ListValueModel)lvmUrl, urlHolder, StringConverter.Default.instance(), null);
        dialectHolder.addPropertyChangeListener((PropertyChangeListener)new SWTPropertyChangeListenerWrapper(new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                String dialectClass = HibernatePropertiesComposite.this.helper.getDialectClass((String)event.getNewValue());
                String[] driverClasses = HibernatePropertiesComposite.this.helper.getDriverClasses(dialectClass);
                String driver = (String)driverHolder.getValue();
                lvmDriver.clear();
                lvmDriver.addAll(Arrays.asList(driverClasses));
                driverHolder.setValue((Object)driver);
            }
        }));
        driverHolder.addPropertyChangeListener((PropertyChangeListener)new SWTPropertyChangeListenerWrapper(new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                String driverClass = (String)event.getNewValue();
                String[] connectionURLS = HibernatePropertiesComposite.this.helper.getConnectionURLS(driverClass);
                String url = (String)urlHolder.getValue();
                lvmUrl.clear();
                lvmUrl.addAll(Arrays.asList(connectionURLS));
                urlHolder.setValue((Object)url);
            }
        }));
        this.addLabeledText(section, HibernateConsoleMessages.NewConfigurationWizardPage_default_schema, this.buildSchemaDefaultHolder());
        this.addLabeledText(section, HibernateConsoleMessages.NewConfigurationWizardPage_default_catalog, this.buildCatalogDefaultHolder());
        this.addLabeledText(section, HibernateConsoleMessages.NewConfigurationWizardPage_user_name, this.buildUsernameHolder());
        this.addLabeledText(section, HibernateConsoleMessages.NewConfigurationWizardPage_password, this.buildPasswordHolder());
    }

    private IPath getConfigurationFilePath() {
        return PathHelper.pathOrNull((String)this.cfgFile.getText());
    }

    private Runnable createSetupAction() {
        return new Runnable(){

            public void run() {
                MessageDialog dialog;
                int answer;
                IPath initialPath = HibernatePropertiesComposite.this.getConfigurationFilePath();
                int defaultChoice = 0;
                if (initialPath != null) {
                    defaultChoice = 1;
                }
                if ((answer = (dialog = this.createSetupDialog(HibernateConsoleMessages.ConsoleConfigurationMainTab_setup_configuration_file, HibernateConsoleMessages.ConsoleConfigurationMainTab_do_you_want_to_create_new_cfgxml, defaultChoice)).open()) == 0) {
                    this.handleConfigurationFileCreate();
                } else if (answer == 1) {
                    this.handleConfigurationFileBrowse();
                }
            }

            private MessageDialog createSetupDialog(String title, String question, int defaultChoice) {
                return new MessageDialog(HibernatePropertiesComposite.this.getShell(), title, null, question, 3, new String[]{HibernateConsoleMessages.ConsoleConfigurationMainTab_create_new, HibernateConsoleMessages.ConsoleConfigurationMainTab_use_existing, IDialogConstants.CANCEL_LABEL}, defaultChoice);
            }

            private void handleConfigurationFileBrowse() {
                IPath initialPath = HibernatePropertiesComposite.this.getConfigurationFilePath();
                IPath[] paths = DialogSelectionHelper.chooseFileEntries((Shell)HibernatePropertiesComposite.this.getShell(), (IPath)initialPath, (IPath[])new IPath[0], (String)HibernateConsoleMessages.ConsoleConfigurationMainTab_select_hibernate_cfg_xml_file, (String)HibernateConsoleMessages.ConsoleConfigurationMainTab_choose_file_to_use_as_hibernate_cfg_xml, (String[])new String[]{HibernateConsoleMessages.ConsoleConfigurationMainTab_cfg_xml}, (boolean)false, (boolean)false, (boolean)true);
                if (paths != null && paths.length == 1) {
                    HibernatePropertiesComposite.this.cfgFile.setText(paths[0].toOSString());
                }
            }

            private void handleConfigurationFileCreate() {
                WizardNewFileCreationPage createdFilePath;
                NewConfigurationWizard wizard = new NewConfigurationWizard();
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                WizardDialog wdialog = new WizardDialog(win.getShell(), (IWizard)wizard);
                wdialog.create();
                IWizardPage configPage = wizard.getPage(HibernateConsoleMessages.ConsoleConfigurationMainTab_wizard_page);
                if (configPage != null && configPage instanceof NewConfigurationWizardPage) {
                    ((NewConfigurationWizardPage)configPage).setCreateConsoleConfigurationVisible(false);
                }
                if (wdialog.open() == 0 && (createdFilePath = (WizardNewFileCreationPage)wizard.getStartingPage()) != null) {
                    HibernatePropertiesComposite.this.cfgFile.setText(createdFilePath.createNewFile().getFullPath().toOSString());
                }
            }
        };
    }

    private WritablePropertyValueModel<String> buildConfigFileHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"confFileProperty"}){

            protected String buildValue_() {
                return ((BasicHibernateProperties)this.subject).getConfigurationFile();
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setConfigurationFile(value);
            }
        };
    }

    private WritablePropertyValueModel<String> buildDialectHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"dialectProperty"}){

            protected String buildValue_() {
                return HibernatePropertiesComposite.this.helper.getShortDialectName(((BasicHibernateProperties)this.subject).getDialect());
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setDialect(HibernatePropertiesComposite.this.helper.getDialectClass(value));
            }
        };
    }

    private WritablePropertyValueModel<String> buildDriverHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"driverProperty"}){

            protected String buildValue_() {
                return ((BasicHibernateProperties)this.subject).getDriver();
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setDriver(value);
            }
        };
    }

    private WritablePropertyValueModel<String> buildUrlHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"urlProperty"}){

            protected String buildValue_() {
                return ((BasicHibernateProperties)this.subject).getUrl();
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setUrl(value);
            }
        };
    }

    private WritablePropertyValueModel<String> buildSchemaDefaultHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"schemaDefaultProperty"}){

            protected String buildValue_() {
                return ((BasicHibernateProperties)this.subject).getSchemaDefault();
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setSchemaDefault(value);
            }
        };
    }

    private WritablePropertyValueModel<String> buildCatalogDefaultHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"catalogDefaultProperty"}){

            protected String buildValue_() {
                return ((BasicHibernateProperties)this.subject).getCatalogDefault();
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setCatalogDefault(value);
            }
        };
    }

    private WritablePropertyValueModel<String> buildUsernameHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"usernameProperty"}){

            protected String buildValue_() {
                return ((BasicHibernateProperties)this.subject).getUsername();
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setUsername(value);
            }

            protected void propertyChanged() {
                super.propertyChanged();
            }
        };
    }

    private WritablePropertyValueModel<String> buildPasswordHolder() {
        return new PropertyAspectAdapter<BasicHibernateProperties, String>(this.getSubjectHolder(), new String[]{"passwordProperty"}){

            protected String buildValue_() {
                return ((BasicHibernateProperties)this.subject).getPassword();
            }

            protected void setValue_(String value) {
                if ("".equals(value)) {
                    value = null;
                }
                ((BasicHibernateProperties)this.subject).setPassword(value);
            }
        };
    }

    public String getHelpID() {
        return null;
    }

    public Image getPageImage() {
        return null;
    }

    public String getPageText() {
        return Messages.HibernatePropertiesComposite_hibernate;
    }
}

