/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.wizard;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.hibernate.util.StringHelper;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.ui.wizard.GenerateInitWizardPage;
import org.jboss.tools.hibernate.jpt.ui.wizard.Messages;

public class GenerateDdlWizardPage
extends GenerateInitWizardPage {
    private StringDialogField filename;
    private Button exportToDB;

    protected GenerateDdlWizardPage(HibernateJpaProject jpaProject) {
        super(jpaProject);
    }

    protected void createChildControls(Composite container) {
        this.filename = new StringDialogField();
        this.filename.setLabelText(Messages.GenerateDdlWizardPage_file_name);
        this.filename.setText("schema.ddl");
        this.filename.setDialogFieldListener(this.fieldlistener);
        this.filename.doFillIntoGrid(container, this.numColumns);
        this.exportToDB = new Button(container, 32);
        this.exportToDB.setText(Messages.GenerateInitWizardPage_export_to_db);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.numColumns;
        this.exportToDB.setLayoutData((Object)gd);
    }

    protected void dialogChanged() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (StringHelper.isEmpty((String)this.getFilename())) {
            this.setErrorMessage(Messages.GenerateDdlWizardPage_err_msg_input_file_name);
            this.setPageComplete(false);
            return;
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateName(this.getFilename(), 1);
        if (status.getSeverity() != 0) {
            this.setErrorMessage(status.getMessage());
            return;
        }
        super.dialogChanged();
    }

    public String getFilename() {
        return this.filename.getText();
    }

    public boolean isExportToDB() {
        return this.exportToDB.getSelection();
    }
}

