/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jpt.core.JpaDataSource;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.osgi.util.NLS;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.utils.ClassLoaderHelper;
import org.hibernate.eclipse.console.utils.DriverClassHelpers;
import org.w3c.dom.Element;

public class EclipseLaunchConsoleConfigurationPreferences
implements ConsoleConfigurationPreferences {
    private final ILaunchConfiguration launchConfiguration;

    public EclipseLaunchConsoleConfigurationPreferences(ILaunchConfiguration configuration) {
        this.launchConfiguration = configuration;
    }

    private File strToFile(String epath) {
        if (epath == null) {
            return null;
        }
        Path path = new Path(epath);
        return this.pathToFile((IPath)path);
    }

    private File pathToFile(IPath path) {
        File file;
        if (path == null) {
            return null;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource == null && (file = new File(path.toOSString())).exists() && file.isFile()) {
            return file;
        }
        return this.pathToFile(path.toString(), resource);
    }

    private File pathToFile(String path, IResource resource) {
        IPath rawLocation;
        if (resource != null && (rawLocation = resource.getRawLocation()) != null) {
            return rawLocation.toFile();
        }
        String out = NLS.bind((String)HibernateConsoleMessages.EclipseLaunchConsoleConfigurationPreferences_could_not_resolve_to_file, (Object)path);
        throw new HibernateConsoleRuntimeException(out);
    }

    protected String getAttribute(String attr, String defaultValue) {
        try {
            String value = this.launchConfiguration.getAttribute(attr, defaultValue);
            return value;
        }
        catch (CoreException e) {
            throw new HibernateConsoleRuntimeException((Throwable)e);
        }
    }

    public File getConfigXMLFile() {
        String file = this.getAttribute("org.hibernate.eclipse.launch.CFG_XML_FILE", null);
        return this.strToFile(file);
    }

    public ConsoleConfigurationPreferences.ConfigurationMode getConfigurationMode() {
        return ConsoleConfigurationPreferences.ConfigurationMode.parse((String)this.getAttribute("org.hibernate.eclipse.launch.CONFIGURATION_FACTORY", ""));
    }

    public URL[] getCustomClassPathURLS() {
        try {
            String[] classpath = ClassLoaderHelper.getClasspath(this.launchConfiguration);
            URL[] cp = new URL[classpath.length];
            int i = 0;
            while (i < classpath.length) {
                String str = classpath[i];
                cp[i] = new File(str).toURL();
                ++i;
            }
            return cp;
        }
        catch (CoreException e) {
            throw new HibernateConsoleRuntimeException(HibernateConsoleMessages.EclipseLaunchConsoleConfigurationPreferences_could_not_compute_classpath, (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new HibernateConsoleRuntimeException(HibernateConsoleMessages.EclipseLaunchConsoleConfigurationPreferences_could_not_compute_classpath, (Throwable)e);
        }
    }

    public String getEntityResolverName() {
        return this.getAttribute("org.hibernate.eclipse.launchENTITY_RESOLVER", null);
    }

    public File[] getMappingFiles() {
        try {
            List mappings = this.launchConfiguration.getAttribute("org.hibernate.eclipse.launch.FILE_MAPPINGS", Collections.EMPTY_LIST);
            File[] result = new File[mappings.size()];
            int i = 0;
            for (String element : mappings) {
                result[i++] = this.strToFile(element);
            }
            return result;
        }
        catch (CoreException e) {
            throw new HibernateConsoleRuntimeException((Throwable)e);
        }
    }

    public String getName() {
        return this.launchConfiguration.getName();
    }

    public String getNamingStrategy() {
        return this.getAttribute("org.hibernate.eclipse.launchNAMING_STRATEGY", null);
    }

    public String getConnectionProfileName() {
        JpaDataSource ds;
        JpaProject jpaProject;
        IProject project;
        String projName;
        if (Boolean.parseBoolean(this.getAttribute("org.hibernate.eclipse.launch.USE_JPA_PROJECT_PROFILE", null)) && (projName = this.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null)) != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName)) != null && (jpaProject = (JpaProject)project.getAdapter(JpaProject.class)) != null && (ds = jpaProject.getDataSource()) != null) {
            return "".equals(ds.getConnectionProfileName()) ? null : ds.getConnectionProfileName();
        }
        return this.getAttribute("org.hibernate.eclipse.launch.CONNECTION_PROFILE_NAME", null);
    }

    public String getPersistenceUnitName() {
        return this.getAttribute("org.hibernate.eclipse.launch.PERSISTENCE_UNIT_NAME", null);
    }

    public Properties getProperties() {
        File propFile = this.getPropertyFile();
        if (propFile == null) {
            return null;
        }
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(propFile);
                p.load(fis);
            }
            catch (IOException io) {
                throw new HibernateConsoleRuntimeException(NLS.bind((String)HibernateConsoleMessages.EclipseLaunchConsoleConfigurationPreferences_could_not_load_property_file, (Object)propFile), (Throwable)io);
            }
        }
        catch (Throwable throwable) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        return p;
    }

    public File getPropertyFile() {
        return this.strToFile(this.getAttribute("org.hibernate.eclipse.launch.PROPERTY_FILE", null));
    }

    public void readStateFrom(Element element) {
        throw new IllegalStateException(HibernateConsoleMessages.EclipseLaunchConsoleConfigurationPreferences_cannot_read_from_xml);
    }

    public void setName(String name) {
        throw new IllegalStateException(NLS.bind((String)HibernateConsoleMessages.EclipseLaunchConsoleConfigurationPreferences_cannot_be_renamed, (Object)this.getName()));
    }

    public void writeStateTo(Element node) {
        throw new IllegalStateException(HibernateConsoleMessages.EclipseLaunchConsoleConfigurationPreferences_cannot_write_to_xml);
    }

    public String getDialectName() {
        String dialect = this.getAttribute("org.hibernate.eclipse.launchDIALECT", null);
        if (dialect == null && this.getConnectionProfileName() != null && this.getConnectionProfileName() != null) {
            IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(this.getConnectionProfileName());
            if (profile == null) {
                return null;
            }
            String driver = profile.getProperties(profile.getProviderId()).getProperty("org.eclipse.datatools.connectivity.db.driverClass");
            dialect = new DriverClassHelpers().getDialect(driver);
        }
        return dialect;
    }
}

