/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.hibernate.eclipse.console.HibernateConsolePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFilter
extends ViewerFilter {
    private final String[] fileExtensions;
    private List<IResource> excludedFiles;
    private boolean recursive;
    private final boolean allowDirectories;

    public FileFilter(String[] fileExtensions, IResource[] excludedFiles, boolean recusive) {
        this.fileExtensions = fileExtensions;
        this.excludedFiles = excludedFiles != null ? Arrays.asList(excludedFiles) : null;
        this.recursive = recusive;
        this.allowDirectories = false;
    }

    public FileFilter(String[] fileExtensions, List<IResource> usedFiles, boolean recusive, boolean allowDirectories) {
        this.fileExtensions = fileExtensions;
        this.excludedFiles = usedFiles;
        this.recursive = recusive;
        this.allowDirectories = allowDirectories;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            if (this.excludedFiles == null) return this.isFileExtension(((IFile)element).getFullPath());
            if (!this.excludedFiles.contains(element)) return this.isFileExtension(((IFile)element).getFullPath());
            return false;
        }
        if (this.allowDirectories && element instanceof IFolder) {
            return true;
        }
        if (!(element instanceof IContainer)) return false;
        if (!((IContainer)element).isAccessible()) {
            return false;
        }
        if (!this.recursive) {
            return true;
        }
        try {
            IResource[] resources = ((IContainer)element).members();
            int i = 0;
            while (true) {
                if (i >= resources.length) {
                    return false;
                }
                if (this.select(viewer, parent, resources[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().log(e.getStatus());
        }
        return false;
    }

    public boolean isFileExtension(IPath path) {
        int i = 0;
        while (i < this.fileExtensions.length) {
            if (path.lastSegment().endsWith(this.fileExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

