/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.hibernate.HibernateException;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.ConsoleConfigurationBasedAction;
import org.hibernate.eclipse.console.utils.LaunchHelper;

public class EditConsoleConfiguration
extends ConsoleConfigurationBasedAction {
    public static final String EDITCONSOLECONFIG_ACTIONID = "actionid.editconsoleconfig";
    ConsoleConfiguration cfg = null;

    public EditConsoleConfiguration() {
        super(HibernateConsoleMessages.EditConsoleConfiguration_edit_config);
        this.setId(EDITCONSOLECONFIG_ACTIONID);
    }

    public EditConsoleConfiguration(ConsoleConfiguration configuration) {
        this();
        this.cfg = configuration;
    }

    protected void doRun() {
        if (this.cfg == null) {
            Iterator i = this.getSelectedNonResources().iterator();
            while (i.hasNext()) {
                try {
                    Object node = i.next();
                    if (!(node instanceof ConsoleConfiguration)) continue;
                    ConsoleConfiguration config = (ConsoleConfiguration)node;
                    this.edit(config);
                }
                catch (HibernateException he) {
                    HibernateConsolePlugin.getDefault().showError(null, HibernateConsoleMessages.EditConsoleConfiguration_exception_while_edit_config, he);
                }
            }
        } else {
            try {
                this.edit(this.cfg);
            }
            catch (HibernateException he) {
                HibernateConsolePlugin.getDefault().showError(null, HibernateConsoleMessages.EditConsoleConfiguration_exception_while_edit_config, he);
            }
        }
    }

    private void edit(ConsoleConfiguration config) {
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            ILaunchConfiguration launchConfiguration = LaunchHelper.findHibernateLaunchConfig(config.getName());
            if (launchConfiguration != null) {
                DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)win.getShell(), (ILaunchConfiguration)launchConfiguration, (String)"org.eclipse.debug.ui.launchGroup.run");
                return;
            }
            String out = NLS.bind((String)HibernateConsoleMessages.EditConsoleConfiguration_could_not_find_launch_cfg, (Object)config.getName());
            HibernateConsolePlugin.getDefault().showError(win.getShell(), out, new IllegalStateException(String.valueOf(HibernateConsoleMessages.EditConsoleConfiguration_no_launch_cfg_matched) + config.getName()));
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().showError(win.getShell(), HibernateConsoleMessages.EditConsoleConfiguration_problem_adding_console_cfg, ce);
        }
    }

    protected boolean updateState(ConsoleConfiguration consoleConfiguration) {
        return true;
    }
}

