/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.hibernate.eclipse.console.AbstractQueryEditor;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.utils.EclipseImages;

public class StickResTabAction
extends Action {
    private ITextViewer fViewer;
    private ITextEditor fTextEditor;

    public StickResTabAction(ITextViewer viewer) {
        super(HibernateConsoleMessages.StickResTabAction_stick_editor, 2);
        this.fViewer = viewer;
        this.setToolTipText(HibernateConsoleMessages.StickResTabAction_stick_editor);
        AbstractQueryEditor queryEditor = this.getQueryEditor();
        boolean checked = false;
        if (queryEditor != null) {
            checked = queryEditor.getPinToOneResTab();
        }
        this.setChecked(checked);
        this.setImageDescriptor(EclipseImages.getImageDescriptor(checked ? "PINDOWN" : "PINUP"));
    }

    public StickResTabAction(ITextEditor textEditor) {
        super(HibernateConsoleMessages.StickResTabAction_stick_editor, 2);
        this.fTextEditor = textEditor;
        this.setToolTipText(HibernateConsoleMessages.StickResTabAction_stick_editor);
        AbstractQueryEditor queryEditor = this.getQueryEditor();
        boolean checked = false;
        if (queryEditor != null) {
            checked = queryEditor.getPinToOneResTab();
        }
        this.setChecked(checked);
        this.setImageDescriptor(EclipseImages.getImageDescriptor(checked ? "PINDOWN" : "PINUP"));
    }

    public void run() {
        this.setImageDescriptor(EclipseImages.getImageDescriptor(this.isChecked() ? "PINDOWN" : "PINUP"));
        AbstractQueryEditor queryEditor = this.getQueryEditor();
        if (queryEditor != null) {
            queryEditor.setPinToOneResTab(this.isChecked());
        }
    }

    public AbstractQueryEditor getQueryEditor() {
        if (this.fTextEditor instanceof AbstractQueryEditor) {
            return (AbstractQueryEditor)this.fTextEditor;
        }
        if (this.fViewer instanceof AbstractQueryEditor) {
            return (AbstractQueryEditor)this.fViewer;
        }
        return null;
    }
}

