/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.model.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.eclipse.console.model.IRevEngColumn;
import org.hibernate.eclipse.console.model.IRevEngTable;
import org.hibernate.eclipse.console.model.IReverseEngineeringDefinition;
import org.hibernate.eclipse.console.model.ITableFilter;
import org.hibernate.eclipse.console.model.ITypeMapping;
import org.hibernate.eclipse.console.model.impl.TableFilterImpl;
import org.hibernate.eclipse.console.model.impl.TypeMappingImpl;

public class ReverseEngineeringDefinitionImpl
implements IReverseEngineeringDefinition {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    List<ITableFilter> tableFilters = new ArrayList<ITableFilter>();
    private List<ITypeMapping> typeMappings = new ArrayList<ITypeMapping>();

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(property, pcl);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(property, pcl);
    }

    public ITableFilter createTableFilter() {
        return new TableFilterImpl(this);
    }

    public void addTableFilter(ITableFilter filter) {
        this.tableFilters.add(filter);
        this.firePropertyChange("tableFilterStructure", null, filter);
    }

    private void firePropertyChange(String property, Object old, Object newValue) {
        this.pcs.firePropertyChange(property, old, newValue);
    }

    protected void updateTableFilter(ITableFilter updated) {
        this.firePropertyChange("tableFilter", null, updated);
    }

    public ITableFilter[] getTableFilters() {
        return this.tableFilters.toArray(new ITableFilter[this.tableFilters.size()]);
    }

    public void removeAllTableFilters() {
        this.tableFilters.clear();
        this.firePropertyChange("tableFilterStructure", null, null);
    }

    public void removeTableFilter(ITableFilter item) {
        this.tableFilters.remove(item);
        this.firePropertyChange("tableFilterStructure", item, null);
    }

    public void moveTableFilterDown(ITableFilter item) {
        this.move(item, 1);
    }

    public void moveTableFilterUp(ITableFilter item) {
        this.move(item, -1);
    }

    private void move(Object tf, int shift) {
        List<ITableFilter> list = this.tableFilters;
        String prop = "tableFilterStructure";
        this.move(tf, shift, list, prop);
    }

    private void move(Object tf, int shift, List list, String prop) {
        int i = list.indexOf(tf);
        if (i >= 0 && i + shift < list.size() && i + shift >= 0) {
            list.remove(i);
            list.add(i + shift, tf);
        }
        this.firePropertyChange(prop, null, null);
    }

    public ITypeMapping[] getTypeMappings() {
        return this.typeMappings.toArray(new ITypeMapping[this.typeMappings.size()]);
    }

    public ITypeMapping createTypeMapping() {
        return new TypeMappingImpl();
    }

    public void addTypeMapping(ITypeMapping typeMapping) {
        this.typeMappings.add(typeMapping);
        this.firePropertyChange("typeMappingStructure", null, typeMapping);
    }

    public void moveTypeMappingDown(ITypeMapping item) {
        this.move(item, 1, this.typeMappings, "typeMappingStructure");
    }

    public void moveTypeMappingUp(ITypeMapping item) {
        this.move(item, -1, this.typeMappings, "typeMappingStructure");
    }

    public void removeAllTypeMappings() {
        this.typeMappings.clear();
        this.firePropertyChange("typeMappingStructure", null, null);
    }

    public void removeTypeMapping(ITypeMapping item) {
        this.typeMappings.remove(item);
        this.firePropertyChange("typeMappingStructure", item, null);
    }

    public IRevEngTable[] getTables() {
        return new IRevEngTable[0];
    }

    public IRevEngTable createTable() {
        return null;
    }

    public void addTable(IRevEngTable retable) {
    }

    public void removeTable(IRevEngTable retable) {
    }

    public void removeColumn(IRevEngColumn recolumn) {
    }

    public IRevEngColumn createColumn() {
        return null;
    }

    public IRevEngColumn createKeyColumn() {
        return null;
    }
}

