/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.utils.xpl;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.hibernate.eclipse.console.FileFilter;
import org.hibernate.eclipse.console.HibernateConsoleMessages;

public class DialogSelectionHelper {
    public static IPath[] chooseFileEntries(Shell shell, IPath initialSelection, IPath[] usedEntries, String title, String description, String[] fileExtensions, boolean allowMultiple, boolean allowDirectories, boolean allowFiles) {
        if (usedEntries == null) {
            throw new IllegalArgumentException(HibernateConsoleMessages.DialogSelectionHelper_used_entries_must_be_notnull);
        }
        ArrayList<Class<IFile>> clazzes = new ArrayList<Class<IFile>>();
        if (allowDirectories) {
            clazzes.add(IFolder.class);
            clazzes.add(IProject.class);
        }
        if (allowFiles) {
            clazzes.add(IFile.class);
        }
        Class[] acceptedClasses = clazzes.toArray(new Class[clazzes.size()]);
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        ArrayList<IResource> usedFiles = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource = root.findMember(usedEntries[i]);
            if (resource instanceof IFile) {
                usedFiles.add(resource);
            }
            ++i;
        }
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setAllowMultiple(allowMultiple);
        dialog.setTitle(title);
        dialog.setMessage(description);
        dialog.addFilter((ViewerFilter)new FileFilter(fileExtensions, usedFiles, true, allowDirectories));
        dialog.setInput((Object)root);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        dialog.setInitialSelection((Object)focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = elem.getFullPath();
                ++i2;
            }
            return res;
        }
        return null;
    }

    public static IPath[] chooseFolderEntries(Shell shell, IPath initialSelection, String title, String description, boolean allowMultiple) {
        ArrayList<Class> clazzes = new ArrayList<Class>();
        clazzes.add(IFolder.class);
        clazzes.add(IProject.class);
        Class[] acceptedClasses = clazzes.toArray(new Class[clazzes.size()]);
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        FolderSelectionDialog dialog = null;
        dialog = new FolderSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setAllowMultiple(allowMultiple);
        dialog.setTitle(title);
        dialog.setMessage(description);
        dialog.setInput((Object)root);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        dialog.setInitialSelection((Object)focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            int i = 0;
            while (i < res.length) {
                IResource elem = (IResource)elements[i];
                res[i] = elem.getFullPath();
                ++i;
            }
            return res;
        }
        return null;
    }
}

