/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.wizards.ConsoleConfigurationWizardPage;
import org.hibernate.eclipse.console.wizards.NewConfigurationWizardPage;
import org.hibernate.tool.hbm2x.HibernateConfigurationExporter;

public class NewConfigurationWizard
extends Wizard
implements INewWizard {
    private NewConfigurationWizardPage connectionInfoPage;
    private ISelection selection;
    private WizardNewFileCreationPage cPage;
    private ConsoleConfigurationWizardPage confPage;

    public NewConfigurationWizard() {
        this.setDefaultPageImageDescriptor(EclipseImages.getImageDescriptor("NEW_WIZARD"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.cPage = new ExtendedWizardNewFileCreationPage("Ccfgxml", (IStructuredSelection)this.selection);
        this.cPage.setTitle(HibernateConsoleMessages.NewConfigurationWizard_create_hibernate_cfg_file);
        this.cPage.setDescription(HibernateConsoleMessages.NewConfigurationWizard_create_new_hibernate_cfg_xml);
        this.cPage.setFileName("hibernate.cfg.xml");
        this.addPage((IWizardPage)this.cPage);
        this.connectionInfoPage = new NewConfigurationWizardPage(this.selection, this.cPage);
        this.addPage((IWizardPage)this.connectionInfoPage);
        this.confPage = new ConsoleConfigurationWizardPage(this.selection);
        this.addPage((IWizardPage)this.confPage);
    }

    public boolean performFinish() {
        final Properties props = new Properties();
        this.putIfNotNull(props, "hibernate.session_factory_name", this.connectionInfoPage.getSessionFactoryName());
        this.putIfNotNull(props, "hibernate.dialect", this.connectionInfoPage.getDialect());
        this.putIfNotNull(props, "hibernate.connection.driver_class", this.connectionInfoPage.getDriver());
        this.putIfNotNull(props, "hibernate.connection.url", this.connectionInfoPage.getConnectionURL());
        this.putIfNotNull(props, "hibernate.connection.username", this.connectionInfoPage.getUsername());
        this.putIfNotNull(props, "hibernate.connection.password", this.connectionInfoPage.getPassword());
        this.putIfNotNull(props, "hibernate.default_catalog", this.connectionInfoPage.getDefaultCatalog());
        this.putIfNotNull(props, "hibernate.default_schema", this.connectionInfoPage.getDefaultSchema());
        final IFile file = this.cPage.createNewFile();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewConfigurationWizard.this.createHibernateCfgXml(file, props, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            HibernateConsolePlugin.getDefault().showError(this.getShell(), HibernateConsoleMessages.NewConfigurationWizard_error, realException);
            return false;
        }
        if (this.connectionInfoPage.isCreateConsoleConfigurationEnabled()) {
            try {
                this.confPage.performFinish();
            }
            catch (CoreException ce) {
                HibernateConsolePlugin.getDefault().showError(this.getShell(), HibernateConsoleMessages.AddConfigurationAction_problem_add_console_config, ce);
            }
        }
        return true;
    }

    public boolean performCancel() {
        try {
            this.confPage.performCancel();
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().showError(this.getShell(), HibernateConsoleMessages.AddConfigurationAction_problem_add_console_config, ce);
        }
        return true;
    }

    private void putIfNotNull(Properties props, String key, String value) {
        if (value != null) {
            props.put(key, value);
        }
    }

    private void createHibernateCfgXml(final IFile file, Properties props, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(HibernateConsoleMessages.NewConfigurationWizard_creating) + file.getName(), 2);
        try {
            InputStream stream = this.openContentStream(props);
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName(HibernateConsoleMessages.NewConfigurationWizard_open_file_for_editing);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream(Properties props) {
        StringWriter stringWriter = new StringWriter();
        HibernateConfigurationExporter hce = new HibernateConfigurationExporter();
        hce.setCustomProperties(props);
        hce.setOutput((Writer)stringWriter);
        hce.start();
        try {
            return new ByteArrayInputStream(stringWriter.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uec) {
            HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.NewConfigurationWizard_problems_converting_to_utf8, uec);
            return new ByteArrayInputStream(stringWriter.toString().getBytes());
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.connectionInfoPage) {
            if (!this.connectionInfoPage.isCreateConsoleConfigurationEnabled()) {
                return null;
            }
            this.confPage.setConfigurationFilePath(this.cPage.getContainerFullPath().append(this.cPage.getFileName()));
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        if (!this.connectionInfoPage.isCreateConsoleConfigurationEnabled()) {
            return this.connectionInfoPage.isPageComplete();
        }
        return super.canFinish();
    }

    static class ExtendedWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        boolean firstTime = true;

        public ExtendedWizardNewFileCreationPage(String pageName, IStructuredSelection selection) {
            super(pageName, selection);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (this.firstTime) {
                this.validatePage();
                this.firstTime = false;
            }
        }
    }
}

