/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.hqleditor;

import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.hibernate.eclipse.console.QueryEditor;
import org.hibernate.eclipse.hqleditor.HQLCodeScanner;
import org.hibernate.eclipse.hqleditor.HQLColors;
import org.hibernate.eclipse.hqleditor.HQLCompletionProcessor;
import org.hibernate.eclipse.hqleditor.HQLFormattingStrategy;
import org.hibernate.eclipse.hqleditor.HQLTextHover;

public class HQLSourceViewerConfiguration
extends SourceViewerConfiguration {
    public static final String HQL_PARTITIONING = "__hql_partitioning";
    private HQLCompletionProcessor completionProcessor;
    private QueryEditor hqlEditor;

    public HQLSourceViewerConfiguration(QueryEditor editor) {
        this.hqlEditor = editor;
        this.completionProcessor = new HQLCompletionProcessor(editor);
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return HQL_PARTITIONING;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.completionProcessor = new HQLCompletionProcessor(this.hqlEditor);
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.completionProcessor, "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(12);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter formatter = new ContentFormatter();
        formatter.setDocumentPartitioning(HQL_PARTITIONING);
        HQLFormattingStrategy formattingStrategy = new HQLFormattingStrategy();
        formatter.setFormattingStrategy((IFormattingStrategy)formattingStrategy, "__dftl_partition_content_type");
        return formatter;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        HQLColors colorProvider = new HQLColors();
        PresentationReconciler reconciler = new PresentationReconciler();
        String docPartitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        reconciler.setDocumentPartitioning(docPartitioning);
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new HQLCodeScanner(colorProvider));
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colorProvider.getColor("hql.comment.color"))));
        reconciler.setDamager((IPresentationDamager)dr, "__hql_comment__");
        reconciler.setRepairer((IPresentationRepairer)dr, "__hql_comment__");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colorProvider.getColor("hql.quoted_literal.color"))));
        reconciler.setDamager((IPresentationDamager)dr, "__hql_quoted_literal__");
        reconciler.setRepairer((IPresentationRepairer)dr, "__hql_quoted_literal__");
        return reconciler;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new HQLTextHover();
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

