/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.jboss.tools.hibernate.ui.diagram.DiagramViewerMessages;
import org.jboss.tools.hibernate.ui.diagram.editors.DiagramViewer;
import org.jboss.tools.hibernate.ui.diagram.editors.actions.DiagramBaseAction;

public class ExportImageAction
extends DiagramBaseAction {
    public static final String ACTION_ID = "export_as_image_id";
    public static final String[] dialogFilterExtensions = new String[]{"*.png", "*.jpg", "*.bmp"};
    public static final String[] dialogFilterNames = new String[]{DiagramViewerMessages.ExportImageAction_png_format, DiagramViewerMessages.ExportImageAction_jpg_format, DiagramViewerMessages.ExportImageAction_bmp_format};
    private SaveAsDialog saveDialog = null;
    private boolean showErrDialog = true;
    public static final ImageDescriptor img = ImageDescriptor.createFromFile(DiagramViewer.class, (String)"icons/export.png");

    public ExportImageAction(DiagramViewer editor) {
        super(editor);
        this.setId(ACTION_ID);
        this.setText(DiagramViewerMessages.ExportImageAction_export_as_image);
        this.setImageDescriptor(img);
    }

    public void setSaveDialog(SaveAsDialog saveDialog) {
        this.saveDialog = saveDialog;
    }

    public void setShowErrDialog(boolean showErrDialog) {
        this.showErrDialog = showErrDialog;
    }

    public void run() {
        boolean createdSaveDialog = false;
        if (this.saveDialog == null) {
            this.saveDialog = new SaveAsDialog(this.getDiagramViewer().getSite().getWorkbenchWindow().getShell());
            createdSaveDialog = true;
        }
        this.saveDialog.setOriginalName(this.getDiagramViewer().getStoreFileName());
        this.saveDialog.open();
        IPath pathSave = this.saveDialog.getResult();
        this.saveDialog = null;
        if (pathSave == null) {
            return;
        }
        final IFigure fig = ((ScalableFreeformRootEditPart)this.getDiagramViewer().getEditPartViewer().getRootEditPart()).getLayer((Object)"Printable Layers");
        int imageTypeTmp = 0;
        String ext = pathSave.getFileExtension();
        if (ext != null) {
            if ((ext = ext.toLowerCase()).endsWith("jpg")) {
                imageTypeTmp = 4;
            } else if (ext.endsWith("png")) {
                imageTypeTmp = 5;
            } else if (ext.endsWith("gif")) {
                imageTypeTmp = 2;
            } else if (ext.endsWith("bmp")) {
                imageTypeTmp = 0;
            }
        }
        IPath pathTmp = pathSave;
        if (ext == null) {
            pathTmp = pathTmp.addFileExtension("bmp");
        }
        IPath path = pathTmp;
        final int imageType = imageTypeTmp;
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                block18: {
                    ByteArrayInputStream inputStream = null;
                    try {
                        try {
                            if (file != null) {
                                byte[] imageData = ExportImageAction.this.createImage(fig, imageType);
                                if (file.exists()) {
                                    file.delete(true, null);
                                }
                                if (!file.exists()) {
                                    inputStream = new ByteArrayInputStream(imageData);
                                    file.create((InputStream)inputStream, true, null);
                                }
                            }
                        }
                        catch (CoreException e) {
                            HibernateConsolePlugin.getDefault().logErrorMessage("ExportImageAction", (Throwable)e);
                            if (ExportImageAction.this.showErrDialog) {
                                MessageDialog.openInformation((Shell)ExportImageAction.this.getDiagramViewer().getSite().getShell(), (String)DiagramViewerMessages.ExportImageAction_error, (String)(String.valueOf(DiagramViewerMessages.ExportImageAction_failed_to_export_image) + e.getMessage()));
                            }
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        };
        try {
            new ProgressMonitorDialog(createdSaveDialog ? this.getDiagramViewer().getSite().getWorkbenchWindow().getShell() : null).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    private byte[] createImage(IFigure figure, int format) {
        ByteArrayOutputStream result;
        block14: {
            Device device = null;
            Rectangle r = figure.getBounds();
            result = new ByteArrayOutputStream();
            Image image = null;
            GC gc = null;
            SWTGraphics g = null;
            try {
                try {
                    image = new Image(device, r.width, r.height);
                    gc = new GC((Drawable)image);
                    g = new SWTGraphics(gc);
                    g.translate(r.x * -1, r.y * -1);
                    figure.paint((Graphics)g);
                    ImageLoader imageLoader = new ImageLoader();
                    imageLoader.data = new ImageData[]{image.getImageData()};
                    imageLoader.save((OutputStream)result, format);
                }
                catch (Throwable e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("ExportImageAction - save:", e);
                    if (g != null) {
                        g.dispose();
                    }
                    if (gc != null) {
                        gc.dispose();
                    }
                    if (image != null) {
                        image.dispose();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (g != null) {
                    g.dispose();
                }
                if (gc != null) {
                    gc.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
                throw throwable;
            }
            if (g != null) {
                g.dispose();
            }
            if (gc != null) {
                gc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
        return result.toByteArray();
    }
}

