/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.actions;

import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Property;
import org.jboss.tools.hibernate.ui.diagram.DiagramViewerMessages;
import org.jboss.tools.hibernate.ui.diagram.UiPlugin;
import org.jboss.tools.hibernate.ui.diagram.editors.DiagramViewer;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.SpecialRootClass;
import org.jboss.tools.hibernate.ui.view.DiagramEditorInput;

public class OpenMappingAction
extends SelectionAction {
    public static final String ACTION_ID = "org.jboss.tools.hibernate.ui.diagram.editors.actions.open.mapping";
    public static final ImageDescriptor img = UiPlugin.getImageDescriptor("icons/mapping.gif");

    public OpenMappingAction(IWorkbenchPart part) {
        super(part);
        this.setId(ACTION_ID);
        this.setText(DiagramViewerMessages.OpenMappingAction_open_mapping_file);
        this.setImageDescriptor(img);
    }

    public void run() {
        DiagramEditorInput objectEditorInput = (DiagramEditorInput)((DiagramViewer)this.getWorkbenchPart()).getEditorInput();
        ConsoleConfiguration consoleConfig = objectEditorInput.getConsoleConfig();
        DiagramViewer part = (DiagramViewer)this.getWorkbenchPart();
        Set<Shape> selectedElements = part.getSelectedElements();
        IEditorPart editorPart = null;
        Iterator<Shape> iterator = selectedElements.iterator();
        while (iterator.hasNext() && editorPart == null) {
            Shape shape = iterator.next();
            Object selection = shape.getOrmElement();
            if (selection instanceof Property && ((Property)selection).getPersistentClass() instanceof SpecialRootClass) {
                Property compositSel = (Property)selection;
                Property parentProperty = ((SpecialRootClass)compositSel.getPersistentClass()).getProperty();
                try {
                    editorPart = org.hibernate.eclipse.console.actions.OpenMappingAction.run((ConsoleConfiguration)consoleConfig, (Property)compositSel, (Property)parentProperty);
                }
                catch (CoreException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage(DiagramViewerMessages.OpenMappingAction_canot_find_or_open_mapping_file, (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage(DiagramViewerMessages.OpenMappingAction_canot_find_or_open_mapping_file, (Throwable)e);
                }
                continue;
            }
            if (selection instanceof SpecialRootClass) {
                selection = ((SpecialRootClass)((Object)selection)).getProperty();
            }
            Shape shapeParent = null;
            Object selectionParent = null;
            if (selection instanceof Column) {
                shapeParent = (Shape)shape.getParent();
                selectionParent = shapeParent.getOrmElement();
            }
            try {
                editorPart = org.hibernate.eclipse.console.actions.OpenMappingAction.run((ConsoleConfiguration)consoleConfig, (Object)selection, selectionParent);
            }
            catch (CoreException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(DiagramViewerMessages.OpenMappingAction_open_mapping_file, (Throwable)e);
            }
            catch (FileNotFoundException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(DiagramViewerMessages.OpenMappingAction_open_mapping_file, (Throwable)e);
            }
        }
    }

    protected boolean calculateEnabled() {
        DiagramViewer part = (DiagramViewer)this.getWorkbenchPart();
        return part.getSelectedElements().size() > 0;
    }
}

