/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.autolayout.impl;

import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.IDiagramInfo;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.IItemInfo;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.impl.Item;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.impl.Items;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.impl.LayoutConstants;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.impl.TransitionArranger;

public class AutoLayoutImpl {
    LayoutConstants constants = new LayoutConstants();
    protected Items items = new Items();

    public AutoLayoutImpl() {
        this.items.setConstants(this.constants);
    }

    public void setGridStep(int gridStep) {
        this.constants.update(gridStep);
    }

    public void setItems(Items items) {
        this.items = items;
        items.setConstants(this.constants);
    }

    public void setOverride(boolean b) {
        this.items.setOverride(b);
    }

    public void setProcess(IDiagramInfo process) {
        this.items.setProcess(process);
        this.apply();
        if (this.items.override) {
            TransitionArranger a = new TransitionArranger();
            a.setItems(this.items.items);
            a.execute();
        }
    }

    private void apply() {
        Item[] is = this.items.items;
        int[] yDeltas = this.items.groups.yDeltas;
        int i = 0;
        while (i < is.length) {
            if (!is[i].isSet()) {
                IItemInfo itemInfo = is[i].getItemInfo();
                if (!is[i].isVisible()) {
                    itemInfo.setShape(new int[4]);
                } else {
                    int x = is[i].ix * this.constants.deltaX + this.constants.indentX;
                    int y = is[i].iy * this.constants.deltaY + this.constants.indentY;
                    if (is[i].ix % 2 == 1) {
                        y += 16;
                    }
                    int[] nArray = new int[4];
                    nArray[0] = x += is[i].group.xDeltas[is[i].ix] * this.constants.incX;
                    nArray[1] = y += yDeltas[is[i].iy] * this.constants.incY + is[i].yIndent;
                    itemInfo.setShape(nArray);
                }
            }
            ++i;
        }
    }
}

