/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.model;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.diagram.editors.model.BaseElement;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;

public class Connection
extends BaseElement {
    private static IPropertyDescriptor[] descriptors_connection_class_mapping = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"source", "source"), new TextPropertyDescriptor((Object)"target", "target"), new TextPropertyDescriptor((Object)"type", "type"), new TextPropertyDescriptor((Object)"className", "className"), new TextPropertyDescriptor((Object)"tableName", "tableName")};
    private static IPropertyDescriptor[] descriptors_connection_property_mapping = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"source", "source"), new TextPropertyDescriptor((Object)"target", "target"), new TextPropertyDescriptor((Object)"type", "type"), new TextPropertyDescriptor((Object)"className", "className"), new TextPropertyDescriptor((Object)"tableName", "tableName"), new TextPropertyDescriptor((Object)"classField", "classField"), new TextPropertyDescriptor((Object)"tableField", "tableField"), new TextPropertyDescriptor((Object)"classFieldType", "classFieldType"), new TextPropertyDescriptor((Object)"tableFieldType", "tableFieldType")};
    private static IPropertyDescriptor[] descriptors_connection_association = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"source", "source"), new TextPropertyDescriptor((Object)"target", "target"), new TextPropertyDescriptor((Object)"type", "type"), new TextPropertyDescriptor((Object)"associationType", "associationType"), new TextPropertyDescriptor((Object)"sourceClassField", "sourceClassField"), new TextPropertyDescriptor((Object)"sourceClassFieldType", "sourceClassFieldType")};
    private static IPropertyDescriptor[] descriptors_connection_foreign_key_constraint = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"source", "source"), new TextPropertyDescriptor((Object)"target", "target"), new TextPropertyDescriptor((Object)"type", "type"), new TextPropertyDescriptor((Object)"sourceTableField", "sourceTableField"), new TextPropertyDescriptor((Object)"targetTableField", "targetTableField"), new TextPropertyDescriptor((Object)"sourceTableFieldType", "sourceTableFieldType"), new TextPropertyDescriptor((Object)"targetTableFieldType", "targetTableFieldType")};
    private static final String PROPERTY_SOURCE = "source";
    private static final String PROPERTY_TARGET = "target";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_CLASS_NAME = "className";
    private static final String PROPERTY_TABLE_NAME = "tableName";
    private static final String PROPERTY_CLASS_FIELD = "classField";
    private static final String PROPERTY_TABLE_FIELD = "tableField";
    private static final String PROPERTY_CLASS_FIELD_TYPE = "classFieldType";
    private static final String PROPERTY_TABLE_FIELD_TYPE = "tableFieldType";
    private static final String PROPERTY_ASSOCIATION_TYPE = "associationType";
    private static final String PROPERTY_SOURCE_CLASS_FIELD = "sourceClassField";
    private static final String PROPERTY_SOURCE_CLASS_FIELD_TYPE = "sourceClassFieldType";
    private static final String PROPERTY_SOURCE_TABLE_FIELD = "sourceTableField";
    private static final String PROPERTY_TARGET_TABLE_FIELD = "targetTableField";
    private static final String PROPERTY_SOURCE_TABLE_FIELD_TYPE = "sourceTableFieldType";
    private static final String PROPERTY_TARGET_TABLE_FIELD_TYPE = "targetTableFieldType";
    protected Shape source;
    protected Shape target;
    protected boolean inUpdateVisibleValue = false;

    public Connection(Shape s, Shape newTarget) {
        if (s == null || newTarget == null || s == newTarget) {
            throw new IllegalArgumentException();
        }
        this.source = s;
        this.target = newTarget;
        this.source.addConnection(this);
        this.target.addConnection(this);
    }

    public Shape getSource() {
        return this.source;
    }

    public Shape getTarget() {
        return this.target;
    }

    public ConnectionType getConnectionType() {
        if (this.source instanceof OrmShape && this.target instanceof OrmShape) {
            if (this.source.getOrmElement() instanceof Table && this.target.getOrmElement() instanceof Table) {
                return ConnectionType.ForeignKeyConstraint;
            }
            boolean bClassMapping = true;
            if (!(this.source.getOrmElement() instanceof RootClass) && !(this.source.getOrmElement() instanceof Table)) {
                bClassMapping = false;
            }
            if (!(this.target.getOrmElement() instanceof RootClass) && !(this.target.getOrmElement() instanceof Table)) {
                bClassMapping = false;
            }
            if (bClassMapping) {
                return ConnectionType.ClassMapping;
            }
        }
        if (this.source.getOrmElement() instanceof Table && this.target.getOrmElement() instanceof Table || this.source.getOrmElement() instanceof Table && this.target.getOrmElement() instanceof Column || this.source.getOrmElement() instanceof Column && this.target.getOrmElement() instanceof Table || this.source.getOrmElement() instanceof Column && this.target.getOrmElement() instanceof Column) {
            return ConnectionType.ForeignKeyConstraint;
        }
        if (this.source instanceof OrmShape ^ this.target instanceof OrmShape) {
            boolean bAssociation = true;
            if (!(!(this.source instanceof OrmShape) && this.source.getOrmElement() instanceof Property || !(this.target instanceof OrmShape) && this.target.getOrmElement() instanceof Property)) {
                bAssociation = false;
            }
            if (bAssociation) {
                return ConnectionType.Association;
            }
        }
        return ConnectionType.PropertyMapping;
    }

    public boolean addChild(Shape item) {
        return false;
    }

    public void setSelected(boolean selected) {
        this.source.setSelected(selected);
        this.target.setSelected(selected);
        super.setSelected(selected);
    }

    public void updateVisibleValue(boolean initState) {
        if (this.inUpdateVisibleValue) {
            return;
        }
        this.inUpdateVisibleValue = true;
        boolean visible = initState;
        visible = visible && this.source.isVisible();
        visible = visible && this.target.isVisible();
        this.setVisible(visible);
        super.updateVisibleValue(this.visible);
        this.inUpdateVisibleValue = false;
    }

    public BaseElement getParent() {
        return null;
    }

    public void refresh() {
        this.updateVisibleValue(this.isVisible());
        super.refresh();
    }

    public String getKey() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ConnectionType connectType = this.getConnectionType();
        if (connectType == ConnectionType.ClassMapping) {
            return descriptors_connection_class_mapping;
        }
        if (connectType == ConnectionType.PropertyMapping) {
            return descriptors_connection_property_mapping;
        }
        if (connectType == ConnectionType.Association) {
            return descriptors_connection_association;
        }
        if (connectType == ConnectionType.ForeignKeyConstraint) {
            return descriptors_connection_foreign_key_constraint;
        }
        return super.getPropertyDescriptors();
    }

    public Object getPropertyValue(Object propertyId) {
        Object res = null;
        ConnectionType connectType = this.getConnectionType();
        if (PROPERTY_SOURCE.equals(propertyId)) {
            res = this.source;
        } else if (PROPERTY_TARGET.equals(propertyId)) {
            res = this.target;
        } else if (PROPERTY_TYPE.equals(propertyId)) {
            if (connectType == ConnectionType.ClassMapping) {
                res = "ClassMapping";
            } else if (connectType == ConnectionType.PropertyMapping) {
                res = "PropertyMapping";
            } else if (connectType == ConnectionType.Association) {
                res = "Association";
            } else if (connectType == ConnectionType.ForeignKeyConstraint) {
                res = "ForeignKeyConstraint";
            }
        } else if (PROPERTY_CLASS_NAME.equals(propertyId)) {
            if (connectType == ConnectionType.ClassMapping) {
                if (this.source.getOrmElement() instanceof RootClass) {
                    res = ((RootClass)this.source.getOrmElement()).getClassName();
                } else if (this.target.getOrmElement() instanceof RootClass) {
                    res = ((RootClass)this.target.getOrmElement()).getClassName();
                }
            } else if (connectType == ConnectionType.PropertyMapping) {
                if (((Shape)this.source.getParent()).getOrmElement() instanceof RootClass) {
                    res = ((RootClass)((Shape)this.source.getParent()).getOrmElement()).getClassName();
                } else if (((Shape)this.target.getParent()).getOrmElement() instanceof RootClass) {
                    res = ((RootClass)((Shape)this.target.getParent()).getOrmElement()).getClassName();
                }
            }
        } else if (PROPERTY_TABLE_NAME.equals(propertyId)) {
            if (connectType == ConnectionType.ClassMapping) {
                if (this.source.getOrmElement() instanceof Table) {
                    res = ((Table)this.source.getOrmElement()).getName();
                } else if (this.target.getOrmElement() instanceof Table) {
                    res = ((Table)this.target.getOrmElement()).getName();
                }
            } else if (connectType == ConnectionType.PropertyMapping) {
                if (((Shape)this.source.getParent()).getOrmElement() instanceof Table) {
                    res = ((Table)((Shape)this.source.getParent()).getOrmElement()).getName();
                } else if (((Shape)this.target.getParent()).getOrmElement() instanceof Table) {
                    res = ((Table)((Shape)this.target.getParent()).getOrmElement()).getName();
                }
            }
        } else if (PROPERTY_CLASS_FIELD.equals(propertyId)) {
            if (this.source.getOrmElement() instanceof Property) {
                res = ((Property)this.source.getOrmElement()).getName();
            } else if (this.target.getOrmElement() instanceof Property) {
                res = ((Property)this.target.getOrmElement()).getName();
            }
        } else if (PROPERTY_TABLE_FIELD.equals(propertyId)) {
            if (this.source.getOrmElement() instanceof Column) {
                res = ((Column)this.source.getOrmElement()).getName();
            } else if (this.target.getOrmElement() instanceof Column) {
                res = ((Column)this.target.getOrmElement()).getName();
            }
        } else if (PROPERTY_CLASS_FIELD_TYPE.equals(propertyId)) {
            if (this.source.getOrmElement() instanceof Property) {
                res = ((Property)this.source.getOrmElement()).getType().toString();
            } else if (this.target.getOrmElement() instanceof Property) {
                res = ((Property)this.target.getOrmElement()).getType().toString();
            }
        } else if (PROPERTY_TABLE_FIELD_TYPE.equals(propertyId)) {
            if (this.source.getOrmElement() instanceof Column) {
                res = ((Column)this.source.getOrmElement()).getSqlType();
            } else if (this.target.getOrmElement() instanceof Column) {
                res = ((Column)this.target.getOrmElement()).getSqlType();
            }
        } else if (PROPERTY_ASSOCIATION_TYPE.equals(propertyId)) {
            if (this.source.getOrmElement() instanceof Property) {
                res = ((Property)this.source.getOrmElement()).getValue().toString();
            } else if (this.target.getOrmElement() instanceof Property) {
                res = ((Property)this.target.getOrmElement()).getValue().toString();
            }
            if (res instanceof OneToOne) {
                res = "OneToOne";
            } else if (res instanceof OneToMany) {
                res = "OneToMany";
            } else if (res instanceof ManyToOne) {
                res = "ManyToOne";
            }
        } else if (PROPERTY_SOURCE_CLASS_FIELD.equals(propertyId)) {
            if (this.source.getOrmElement() instanceof Property) {
                res = ((Property)this.source.getOrmElement()).getName();
            }
        } else if (PROPERTY_SOURCE_CLASS_FIELD_TYPE.equals(propertyId)) {
            if (this.source.getOrmElement() instanceof Property) {
                res = ((Property)this.source.getOrmElement()).getType().toString();
            }
        } else if (PROPERTY_SOURCE_TABLE_FIELD.equals(propertyId)) {
            if (this.source.getOrmElement() instanceof Column) {
                res = ((Column)this.source.getOrmElement()).getName();
            }
        } else if (PROPERTY_TARGET_TABLE_FIELD.equals(propertyId)) {
            if (this.target.getOrmElement() instanceof Column) {
                res = ((Column)this.target.getOrmElement()).getName();
            }
        } else if (PROPERTY_SOURCE_TABLE_FIELD_TYPE.equals(propertyId)) {
            if (this.source.getOrmElement() instanceof Column) {
                res = ((Column)this.source.getOrmElement()).getSqlType();
            }
        } else if (PROPERTY_TARGET_TABLE_FIELD_TYPE.equals(propertyId) && this.target.getOrmElement() instanceof Column) {
            res = ((Column)this.target.getOrmElement()).getSqlType();
        }
        if (res == null) {
            res = super.getPropertyValue(propertyId);
        }
        return this.toEmptyStr(res);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionType {
        ClassMapping,
        PropertyMapping,
        Association,
        ForeignKeyConstraint;

    }
}

