/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.jboss.tools.hibernate.ui.diagram.editors.model.BaseElement;
import org.jboss.tools.hibernate.ui.diagram.editors.model.ComponentShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Connection;
import org.jboss.tools.hibernate.ui.diagram.editors.model.ExpandableShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.SpecialOrmShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.SpecialRootClass;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementsFactory {
    private final Configuration config;
    private final HashMap<String, OrmShape> elements;
    private final ArrayList<Connection> connections;

    public ElementsFactory(Configuration config, HashMap<String, OrmShape> elements, ArrayList<Connection> connections) {
        this.config = config;
        this.elements = elements;
        this.connections = connections;
    }

    public void createForeingKeyConnections() {
        HashMap elementsTmp = (HashMap)this.elements.clone();
        for (OrmShape shape : elementsTmp.values()) {
            Object ormElement = shape.getOrmElement();
            if (!(ormElement instanceof Table)) continue;
            Table databaseTable = (Table)ormElement;
            Iterator itFK = databaseTable.getForeignKeyIterator();
            while (itFK.hasNext()) {
                ForeignKey fk = (ForeignKey)itFK.next();
                Table referencedTable = fk.getReferencedTable();
                OrmShape referencedShape = this.getOrCreateDatabaseTable(referencedTable);
                Iterator itColumns = fk.columnIterator();
                while (itColumns.hasNext()) {
                    Column col = (Column)itColumns.next();
                    Shape shapeColumn = shape.getChild(col);
                    Iterator itReferencedColumns = null;
                    itReferencedColumns = fk.isReferenceToPrimaryKey() ? referencedTable.getPrimaryKey().columnIterator() : fk.getReferencedColumns().iterator();
                    while (itReferencedColumns != null && itReferencedColumns.hasNext()) {
                        Column colReferenced = (Column)itReferencedColumns.next();
                        Shape shapeReferencedColumn = referencedShape.getChild(colReferenced);
                        if (!this.shouldCreateConnection(shapeColumn, shapeReferencedColumn)) continue;
                        this.connections.add(new Connection(shapeColumn, shapeReferencedColumn));
                    }
                }
            }
        }
    }

    public void createChildren(BaseElement element) {
        if (element.getClass().equals(ExpandableShape.class)) {
            this.processExpand((ExpandableShape)element);
        } else if (element.getClass().equals(ComponentShape.class)) {
            this.refreshComponentReferences((ComponentShape)element);
        }
        for (Shape shape : element.getChildrenList()) {
            this.createChildren(shape);
        }
    }

    protected void processExpand(ExpandableShape shape) {
        Object element = shape.getOrmElement();
        if (!(element instanceof Property)) {
            return;
        }
        OrmShape s = null;
        Property property = (Property)element;
        if (!property.isComposite()) {
            Type type = ((Property)element).getType();
            if (type.isEntityType()) {
                PersistentClass clazz;
                EntityType et = (EntityType)type;
                PersistentClass persistentClass = clazz = this.config != null ? this.config.getClassMapping(et.getAssociatedEntityName()) : null;
                if (clazz instanceof RootClass) {
                    RootClass rootClass = (RootClass)clazz;
                    s = this.getOrCreatePersistentClass((PersistentClass)rootClass, null);
                    if (this.shouldCreateConnection(shape, s)) {
                        this.connections.add(new Connection(shape, s));
                    }
                } else if (clazz instanceof Subclass) {
                    s = this.getOrCreatePersistentClass((PersistentClass)((Subclass)clazz).getRootClass(), null);
                }
            }
        } else {
            s = this.getOrCreatePersistentClass((PersistentClass)new SpecialRootClass(property), null);
            if (this.shouldCreateConnection(shape, s)) {
                this.connections.add(new Connection(shape, s));
            }
            this.createConnections(s, this.getOrCreateDatabaseTable(property.getValue().getTable()));
        }
    }

    protected void refreshComponentReferences(ComponentShape componentShape) {
        block12: {
            OrmShape childShape;
            Shape csChild1;
            Shape csChild0;
            Collection collection;
            block13: {
                Property property;
                block11: {
                    SimpleValue value;
                    OrmShape tableShape;
                    property = (Property)componentShape.getOrmElement();
                    if (!(property.getValue() instanceof Collection)) {
                        return;
                    }
                    collection = (Collection)property.getValue();
                    Value component = collection.getElement();
                    csChild0 = null;
                    csChild1 = null;
                    Iterator<Shape> tmp = componentShape.getChildrenIterator();
                    if (tmp.hasNext()) {
                        csChild0 = tmp.next();
                    }
                    if (tmp.hasNext()) {
                        csChild1 = tmp.next();
                    }
                    childShape = null;
                    if (!(component instanceof Component)) break block11;
                    childShape = this.elements.get(((Component)component).getComponentClassName());
                    if (childShape == null) {
                        childShape = this.getOrCreateComponentClass(property);
                    }
                    if ((tableShape = this.getOrCreateDatabaseTable((value = (SimpleValue)csChild0.getOrmElement()).getTable())) != null) {
                        Iterator it = value.getColumnIterator();
                        while (it.hasNext()) {
                            Column col;
                            Shape shape;
                            Object el = it.next();
                            if (!(el instanceof Column) || !this.shouldCreateConnection(csChild0, shape = tableShape.getChild(col = (Column)el))) continue;
                            this.connections.add(new Connection(csChild0, shape));
                        }
                    }
                    if (!this.shouldCreateConnection(csChild1, childShape)) break block12;
                    this.connections.add(new Connection(csChild1, childShape));
                    break block12;
                }
                if (!collection.isOneToMany()) break block13;
                childShape = this.getOrCreateAssociationClass(property);
                if (childShape == null) break block12;
                if (this.shouldCreateConnection(csChild1, childShape)) {
                    this.connections.add(new Connection(csChild1, childShape));
                }
                OrmShape keyTableShape = this.getOrCreateDatabaseTable(collection.getKey().getTable());
                Iterator it = collection.getKey().getColumnIterator();
                while (it.hasNext()) {
                    Column col;
                    Shape shape;
                    Object el = it.next();
                    if (!(el instanceof Column) || !this.shouldCreateConnection(csChild0, shape = keyTableShape.getChild(col = (Column)el))) continue;
                    this.connections.add(new Connection(csChild0, shape));
                }
                break block12;
            }
            childShape = this.getOrCreateDatabaseTable(collection.getCollectionTable());
            if (childShape != null) {
                Column col;
                Shape shape;
                Object el;
                Iterator it = ((DependantValue)csChild0.getOrmElement()).getColumnIterator();
                while (it.hasNext()) {
                    el = it.next();
                    if (!(el instanceof Column) || !this.shouldCreateConnection(csChild0, shape = childShape.getChild(col = (Column)el))) continue;
                    this.connections.add(new Connection(csChild0, shape));
                }
                it = ((SimpleValue)csChild1.getOrmElement()).getColumnIterator();
                while (it.hasNext()) {
                    el = it.next();
                    if (!(el instanceof Column) || !this.shouldCreateConnection(csChild1, shape = childShape.getChild(col = (Column)el))) continue;
                    this.connections.add(new Connection(csChild1, shape));
                }
            }
        }
    }

    protected OrmShape getOrCreateDatabaseTable(Table databaseTable) {
        OrmShape tableShape = null;
        if (databaseTable != null && (tableShape = this.getShape(databaseTable)) == null) {
            tableShape = this.createShape(databaseTable);
            if (this.config != null) {
                Iterator iterator = this.config.getClassMappings();
                while (iterator.hasNext()) {
                    RootClass cls;
                    Object clazz = iterator.next();
                    if (!(clazz instanceof RootClass) || !databaseTable.equals((cls = (RootClass)clazz).getTable())) continue;
                    this.getOrCreatePersistentClass((PersistentClass)cls, null);
                }
            }
        }
        return tableShape;
    }

    protected OrmShape getOrCreatePersistentClass(PersistentClass persistentClass, Table componentClassDatabaseTable) {
        OrmShape componentClassShape;
        Component identifier;
        OrmShape classShape = null;
        if (persistentClass == null) {
            return classShape;
        }
        OrmShape shape = null;
        classShape = this.getShape(persistentClass.getEntityName());
        if (classShape == null) {
            classShape = this.createShape(persistentClass);
        }
        if (componentClassDatabaseTable == null && persistentClass.getTable() != null) {
            componentClassDatabaseTable = persistentClass.getTable();
        }
        if (componentClassDatabaseTable != null) {
            shape = this.getShape(componentClassDatabaseTable);
            if (shape == null) {
                shape = this.getOrCreateDatabaseTable(componentClassDatabaseTable);
            }
            this.createConnections(classShape, shape);
            if (this.shouldCreateConnection(classShape, shape)) {
                this.connections.add(new Connection(classShape, shape));
            }
        }
        RootClass rc = (RootClass)persistentClass;
        Iterator iter = rc.getSubclassIterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof Subclass)) continue;
            Subclass subclass = (Subclass)element;
            OrmShape subclassShape = this.getShape(subclass);
            if (subclassShape == null) {
                subclassShape = this.createShape(subclass);
            }
            if (((Subclass)element).isJoinedSubclass()) {
                Table jcTable = ((Subclass)element).getTable();
                OrmShape jcTableShape = this.getOrCreateDatabaseTable(jcTable);
                this.createConnections(subclassShape, jcTableShape);
                if (this.shouldCreateConnection(subclassShape, jcTableShape)) {
                    this.connections.add(new Connection(subclassShape, jcTableShape));
                }
            } else {
                this.createConnections(subclassShape, shape);
                if (this.shouldCreateConnection(subclassShape, shape)) {
                    this.connections.add(new Connection(subclassShape, shape));
                }
            }
            OrmShape ownerTableShape = this.getOrCreateDatabaseTable(((Subclass)element).getRootTable());
            this.createConnections(subclassShape, ownerTableShape);
            Iterator joinIterator = subclass.getJoinIterator();
            while (joinIterator.hasNext()) {
                Join join = (Join)joinIterator.next();
                Iterator iterator = join.getPropertyIterator();
                while (iterator.hasNext()) {
                    Property property = (Property)iterator.next();
                    OrmShape tableShape = this.getOrCreateDatabaseTable(property.getValue().getTable());
                    this.createConnections(subclassShape, tableShape);
                }
            }
        }
        if (persistentClass.getIdentifier() instanceof Component && (identifier = (Component)persistentClass.getIdentifier()).getComponentClassName() != null && !identifier.getComponentClassName().equals(identifier.getOwner().getEntityName()) && (componentClassShape = this.elements.get(identifier.getComponentClassName())) == null && persistentClass instanceof RootClass) {
            componentClassShape = this.getOrCreateComponentClass(((RootClass)persistentClass).getIdentifierProperty());
            Shape idPropertyShape = classShape.getChild(persistentClass.getIdentifierProperty());
            if (this.shouldCreateConnection(idPropertyShape, componentClassShape)) {
                this.connections.add(new Connection(idPropertyShape, componentClassShape));
            }
            OrmShape tableShape = this.getOrCreateDatabaseTable(identifier.getTable());
            if (componentClassShape != null) {
                this.createConnections(componentClassShape, tableShape);
            }
        }
        Iterator joinIterator = persistentClass.getJoinIterator();
        while (joinIterator.hasNext()) {
            Join join = (Join)joinIterator.next();
            Iterator iterator = join.getPropertyIterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                OrmShape tableShape = this.getOrCreateDatabaseTable(property.getValue().getTable());
                this.createConnections(classShape, tableShape);
            }
        }
        return classShape;
    }

    protected OrmShape getOrCreateComponentClass(Property property) {
        OrmShape classShape = null;
        if (property == null) {
            return classShape;
        }
        if (property.getValue() instanceof Collection) {
            Component component = (Component)((Collection)property.getValue()).getElement();
            if (component != null) {
                OrmShape parentClassShape;
                Shape parentShape;
                classShape = this.createShape(property);
                OrmShape tableShape = this.elements.get(Utils.getTableName(component.getTable()));
                if (tableShape == null) {
                    tableShape = this.getOrCreateDatabaseTable(component.getTable());
                }
                this.createConnections(classShape, tableShape);
                if (this.shouldCreateConnection(classShape, tableShape)) {
                    this.connections.add(new Connection(classShape, tableShape));
                }
                if ((parentShape = ((SpecialOrmShape)classShape).getParentShape()) != null && this.shouldCreateConnection(parentShape, parentClassShape = this.elements.get(Utils.getName(((Property)parentShape.getOrmElement()).getPersistentClass().getEntityName())))) {
                    this.connections.add(new Connection(parentShape, parentClassShape));
                }
            }
        } else if (property.getValue() instanceof Component && (classShape = this.elements.get(((Component)property.getValue()).getComponentClassName())) == null) {
            classShape = this.createShape(property);
        }
        return classShape;
    }

    protected OrmShape getOrCreateAssociationClass(Property property) {
        OrmShape classShape = null;
        OneToMany component = (OneToMany)((Collection)property.getValue()).getElement();
        if (component == null) {
            return classShape;
        }
        if (component.getAssociatedClass() instanceof RootClass) {
            OrmShape tableShape;
            classShape = this.getOrCreatePersistentClass(component.getAssociatedClass(), null);
            if (classShape == null) {
                classShape = this.createShape(component.getAssociatedClass());
            }
            if ((tableShape = this.elements.get(Utils.getTableName(component.getAssociatedClass().getTable()))) == null) {
                tableShape = this.getOrCreateDatabaseTable(component.getAssociatedClass().getTable());
            }
            this.createConnections(classShape, tableShape);
            if (this.shouldCreateConnection(classShape, tableShape)) {
                this.connections.add(new Connection(classShape, tableShape));
            }
        }
        return classShape;
    }

    protected OrmShape createShape(Object ormElement) {
        OrmShape ormShape = null;
        if (ormElement instanceof Property) {
            SpecialRootClass specialRootClass = new SpecialRootClass((Property)ormElement);
            String key = Utils.getName(specialRootClass.getEntityName());
            ormShape = this.elements.get(key);
            if (ormShape == null) {
                ormShape = new SpecialOrmShape(specialRootClass);
                this.elements.put(key, ormShape);
            }
        } else {
            String key = Utils.getName(ormElement);
            ormShape = this.elements.get(key);
            if (ormShape == null) {
                ormShape = new OrmShape(ormElement);
                this.elements.put(key, ormShape);
            }
        }
        return ormShape;
    }

    private boolean createConnections(ExpandableShape persistentClass, ExpandableShape dbTable) {
        boolean res = false;
        if (persistentClass == null || dbTable == null) {
            return res;
        }
        Property parentProperty = null;
        if (persistentClass.getOrmElement() instanceof SpecialRootClass) {
            parentProperty = ((SpecialRootClass)((Object)persistentClass.getOrmElement())).getParentProperty();
        }
        Iterator<Shape> itFields = persistentClass.getChildrenIterator();
        HashSet<Shape> processed = new HashSet<Shape>();
        while (itFields.hasNext()) {
            Shape shape = itFields.next();
            Object element = shape.getOrmElement();
            if (!(element instanceof Property) || parentProperty == element) continue;
            Value value = ((Property)element).getValue();
            Iterator iterator = value.getColumnIterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!(o instanceof Column)) continue;
                Column dbColumn = (Column)o;
                Iterator<Shape> itColumns = dbTable.getChildrenIterator();
                while (itColumns.hasNext()) {
                    Shape shapeCol = itColumns.next();
                    if (processed.contains(shapeCol) || shape.equals(shapeCol)) continue;
                    Object ormElement = shapeCol.getOrmElement();
                    String name2 = "";
                    if (ormElement instanceof Column) {
                        Column dbColumn2 = (Column)ormElement;
                        name2 = dbColumn2.getName();
                    } else if (ormElement instanceof Property) {
                        Property property2 = (Property)ormElement;
                        name2 = property2.getName();
                    }
                    if (!dbColumn.getName().equals(name2)) continue;
                    if (this.shouldCreateConnection(shape, shapeCol)) {
                        this.connections.add(new Connection(shape, shapeCol));
                        res = true;
                    }
                    processed.add(shapeCol);
                }
            }
        }
        return res;
    }

    public OrmShape getShape(Object ormElement) {
        OrmShape ormShape = null;
        if (ormElement instanceof Property) {
            SpecialRootClass specialRootClass = new SpecialRootClass((Property)ormElement);
            ormShape = this.elements.get(Utils.getName(specialRootClass.getEntityName()));
        } else {
            ormShape = this.elements.get(Utils.getName(ormElement));
        }
        return ormShape;
    }

    private boolean isConnectionExist(Shape source, Shape target) {
        return Utils.isConnectionExist(source, target);
    }

    private boolean shouldCreateConnection(Shape source, Shape target) {
        if (source == null || target == null || source == target) {
            return false;
        }
        return !this.isConnectionExist(source, target);
    }
}

