/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.model;

import java.util.Iterator;
import org.hibernate.MappingException;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.type.Type;
import org.jboss.tools.hibernate.ui.diagram.editors.model.ComponentShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.ExpandableShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.SpecialRootClass;

public class SpecialOrmShape
extends OrmShape {
    private Shape parentShape;

    public SpecialOrmShape(SpecialRootClass ioe) {
        super((Object)ioe);
    }

    protected void initModel() {
        SpecialRootClass src;
        RootClass rootClass = (RootClass)this.getOrmElement();
        Property identifierProperty = rootClass.getIdentifierProperty();
        if (identifierProperty != null) {
            this.addChild(new Shape(identifierProperty));
        }
        if ((src = (SpecialRootClass)((Object)this.getOrmElement())).getParentProperty() != null) {
            Shape bodyOrmShape = new Shape(src.getParentProperty());
            this.addChild(bodyOrmShape);
            this.parentShape = bodyOrmShape;
        }
        Iterator iterator = rootClass.getPropertyIterator();
        while (iterator.hasNext()) {
            Property field = (Property)iterator.next();
            Type type = null;
            if (this.getOrmDiagram() != null) {
                ConsoleConfiguration cfg = this.getOrmDiagram().getConsoleConfig();
                final Property fField = field;
                type = (Type)cfg.execute(new ExecutionContext.Command(){

                    public Object execute() {
                        return fField.getValue().getType();
                    }
                });
            } else {
                try {
                    type = field.getValue().getType();
                }
                catch (MappingException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("MappingException: ", (Throwable)e);
                }
            }
            Shape bodyOrmShape = null;
            bodyOrmShape = type != null && type.isEntityType() ? new ExpandableShape(field) : (type != null && type.isCollectionType() ? new ComponentShape(field) : new Shape(field));
            this.addChild(bodyOrmShape);
        }
    }

    protected Shape getParentShape() {
        return this.parentShape;
    }
}

