/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.parts;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.diagram.editors.figures.TitleFigure;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.ColorConstants;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.ExpandableShapeEditPart;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.ResourceManager;

public class OrmShapeEditPart
extends ExpandableShapeEditPart {
    public OrmShape getModelOrmShape() {
        return (OrmShape)this.getModel();
    }

    public TitleFigure getTitleFigure() {
        if (this.getFigure() instanceof TitleFigure) {
            return (TitleFigure)this.getFigure();
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        this.getTitleFigure().refresh();
        this.refresh();
    }

    protected IFigure createFigure() {
        Object element = this.getElement();
        TitleFigure figure = new TitleFigure();
        figure.setLayoutManager((LayoutManager)new ToolbarLayout());
        String text = this.getOrmDiagram().getLabelProvider().getText(element);
        figure.createTitle(text, this.getOrmDiagram().getLabelProvider().getImage(element), this.getColor(), this.getOrmDiagram().getFontHeight());
        figure.setBackgroundColor(this.getBackgroundColor());
        return figure;
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            OrmShape shape = this.getModelOrmShape();
            if (shape.isExpanded()) {
                shape.collapse();
            } else {
                shape.expand();
            }
        } else {
            super.performRequest(req);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("location".equals(prop)) {
            this.refreshVisuals();
            this.getOrmDiagram().setDirty(true);
        } else if ("expanded".equals(prop)) {
            boolean expanded = (Boolean)evt.getNewValue();
            if (this.getTitleFigure() != null) {
                this.getTitleFigure().setExpanded(expanded);
            }
            this.getOrmDiagram().updateDirty(evt.getNewValue() != evt.getOldValue());
        } else if ("refresh".equals(prop)) {
            if (this.getTitleFigure() != null) {
                this.getTitleFigure().setExpanded(this.getModelExpandableShape().isExpanded());
            }
            super.propertyChange(evt);
        } else {
            super.propertyChange(evt);
        }
        this.refresh();
    }

    protected void refreshVisuals() {
        Rectangle bounds = new Rectangle(this.getModelOrmShape().getLocation(), this.getFigure().getSize());
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
    }

    protected Color getBackgroundColor() {
        Object element = this.getElement();
        if (element instanceof PersistentClass || element instanceof Component) {
            return ResourceManager.getInstance().getColor(new RGB(0, 0, 0));
        }
        if (element instanceof Table || element instanceof Property) {
            return ResourceManager.getInstance().getColor(new RGB(Integer.parseInt(ColorConstants.Colors_DatabaseColumnR), Integer.parseInt(ColorConstants.Colors_DatabaseColumnG), Integer.parseInt(ColorConstants.Colors_DatabaseColumnB)));
        }
        if (element instanceof String) {
            return ResourceManager.getInstance().getColor(new RGB(0, 0, 0));
        }
        throw new IllegalArgumentException();
    }
}

