/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.view;

import java.util.ArrayList;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.mapping.RootClass;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmDiagram;
import org.jboss.tools.hibernate.ui.view.DiagramEditorStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramEditorInput
implements IEditorInput,
IStorageEditorInput,
IPersistableElement {
    protected OrmDiagram ormDiagram = null;
    private DiagramEditorStorage storage = new DiagramEditorStorage();

    public DiagramEditorInput() {
        ArrayList<RootClass> roots = new ArrayList<RootClass>();
        this.createOrmDiagram("", roots);
    }

    public DiagramEditorInput(FileEditorInput fei) {
        ArrayList<RootClass> roots = new ArrayList<RootClass>();
        this.createOrmDiagram("", roots);
        this.ormDiagram.loadFromFile(fei.getPath(), true);
        if (this.ormDiagram.getConsoleConfig() != null) {
            this.ormDiagram.recreateChildren();
            this.ormDiagram.loadFromFile(fei.getPath(), true);
            this.ormDiagram.refresh();
        }
        this.ormDiagram.setDirty(false);
    }

    public DiagramEditorInput(String configName, RootClass rc) {
        ArrayList<RootClass> roots = new ArrayList<RootClass>();
        roots.add(rc);
        this.createOrmDiagram(configName, roots);
    }

    public DiagramEditorInput(String configName, RootClass[] rcs) {
        ArrayList<RootClass> roots = new ArrayList<RootClass>();
        int i = 0;
        while (i < rcs.length) {
            roots.add(rcs[i]);
            ++i;
        }
        this.createOrmDiagram(configName, roots);
    }

    protected void createOrmDiagram(String configName, ArrayList<RootClass> roots) {
        this.ormDiagram = new OrmDiagram(configName, roots);
    }

    public OrmDiagram getOrmDiagram() {
        return this.ormDiagram;
    }

    public ConsoleConfiguration getConsoleConfig() {
        return this.getOrmDiagram().getConsoleConfig();
    }

    public boolean exists() {
        return this.storage != null;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public String getName() {
        return this.ormDiagram.getDiagramName();
    }

    public String getStoreFileName() {
        return this.ormDiagram.getStoreFileName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean equals(Object obj) {
        boolean res = false;
        if (!(obj instanceof DiagramEditorInput)) {
            return res;
        }
        DiagramEditorInput oei = (DiagramEditorInput)obj;
        return this.ormDiagram.equals(oei.ormDiagram);
    }

    public int hashCode() {
        return this.ormDiagram.hashCode();
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public String getFactoryId() {
        return "org.jboss.tools.hibernate.ui.view.DiagramEditorInputFactory";
    }

    public void saveState(IMemento memento) {
        this.ormDiagram.saveState(memento);
    }

    public void loadState(IMemento memento) {
        this.ormDiagram.loadState(memento);
        if (this.ormDiagram.getConsoleConfig() != null) {
            this.ormDiagram.setMemento(memento);
            this.ormDiagram.refresh();
        } else {
            this.ormDiagram.setMemento(memento);
        }
        this.ormDiagram.setDirty(false);
    }
}

