/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.compiler.ReconcileContext;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.eclipse.jdt.ui.internal.HQLDetector;
import org.hibernate.eclipse.nature.HibernateNature;

public class HQLExpressionCompilerParticipant
extends CompilationParticipant {
    protected CompilationUnit parse(ICompilationUnit unit) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setKind(8);
        parser.setSource(unit);
        parser.setResolveBindings(false);
        return (CompilationUnit)parser.createAST(null);
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        int i = 0;
        while (i < files.length) {
            BuildContext context = files[i];
            ConsoleConfiguration consoleConfiguration = this.getConsoleConfiguration(ProjectUtils.findJavaProject((String)context.getFile().getProject().getName()));
            if (consoleConfiguration != null && consoleConfiguration.isSessionFactoryCreated()) {
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setKind(8);
                parser.setSource(context.getContents());
                parser.setResolveBindings(false);
                ASTNode node = parser.createAST(null);
                CompilationUnit cu = null;
                if (node instanceof CompilationUnit) {
                    cu = (CompilationUnit)node;
                }
                HQLDetector hqlDetector = new HQLDetector(cu, consoleConfiguration, (IResource)context.getFile());
                node.accept((ASTVisitor)hqlDetector);
                if (!hqlDetector.getProblems().isEmpty()) {
                    CategorizedProblem[] toArray = hqlDetector.getProblems().toArray(new CategorizedProblem[0]);
                    context.recordNewProblems(toArray);
                }
            }
            ++i;
        }
    }

    public boolean isActive(IJavaProject project) {
        return HibernateNature.getHibernateNature((IJavaProject)project) != null;
    }

    public void reconcile(ReconcileContext context) {
    }

    private ConsoleConfiguration getConsoleConfiguration(IJavaProject project) {
        return HQLExpressionCompilerParticipant.getConsoleConfiguration(HibernateNature.getHibernateNature((IJavaProject)project));
    }

    static ConsoleConfiguration getConsoleConfiguration(HibernateNature hibernateNature) {
        if (hibernateNature != null) {
            return hibernateNature.getDefaultConsoleConfiguration();
        }
        return null;
    }

    public void cleanStarting(IJavaProject javaProject) {
        super.cleanStarting(javaProject);
    }
}

