/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.MultiStateTextFileChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.hibernate.eclipse.console.AbstractQueryEditor;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.hqleditor.HQLEditor;
import org.hibernate.eclipse.jdt.ui.internal.JdtUiMessages;

public class SaveQueryEditorListener
implements IPropertyListener {
    public static final String id = "AbstractQueryEditor.ReplaceString";
    public static final int HQLEditor = 0;
    public static final int CriteriaEditor = 1;
    private ITextEditor fromEditorPart;
    private AbstractQueryEditor editor;
    private String query;
    private Point position;

    public SaveQueryEditorListener(final ITextEditor fromEditorPart, String consoleName, String query, Point position, int editorNum) {
        this.fromEditorPart = fromEditorPart;
        this.query = query;
        this.position = position;
        switch (editorNum) {
            case 0: {
                this.editor = (AbstractQueryEditor)HibernateConsolePlugin.getDefault().openScratchHQLEditor(consoleName, query);
                break;
            }
            default: {
                this.editor = (AbstractQueryEditor)HibernateConsolePlugin.getDefault().openCriteriaEditor(consoleName, query);
            }
        }
        this.editor.addPropertyListener((IPropertyListener)this);
        this.editor.showConnected((IEditorPart)fromEditorPart);
        final IWorkbenchPart fromWorkbenchPart = fromEditorPart.getEditorSite().getPart();
        IPartListener pl = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (fromWorkbenchPart == part) {
                    fromEditorPart.getEditorSite().getPage().removePartListener((IPartListener)this);
                    SaveQueryEditorListener.this.editor.removePropertyListener((IPropertyListener)SaveQueryEditorListener.this);
                    SaveQueryEditorListener.this.editor.showDisconnected();
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        fromEditorPart.getEditorSite().getPage().addPartListener(pl);
    }

    public void propertyChanged(Object source, int propId) {
        if (257 == propId && !this.editor.isDirty()) {
            String editor_name;
            IDocumentProvider docProvider = this.fromEditorPart.getDocumentProvider();
            final IFile file = ((IFileEditorInput)this.fromEditorPart.getEditorInput()).getFile();
            final IDocument doc = docProvider.getDocument((Object)this.fromEditorPart.getEditorInput());
            boolean isDocChanged = true;
            try {
                if (this.query.equals(doc.get(this.position.x, this.position.y))) {
                    isDocChanged = false;
                }
            }
            catch (BadLocationException badLocationException) {}
            final String editorTitle = this.fromEditorPart.getTitle();
            String string = editor_name = this.editor instanceof HQLEditor ? JdtUiMessages.SaveQueryEditorListener_hql_editor : JdtUiMessages.SaveQueryEditorListener_cri_editor;
            if (isDocChanged) {
                String information_message = NLS.bind((String)JdtUiMessages.SaveQueryEditorListener_replacequestion_confirm, (Object)editorTitle);
                MessageDialog.openInformation(null, (String)JdtUiMessages.SaveQueryEditorListener_replacetitle_info, (String)information_message);
                return;
            }
            final String newQuery = this.editor.getQueryString();
            final String wizard_title = NLS.bind((String)JdtUiMessages.SaveQueryEditorListener_refactoringtitle, (Object)editor_name);
            Refactoring ref = new Refactoring(){

                public RefactoringStatus checkFinalConditions(IProgressMonitor pm) {
                    return RefactoringStatus.create((IStatus)Status.OK_STATUS);
                }

                public RefactoringStatus checkInitialConditions(IProgressMonitor pm) {
                    return RefactoringStatus.create((IStatus)Status.OK_STATUS);
                }

                public Change createChange(IProgressMonitor pm) {
                    String change_name = NLS.bind((String)JdtUiMessages.SaveQueryEditorListener_change_name, (Object)editor_name, (Object)editorTitle);
                    DocumentChange change = new DocumentChange(change_name, doc);
                    ReplaceEdit replaceEdit = new ReplaceEdit(((SaveQueryEditorListener)SaveQueryEditorListener.this).position.x, ((SaveQueryEditorListener)SaveQueryEditorListener.this).position.y, newQuery);
                    change.setEdit((TextEdit)replaceEdit);
                    String cc_name = NLS.bind((String)JdtUiMessages.SaveQueryEditorListener_composite_change_name, (Object)editor_name);
                    MultiStateTextFileChange mChange = new MultiStateTextFileChange(cc_name, file);
                    mChange.addChange((TextChange)change);
                    return mChange;
                }

                public String getName() {
                    return JdtUiMessages.SaveQueryEditorListener_composite_change_name;
                }
            };
            RefactoringWizard wizard = new RefactoringWizard(ref, 4){

                protected void addUserInputPages() {
                    UserInputWizardPage page = new UserInputWizardPage(wizard_title){

                        public void createControl(Composite parent) {
                            Composite container = new Composite(parent, 0);
                            GridLayout layout = new GridLayout();
                            container.setLayout((Layout)layout);
                            layout.numColumns = 1;
                            layout.verticalSpacing = 9;
                            Label label = new Label(container, 0);
                            label.setText(NLS.bind((String)JdtUiMessages.SaveQueryEditorListener_replacequestion, (Object)editor_name, (Object)editorTitle));
                            this.setControl((Control)container);
                        }
                    };
                    this.addPage((IWizardPage)page);
                }
            };
            wizard.setWindowTitle(wizard_title);
            wizard.setDefaultPageTitle(wizard_title);
            IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (new RefactoringStarter().activate(wizard, win.getShell(), wizard_title, 2)) {
                this.query = newQuery;
                this.position.y = this.query.length();
                this.fromEditorPart.doSave(null);
            } else if (this.editor.getDocumentProvider() instanceof TextFileDocumentProvider) {
                ((TextFileDocumentProvider)this.editor.getDocumentProvider()).setCanSaveDocument((Object)this.editor.getEditorInput());
            }
        }
    }
}

