/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal.jpa.collect;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jface.viewers.StructuredSelection;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationUnitCollector {
    protected List<Object> selection2UpdateList = new ArrayList<Object>();
    protected Set<ICompilationUnit> selectionCU = new HashSet<ICompilationUnit>();

    public void clearSelectionCU() {
        this.selectionCU.clear();
    }

    public Iterator<ICompilationUnit> setSelectionCUIterator() {
        return this.selectionCU.iterator();
    }

    public void setSelectionCU(Set<ICompilationUnit> selectionCU) {
        this.selectionCU = selectionCU;
    }

    public int getSelectionCUSize() {
        return this.selectionCU.size();
    }

    public void clearSelection2UpdateList() {
        this.selection2UpdateList.clear();
    }

    public StructuredSelection createSelection2Update() {
        return new StructuredSelection(this.selection2UpdateList);
    }

    public void addCompilationUnit(ICompilationUnit cu, boolean bCollect) {
        if (cu != null) {
            IType[] types = null;
            try {
                types = cu.getTypes();
            }
            catch (JavaModelException javaModelException) {}
            if (types != null && bCollect) {
                int i = 0;
                while (i < types.length) {
                    if (types[i] instanceof SourceType) {
                        this.selection2UpdateList.add(types[i]);
                    }
                    ++i;
                }
                bCollect = false;
            }
            this.selectionCU.add(cu);
        }
    }

    public void processJavaElements(Object obj, boolean bCollect) {
        if (obj instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)obj;
            this.addCompilationUnit(cu, bCollect);
        } else if (obj instanceof File) {
            IJavaProject javaProject;
            ICompilationUnit[] cus;
            File file = (File)obj;
            if (file.getProject() != null && (cus = Utils.findCompilationUnits(javaProject = JavaCore.create((IProject)file.getProject()), file.getFullPath())) != null) {
                int i = 0;
                while (i < cus.length) {
                    this.addCompilationUnit(cus[i], bCollect);
                    ++i;
                }
            }
        } else if (obj instanceof JavaProject) {
            JavaProject javaProject = (JavaProject)obj;
            IPackageFragmentRoot[] pfr = null;
            try {
                pfr = javaProject.getAllPackageFragmentRoots();
            }
            catch (JavaModelException javaModelException) {}
            if (pfr != null) {
                int i = 0;
                while (i < pfr.length) {
                    this.processJavaElements(pfr[i], bCollect);
                    ++i;
                }
            }
        } else if (obj instanceof PackageFragment) {
            PackageFragment packageFragment = (PackageFragment)obj;
            ICompilationUnit[] cus = null;
            try {
                cus = packageFragment.getCompilationUnits();
            }
            catch (JavaModelException javaModelException) {}
            if (cus != null && cus.length > 0) {
                if (bCollect) {
                    this.selection2UpdateList.add(obj);
                    bCollect = false;
                }
                int i = 0;
                while (i < cus.length) {
                    this.addCompilationUnit(cus[i], bCollect);
                    ++i;
                }
            }
        } else if (obj instanceof PackageFragmentRoot) {
            JavaElement javaElement = (JavaElement)obj;
            JavaElementInfo javaElementInfo = null;
            try {
                javaElementInfo = (JavaElementInfo)javaElement.getElementInfo();
            }
            catch (JavaModelException javaModelException) {}
            if (javaElementInfo != null) {
                IJavaElement[] je = javaElementInfo.getChildren();
                int i = 0;
                while (i < je.length) {
                    this.processJavaElements(je[i], true);
                    ++i;
                }
            }
        } else if (obj instanceof JavaElement) {
            JavaElement javaElement = (JavaElement)obj;
            ICompilationUnit cu = javaElement.getCompilationUnit();
            this.addCompilationUnit(cu, bCollect);
        } else if (obj instanceof SourceType) {
            if (bCollect) {
                this.selection2UpdateList.add(obj);
                bCollect = false;
            }
            SourceType sourceType = (SourceType)obj;
            this.processJavaElements(sourceType.getJavaModel(), bCollect);
        }
    }

    public void collectFromSelection2UpdateList() {
        this.clearSelectionCU();
        Iterator<Object> it = this.selection2UpdateList.iterator();
        while (it.hasNext()) {
            this.processJavaElements(it.next(), true);
        }
    }
}

