/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.hibernate.eclipse.jdt.ui.internal.JdtUiMessages;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.AnnotStyle;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard.IHibernateJPAWizardData;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard.IHibernateJPAWizardParams;

public class EntitiesList
extends UserInputWizardPage {
    private final ImageDescriptorRegistry registry = JavaPlugin.getImageDescriptorRegistry();
    private final Point IMAGE_SIZE = new Point(16, 16);
    protected TableViewer listViewer;
    protected IHibernateJPAWizardData data;
    protected IHibernateJPAWizardParams params;

    public EntitiesList(String name, IHibernateJPAWizardData data, IHibernateJPAWizardParams params) {
        super(name);
        this.data = data;
        this.params = params;
        this.setDescription(JdtUiMessages.EntitiesList_description);
    }

    public IStructuredContentProvider createContentProvider(final IHibernateJPAWizardData data) {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return data.getEntities().values().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    public void setData(IHibernateJPAWizardData data) {
        this.data = data;
        if (this.listViewer != null) {
            this.listViewer.setContentProvider((IContentProvider)this.createContentProvider(data));
            this.listViewer.setInput(data.getEntities());
            int i = 0;
            while (i < this.listViewer.getTable().getColumnCount()) {
                String property = (String)this.listViewer.getColumnProperties()[i];
                if (Columns.PROJECT.toString().equals(property)) {
                    this.listViewer.getTable().getColumn(i).setWidth(this.isOneProject() ? 0 : 200);
                    this.listViewer.getTable().getColumn(i).setResizable(!this.isOneProject());
                    this.listViewer.getTable().getColumn(i).pack();
                    break;
                }
                ++i;
            }
        }
    }

    public boolean isOneProject() {
        Map<String, EntityInfo> mapEntities = this.data.getEntities();
        Iterator<EntityInfo> it = mapEntities.values().iterator();
        boolean res = true;
        String javaProjectName = null;
        while (it.hasNext()) {
            EntityInfo ei = it.next();
            if (javaProjectName != null && !javaProjectName.equalsIgnoreCase(ei.getJavaProjectName())) {
                res = false;
                break;
            }
            javaProjectName = ei.getJavaProjectName();
        }
        return res;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.listViewer = new TableViewer(container, 2820);
        Control control = this.listViewer.getControl();
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(10);
        control.setLayoutData((Object)gridData);
        String[] columnProperties = new String[]{Columns.CLASS.toString(), Columns.PROJECT.toString()};
        this.listViewer.setColumnProperties(columnProperties);
        this.listViewer.setContentProvider((IContentProvider)this.createContentProvider(this.data));
        this.listViewer.setLabelProvider((IBaseLabelProvider)new TableLableProvider(this.listViewer));
        this.createTableColumns(this.listViewer.getTable());
        this.listViewer.setInput(this.data.getEntities());
        this.listViewer.getTable().setHeaderVisible(true);
        this.listViewer.getTable().setLinesVisible(true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(this.convertHorizontalDLUsToPixels(300), this.convertHorizontalDLUsToPixels(50)).applyTo(this.listViewer.getControl());
        Composite combolabel = new Composite(container, 0);
        layout = new GridLayout();
        combolabel.setLayout((Layout)layout);
        layout.numColumns = 2;
        Label labelChoice = new Label(combolabel, 0);
        labelChoice.setText(JdtUiMessages.AllEntitiesProcessor_preferred_location_annotations);
        Combo generateChoice = new Combo(combolabel, 8);
        generateChoice.add(JdtUiMessages.AllEntitiesProcessor_fields);
        generateChoice.add(JdtUiMessages.AllEntitiesProcessor_getters);
        generateChoice.add(JdtUiMessages.AllEntitiesProcessor_auto_select_from_class_preference);
        int idx = 0;
        if (this.params.getAnnotationStyle().equals((Object)AnnotStyle.FIELDS)) {
            idx = 0;
        } else if (this.params.getAnnotationStyle().equals((Object)AnnotStyle.GETTERS)) {
            idx = 1;
        } else if (this.params.getAnnotationStyle().equals((Object)AnnotStyle.AUTO)) {
            idx = 2;
        }
        generateChoice.select(idx);
        ModifyListener mlGenerateChoice = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int idx = ((Combo)e.getSource()).getSelectionIndex();
                if (idx == 0 && !EntitiesList.this.params.getAnnotationStyle().equals((Object)AnnotStyle.FIELDS)) {
                    EntitiesList.this.params.setAnnotationStyle(AnnotStyle.FIELDS);
                    EntitiesList.this.params.reCollectModification(EntitiesList.this.data.getEntities());
                } else if (idx == 1 && !EntitiesList.this.params.getAnnotationStyle().equals((Object)AnnotStyle.GETTERS)) {
                    EntitiesList.this.params.setAnnotationStyle(AnnotStyle.GETTERS);
                    EntitiesList.this.params.reCollectModification(EntitiesList.this.data.getEntities());
                } else if (idx == 2 && !EntitiesList.this.params.getAnnotationStyle().equals((Object)AnnotStyle.AUTO)) {
                    EntitiesList.this.params.setAnnotationStyle(EntitiesList.this.params.getAnnotationStylePreference());
                    EntitiesList.this.params.reCollectModification(EntitiesList.this.data.getEntities());
                    EntitiesList.this.params.setAnnotationStyle(AnnotStyle.AUTO);
                }
            }
        };
        generateChoice.addModifyListener(mlGenerateChoice);
        Label labelDefaultStrLength = new Label(combolabel, 0);
        labelDefaultStrLength.setText(JdtUiMessages.AllEntitiesProcessor_default_string_length);
        Text textDefaultStrLength = new Text(combolabel, 133124);
        textDefaultStrLength.setText(String.valueOf(this.params.getDefaultStrLength()));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)textDefaultStrLength);
        textDefaultStrLength.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                int i = 0;
                while (i < e.text.length()) {
                    char val = e.text.charAt(i);
                    if ('0' > val || val > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        ModifyListener mlDefaultStrLength = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e == null || !(e.getSource() instanceof Text)) {
                    return;
                }
                String str = ((Text)e.getSource()).getText();
                Integer val = 255;
                if (str != null && str.length() > 0) {
                    val = Integer.valueOf(str);
                }
                EntitiesList.this.params.setDefaultStrLength(val);
                EntitiesList.this.params.reCollectModification(EntitiesList.this.data.getEntities());
            }
        };
        textDefaultStrLength.addModifyListener(mlDefaultStrLength);
        Label labelOptLock = new Label(combolabel, 0);
        labelOptLock.setText(JdtUiMessages.AllEntitiesProcessor_enable_optimistic_locking);
        Button checkboxOptLock = new Button(combolabel, 32);
        checkboxOptLock.setSelection(this.params.getEnableOptLock());
        Listener mlOptLock = new Listener(){

            public void handleEvent(Event e) {
                EntitiesList.this.params.setEnableOptLock(((Button)e.widget).getSelection());
                EntitiesList.this.params.reCollectModification(EntitiesList.this.data.getEntities());
            }
        };
        checkboxOptLock.addListener(13, mlOptLock);
        this.setControl((Control)container);
    }

    protected void createTableColumns(Table table) {
        TableColumn column = null;
        int i = 0;
        column = new TableColumn(table, 16384, i++);
        column.setText(JdtUiMessages.ResolveAmbiguous_column_Class);
        column.setWidth(200);
        column.setImage(this.registry.get((ImageDescriptor)new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CLASS, 0, this.IMAGE_SIZE)));
        column = new TableColumn(table, 16384, i++);
        column.setText(JdtUiMessages.NewHibernateMappingFilePage_project_name_column);
        column.setWidth(this.isOneProject() ? 0 : 200);
        column.setImage(this.registry.get((ImageDescriptor)new JavaElementImageDescriptor(JavaPlugin.getDefault().getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT"), 0, this.IMAGE_SIZE)));
        column.setResizable(!this.isOneProject());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Columns {
        PROJECT,
        CLASS;

    }

    protected class TableLableProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected final TableViewer tv;

        public TableLableProvider(TableViewer tv) {
            this.tv = tv;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String property = (String)this.tv.getColumnProperties()[columnIndex];
            EntityInfo info = (EntityInfo)element;
            if (Columns.CLASS.toString().equals(property)) {
                return info.getFullyQualifiedName();
            }
            if (Columns.PROJECT.toString().equals(property)) {
                return info.getJavaProjectName();
            }
            return "";
        }
    }
}

