/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard;

import java.util.Map;
import java.util.Set;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.hibernate.eclipse.jdt.ui.internal.JdtUiMessages;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.OwnerType;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefEntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefFieldInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefType;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.Utils;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard.IHibernateJPAWizardData;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard.IHibernateJPAWizardParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveAmbiguous
extends UserInputWizardPage {
    protected IHibernateJPAWizardData data;
    protected IHibernateJPAWizardParams params;
    protected final int COLUMN_CLASS = 0;
    protected final int COLUMN_PROPERTY = 1;
    protected final int COLUMN_TYPE = 2;
    protected final int COLUMN_RELATED = 3;
    protected final int COLUMN_OWNER = 4;
    protected Table table;
    protected TableEditor editorType;
    protected TableEditor editorRel;
    protected TableEditor editorOwner;
    protected EditorTypeModifyListener editorTypeModifyListener = new EditorTypeModifyListener();
    protected EditorRelModifyListener editorRelModifyListener = new EditorRelModifyListener();
    protected EditorOwnerModifyListener editorOwnerModifyListener = new EditorOwnerModifyListener();

    public ResolveAmbiguous(String name, IHibernateJPAWizardData data, IHibernateJPAWizardParams params) {
        super(name);
        this.data = data;
        this.params = params;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        Label label = new Label(container, 0);
        label.setText(JdtUiMessages.ResolveAmbiguous_message);
        this.table = new Table(container, 68356);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.createTableColumns(this.table);
        TableItem ti = null;
        for (Map.Entry<String, EntityInfo> entry : this.data.getEntities().entrySet()) {
            if (entry.getValue().isAbstractFlag()) continue;
            for (Map.Entry<String, RefEntityInfo> entryRef : entry.getValue().getReferences().entrySet()) {
                RefEntityInfo rei = entryRef.getValue();
                ti = new TableItem(this.table, 0);
                ti.setData((Object)rei);
                ti.setText(0, entry.getKey());
                String shortName = this.getShortName(rei.fullyQualifiedName);
                ti.setText(1, String.valueOf(shortName) + " " + entryRef.getKey());
                ti.setText(2, Utils.refTypeToStr(rei.refType));
                if (rei.mappedBy != null) {
                    ti.setText(3, rei.mappedBy);
                } else {
                    ti.setText(3, JdtUiMessages.ResolveAmbiguous_empty);
                }
                ti.setText(4, Utils.ownerTypeToStr(rei.owner));
            }
        }
        this.editorType = new TableEditor(this.table);
        this.editorType.horizontalAlignment = 16384;
        this.editorType.grabHorizontal = true;
        this.editorType.minimumWidth = 50;
        this.editorRel = new TableEditor(this.table);
        this.editorRel.horizontalAlignment = 16384;
        this.editorRel.grabHorizontal = true;
        this.editorRel.minimumWidth = 50;
        this.editorOwner = new TableEditor(this.table);
        this.editorOwner.horizontalAlignment = 16384;
        this.editorOwner.grabHorizontal = true;
        this.editorOwner.minimumWidth = 50;
        this.table.addSelectionListener((SelectionListener)new TableSelectionListener());
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        this.table.setLayoutData((Object)data);
        this.setControl((Control)container);
    }

    public void updateDependentRefEntityInfoType(RefEntityInfo rei, RefEntityInfo rei2) {
        if (rei == null) {
            return;
        }
        if (rei.refType == RefType.MANY2ONE) {
            rei.owner = OwnerType.NO;
            if (rei2 != null) {
                rei2.refType = RefType.ONE2MANY;
                rei2.owner = OwnerType.YES;
            }
        }
        if (rei.refType == RefType.ONE2MANY) {
            rei.owner = OwnerType.YES;
            if (rei2 != null) {
                rei2.refType = RefType.MANY2ONE;
                rei2.owner = OwnerType.NO;
            }
        }
    }

    public void updateEditorType(TableItem item) {
        Control oldEditorType = this.editorType.getEditor();
        if (oldEditorType != null) {
            oldEditorType.dispose();
        }
        CCombo comboType = new CCombo((Composite)this.table, 0);
        comboType.setEditable(false);
        Color bkgnd = this.table.getBackground();
        comboType.setBackground(bkgnd);
        RefEntityInfo rei = (RefEntityInfo)item.getData();
        comboType.add(Utils.refTypeToStr(RefType.ONE2ONE));
        comboType.add(Utils.refTypeToStr(RefType.ONE2MANY));
        comboType.add(Utils.refTypeToStr(RefType.MANY2ONE));
        comboType.add(Utils.refTypeToStr(RefType.MANY2MANY));
        comboType.add(Utils.refTypeToStr(RefType.UNDEF));
        comboType.setText(Utils.refTypeToStr(rei.refType));
        comboType.addModifyListener((ModifyListener)this.editorTypeModifyListener);
        comboType.setFocus();
        this.editorType.setEditor((Control)comboType, item, 2);
    }

    public void updateEditorRel(TableItem item) {
        Control oldEditorRel = this.editorRel.getEditor();
        if (oldEditorRel != null) {
            oldEditorRel.dispose();
        }
        CCombo comboRel = new CCombo((Composite)this.table, 0);
        comboRel.setEditable(false);
        Color bkgnd = this.table.getBackground();
        comboRel.setBackground(bkgnd);
        comboRel.add(JdtUiMessages.ResolveAmbiguous_empty);
        String fullyQualifiedName = item.getText(0);
        RefEntityInfo rei = (RefEntityInfo)item.getData();
        Set<RefFieldInfo> setRefEntityInfo = this.findRelatedRefFieldInfos(fullyQualifiedName, rei);
        for (RefFieldInfo rfi : setRefEntityInfo) {
            comboRel.add(rfi.fieldId);
        }
        if (rei.mappedBy != null) {
            comboRel.setText(rei.mappedBy);
        } else {
            comboRel.setText(JdtUiMessages.ResolveAmbiguous_empty);
        }
        comboRel.addModifyListener((ModifyListener)this.editorRelModifyListener);
        this.editorRel.setEditor((Control)comboRel, item, 3);
    }

    public void updateDependentRefEntityInfoOwner(RefEntityInfo rei, RefEntityInfo rei2) {
        if (rei == null) {
            return;
        }
        if (rei2 != null && (rei.refType == RefType.ONE2ONE || rei.refType == RefType.MANY2MANY)) {
            if (rei.owner == OwnerType.YES) {
                rei2.owner = OwnerType.NO;
            } else if (rei.owner == OwnerType.NO) {
                rei2.owner = OwnerType.YES;
            }
        }
        if (rei.refType == RefType.MANY2ONE) {
            if (rei.owner == OwnerType.YES) {
                rei.refType = RefType.UNDEF;
                if (rei2 != null) {
                    rei2.refType = RefType.UNDEF;
                    rei2.owner = OwnerType.NO;
                }
            } else if (rei2 != null) {
                rei2.owner = OwnerType.YES;
            }
        }
        if (rei.refType == RefType.ONE2MANY) {
            if (rei.owner == OwnerType.NO) {
                rei.refType = RefType.UNDEF;
                if (rei2 != null) {
                    rei2.refType = RefType.UNDEF;
                    rei2.owner = OwnerType.YES;
                }
            } else if (rei2 != null) {
                rei2.owner = OwnerType.NO;
            }
        }
    }

    public void updateEditorOwner(TableItem item) {
        Control oldEditorOwner = this.editorOwner.getEditor();
        if (oldEditorOwner != null) {
            oldEditorOwner.dispose();
        }
        RefEntityInfo rei = (RefEntityInfo)item.getData();
        CCombo comboOwner = new CCombo((Composite)this.table, 0);
        comboOwner.setEditable(false);
        Color bkgnd = this.table.getBackground();
        comboOwner.setBackground(bkgnd);
        comboOwner.add(Utils.ownerTypeToStr(OwnerType.YES));
        comboOwner.add(Utils.ownerTypeToStr(OwnerType.NO));
        comboOwner.setText(Utils.ownerTypeToStr(rei.owner));
        comboOwner.addModifyListener((ModifyListener)this.editorOwnerModifyListener);
        this.editorOwner.setEditor((Control)comboOwner, item, 4);
    }

    public void updateTI(TableItem ti) {
        if (ti == null) {
            return;
        }
        RefEntityInfo rei = (RefEntityInfo)ti.getData();
        ti.setText(2, Utils.refTypeToStr(rei.refType));
        if (rei.mappedBy != null) {
            ti.setText(3, rei.mappedBy);
        } else {
            ti.setText(3, JdtUiMessages.ResolveAmbiguous_empty);
        }
        ti.setText(4, Utils.ownerTypeToStr(rei.owner));
    }

    protected void createTableColumns(Table table) {
        TableColumn column = null;
        column = new TableColumn(table, 16384, 0);
        column.setText(JdtUiMessages.ResolveAmbiguous_column_Class);
        column.setWidth(200);
        column = new TableColumn(table, 16384, 1);
        column.setText(JdtUiMessages.ResolveAmbiguous_column_Property);
        column.setWidth(140);
        column = new TableColumn(table, 16384, 2);
        column.setText(JdtUiMessages.ResolveAmbiguous_column_Type);
        column.setWidth(60);
        column = new TableColumn(table, 16384, 3);
        column.setText(JdtUiMessages.ResolveAmbiguous_column_Related);
        column.setWidth(80);
        column = new TableColumn(table, 16384, 4);
        column.setText(JdtUiMessages.ResolveAmbiguous_column_Owner);
        column.setWidth(50);
    }

    public String getShortName(String fullyQualifiedName) {
        int idx = fullyQualifiedName.lastIndexOf(46);
        if (idx == -1) {
            return fullyQualifiedName;
        }
        return fullyQualifiedName.substring(idx + 1);
    }

    protected Set<RefFieldInfo> findRelatedRefFieldInfos(String fullyQualifiedName, RefEntityInfo rei) {
        String fullyQualifiedName2 = rei.fullyQualifiedName;
        EntityInfo entryInfo2 = this.data.getEntities().get(fullyQualifiedName2);
        Set<RefFieldInfo> setRefEntityInfo = entryInfo2.getRefFieldInfoSet(fullyQualifiedName);
        return setRefEntityInfo;
    }

    protected RefEntityInfo findMappedRefEntityInfo(RefEntityInfo rei) {
        if (rei.mappedBy == null) {
            return null;
        }
        String fullyQualifiedName2 = rei.fullyQualifiedName;
        EntityInfo entryInfo2 = this.data.getEntities().get(fullyQualifiedName2);
        RefEntityInfo refEntityInfo = entryInfo2.getFieldIdRefEntityInfo(rei.mappedBy);
        return refEntityInfo;
    }

    public String getFieldId(String fieldId) {
        int idx = fieldId.lastIndexOf(32);
        if (idx == -1) {
            return fieldId;
        }
        return fieldId.substring(idx + 1);
    }

    protected TableItem findTableItem(RefEntityInfo rei1, RefEntityInfo rei2) {
        if (rei1 == null || rei2 == null) {
            return null;
        }
        TableItem ti = null;
        TableItem tiRes = null;
        TableItem[] tis = this.table.getItems();
        int i = 0;
        while (i < tis.length) {
            ti = tis[i];
            if (ti.getText(0).equals(rei2.fullyQualifiedName)) {
                String fieldId1 = this.getFieldId(ti.getText(1));
                String fieldId2 = ti.getText(3);
                if (fieldId2.equals(rei1.mappedBy) && fieldId1.equals(rei2.mappedBy)) {
                    tiRes = ti;
                    break;
                }
            }
            ++i;
        }
        return tiRes;
    }

    protected class EditorOwnerModifyListener
    implements ModifyListener {
        protected EditorOwnerModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            CCombo text = (CCombo)ResolveAmbiguous.this.editorOwner.getEditor();
            String str = text.getText();
            TableItem ti = ResolveAmbiguous.this.editorOwner.getItem();
            RefEntityInfo rei = (RefEntityInfo)ti.getData();
            OwnerType oldVal = rei.owner;
            rei.owner = Utils.strToOwnerType(str);
            if (oldVal != rei.owner) {
                RefEntityInfo rei2 = ResolveAmbiguous.this.findMappedRefEntityInfo(rei);
                TableItem ti2 = ResolveAmbiguous.this.findTableItem(rei2, rei);
                ResolveAmbiguous.this.updateDependentRefEntityInfoOwner(rei, rei2);
                ResolveAmbiguous.this.updateEditorType(ti);
                ResolveAmbiguous.this.updateTI(ti);
                ResolveAmbiguous.this.updateTI(ti2);
                ResolveAmbiguous.this.params.reCollectModification(ResolveAmbiguous.this.data.getEntities());
            }
        }
    }

    protected class EditorRelModifyListener
    implements ModifyListener {
        protected EditorRelModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            CCombo text = (CCombo)ResolveAmbiguous.this.editorRel.getEditor();
            String str = text.getText();
            TableItem ti = ResolveAmbiguous.this.editorRel.getItem();
            RefEntityInfo rei = (RefEntityInfo)ti.getData();
            String oldVal = rei.mappedBy;
            rei.mappedBy = JdtUiMessages.ResolveAmbiguous_empty.equals(str) ? null : str;
            if (oldVal != rei.mappedBy) {
                rei.refType = RefType.UNDEF;
                rei.owner = OwnerType.UNDEF;
                ResolveAmbiguous.this.updateEditorType(ti);
                ResolveAmbiguous.this.updateEditorOwner(ti);
                ResolveAmbiguous.this.updateTI(ti);
                ResolveAmbiguous.this.params.reCollectModification(ResolveAmbiguous.this.data.getEntities());
            }
        }
    }

    protected class EditorTypeModifyListener
    implements ModifyListener {
        protected EditorTypeModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            CCombo text = (CCombo)ResolveAmbiguous.this.editorType.getEditor();
            String str = text.getText();
            TableItem ti = ResolveAmbiguous.this.editorType.getItem();
            RefEntityInfo rei = (RefEntityInfo)ti.getData();
            RefType oldVal = rei.refType;
            OwnerType oldVal2 = rei.owner;
            rei.refType = Utils.strToRefType(str);
            if (rei.refType == RefType.ONE2MANY) {
                rei.owner = OwnerType.YES;
            } else if (rei.refType == RefType.MANY2ONE) {
                rei.owner = OwnerType.NO;
            }
            if (oldVal != rei.refType || oldVal2 != rei.owner) {
                RefEntityInfo rei2 = ResolveAmbiguous.this.findMappedRefEntityInfo(rei);
                TableItem ti2 = ResolveAmbiguous.this.findTableItem(rei2, rei);
                ResolveAmbiguous.this.updateDependentRefEntityInfoType(rei, rei2);
                ResolveAmbiguous.this.updateEditorOwner(ti);
                ResolveAmbiguous.this.updateTI(ti);
                ResolveAmbiguous.this.updateTI(ti2);
                ResolveAmbiguous.this.params.reCollectModification(ResolveAmbiguous.this.data.getEntities());
            }
        }
    }

    protected class TableSelectionListener
    extends SelectionAdapter {
        protected TableSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem item = (TableItem)e.item;
            if (item == null) {
                return;
            }
            ResolveAmbiguous.this.updateEditorType(item);
            ResolveAmbiguous.this.updateEditorRel(item);
            ResolveAmbiguous.this.updateEditorOwner(item);
        }
    }
}

