/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.birt.core;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.jboss.tools.birt.core.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BirtCoreActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.birt.core";
    public static final IOverwriteQuery OVERWRITE_ALL_QUERY = new IOverwriteQuery(){

        public String queryOverwrite(String pathString) {
            return "ALL";
        }
    };
    private static BirtCoreActivator plugin;
    public static final String JBOSS_BIRT__FACET_ID = "jboss.birt";
    public static final String BIRT_FACET_ID = "birt.runtime";
    public static final String SEAM_FACET_ID = "jst.seam";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static BirtCoreActivator getDefault() {
        return plugin;
    }

    public static void copyPlugin(IProject project, String pluginId, String destination, IProgressMonitor monitor) {
        IResource destResource = project.findMember(destination);
        if (!destResource.exists()) {
            Status status = new Status(2, PLUGIN_ID, NLS.bind((String)Messages.BirtCoreActivator_The_folder_doesnt_exists, (Object)destination));
            BirtCoreActivator.getDefault().getLog().log((IStatus)status);
            return;
        }
        if (destResource.getType() != 2) {
            Status status = new Status(2, PLUGIN_ID, NLS.bind((String)Messages.BirtCoreActivator_The_resource_is_not_folder, (Object)destination));
            BirtCoreActivator.getDefault().getLog().log((IStatus)status);
            return;
        }
        try {
            IFolder destFolder = (IFolder)destResource;
            Bundle bundle = Platform.getBundle((String)pluginId);
            File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
            IFolder folder = null;
            File file = null;
            ArrayList<File> filesToImport = new ArrayList<File>();
            if (bundleFile.isDirectory()) {
                URL url = bundle.getEntry("/");
                String fileName = FileLocator.toFileURL((URL)url).getFile();
                file = new File(fileName);
                filesToImport.addAll(Arrays.asList(file.listFiles()));
                String name = file.getName();
                folder = destFolder.getFolder((IPath)new Path(name));
                if (folder.exists()) {
                    return;
                }
                folder.create(true, true, monitor);
            } else {
                filesToImport.add(bundleFile);
                file = bundleFile.getParentFile();
                folder = destFolder;
                String outputFileName = bundleFile.getName();
                IFile outputFile = folder.getFile(outputFileName);
                if (outputFile.exists()) {
                    return;
                }
            }
            ImportOperation importOperation = new ImportOperation(folder.getFullPath(), (Object)file, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, OVERWRITE_ALL_QUERY, filesToImport);
            importOperation.setCreateContainerStructure(false);
            importOperation.run(monitor);
        }
        catch (Exception e) {
            Status status = new Status(2, PLUGIN_ID, e.getMessage());
            BirtCoreActivator.getDefault().getLog().log((IStatus)status);
            return;
        }
    }
}

