/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.birt.core.internal.project.facet;

import java.util.Map;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.WebAppBean;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.BirtWizardUtil;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.SimpleImportOverwriteQuery;
import org.eclipse.birt.integration.wtp.ui.project.facet.BirtFacetInstallDelegate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebAppVersionType;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.jboss.tools.birt.core.BirtCoreActivator;
import org.jboss.tools.birt.core.internal.project.facet.IBirtUtil;
import org.jboss.tools.birt.core.internal.project.facet.JBossBirtUtil;
import org.jboss.tools.birt.core.internal.project.facet.JBossBirtUtil25;

public class JBossBirtFacetInstallDelegate
extends BirtFacetInstallDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        super.execute(project, fv, config, monitor);
        IDataModel facetDataModel = (IDataModel)config;
        IDataModel masterDataModel = (IDataModel)facetDataModel.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM");
        String configFolder = BirtWizardUtil.getConfigFolder((IDataModel)masterDataModel);
        String platformFolder = String.valueOf(configFolder) + "/WEB-INF/platform/plugins";
        BirtCoreActivator.copyPlugin(project, "org.jboss.tools.birt.oda", platformFolder, monitor);
    }

    protected void processConfiguration(final IProject project, final Map birtProperties, final IProgressMonitor monitor) throws CoreException {
        final SimpleImportOverwriteQuery query = new SimpleImportOverwriteQuery();
        IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)project);
        IPath modelPath = new Path("WEB-INF").append("web.xml");
        boolean exists = project.getProjectRelativePath().append(modelPath).toFile().exists();
        if (this.isWebApp25(modelProvider.getModelObject()) && !exists) {
            modelPath = IModelProvider.FORCESAVE;
        }
        final IBirtUtil util = this.createBirtUtil(modelProvider.getModelObject());
        modelProvider.modify(new Runnable(){

            public void run() {
                util.configureWebApp((WebAppBean)birtProperties.get("webapp"), project, query, monitor);
                util.configureContextParam((Map)birtProperties.get("context-param"), project, query, monitor);
                util.configureListener((Map)birtProperties.get("listener"), project, query, monitor);
                util.configureServlet((Map)birtProperties.get("servlet"), project, query, monitor);
                util.configureServletMapping((Map)birtProperties.get("servlet-mapping"), project, query, monitor);
                util.configureFilter((Map)birtProperties.get("filter"), project, query, monitor);
                util.configureFilterMapping((Map)birtProperties.get("filter-mapping"), project, query, monitor);
                util.configureTaglib((Map)birtProperties.get("taglib"), project, query, monitor);
            }
        }, modelPath);
    }

    private IBirtUtil createBirtUtil(Object webApp) {
        if (this.isWebApp25(webApp)) {
            return new JBossBirtUtil25();
        }
        return new JBossBirtUtil();
    }

    private boolean isWebApp25(Object webApp) {
        return webApp instanceof WebApp && ((WebApp)webApp).getVersion() == WebAppVersionType._25_LITERAL;
    }
}

