/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.birt.oda.impl;

import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.osgi.util.NLS;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.jboss.tools.birt.oda.Messages;
import org.jboss.tools.birt.oda.impl.AbstractOdaFactory;

public class ConsoleConfigurationOdaFactory
extends AbstractOdaFactory {
    ConsoleConfiguration consoleConfiguration;

    public ConsoleConfigurationOdaFactory(Properties properties) throws OdaException {
        this.getSessionFactory(properties);
        String maxRowString = properties.getProperty("maxRows");
        try {
            this.setMaxRows(new Integer(maxRowString));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SessionFactory getSessionFactory(Properties properties) throws OdaException {
        String configurationName = properties.getProperty("configuration");
        ConsoleConfiguration[] configurations = KnownConfigurations.getInstance().getConfigurations();
        int i = 0;
        while (i < configurations.length) {
            if (configurations[i].getName().equals(configurationName)) {
                this.consoleConfiguration = configurations[i];
                break;
            }
            ++i;
        }
        if (this.isOpen()) throw new OdaException(NLS.bind((String)Messages.ConsoleConfigurationOdaFactory_Invalid_configuration, (Object)configurationName));
        try {
            this.sessionFactory = this.consoleConfiguration.getSessionFactory();
            if (this.sessionFactory != null) return this.sessionFactory;
            this.consoleConfiguration.build();
            this.consoleConfiguration.buildSessionFactory();
            this.sessionFactory = this.consoleConfiguration.getSessionFactory();
            return this.sessionFactory;
        }
        catch (HibernateException e) {
            throw new OdaException(e.getLocalizedMessage());
        }
    }
}

