/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.birt.oda.impl;

import java.util.StringTokenizer;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.birt.oda.Messages;
import org.jboss.tools.birt.oda.impl.DataTypes;
import org.jboss.tools.birt.oda.impl.HibernateDriver;

public class HibernateResultSetMetaData
implements IResultSetMetaData {
    private String[] columnName = null;
    private String[] columnType = null;
    private String[] columnLabel = null;
    private String[] columnClass = null;

    HibernateResultSetMetaData(String[] cName, String[] cType, String[] cLabel, String[] cClass) throws OdaException {
        if (cName == null) {
            throw new OdaException(Messages.HibernateResultSetMetaData_Argument_cannot_be_null);
        }
        this.columnName = cName;
        this.columnType = cType;
        this.columnLabel = cLabel;
        this.columnClass = cClass;
    }

    public int getColumnCount() throws OdaException {
        return this.columnName.length;
    }

    public String getColumnName(int index) throws OdaException {
        this.assertIndexValid(index);
        String name = this.columnName[index - 1].trim();
        if (name.indexOf(" ") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(name, " ");
            String prettyName = null;
            while (tokenizer.hasMoreTokens()) {
                prettyName = tokenizer.nextToken();
            }
            if (prettyName != null) {
                name = prettyName;
            }
        }
        return name;
    }

    public String getColumnLabel(int index) throws OdaException {
        this.assertIndexValid(index);
        if (this.columnLabel == null || this.columnLabel[index - 1].equals("null")) {
            return this.getColumnName(index);
        }
        return this.columnLabel[index - 1].trim();
    }

    public int getColumnType(int index) throws OdaException {
        this.assertIndexValid(index);
        return this.columnType[index - 1] == null ? 0 : DataTypes.getType(this.columnType[index - 1]);
    }

    public String getColumnTypeName(int index) throws OdaException {
        int nativeTypeCode = this.getColumnType(index);
        return HibernateDriver.getNativeDataTypeName(nativeTypeCode);
    }

    public int getColumnDisplayLength(int index) throws OdaException {
        return 8;
    }

    public int getPrecision(int index) throws OdaException {
        return -1;
    }

    public int getScale(int index) throws OdaException {
        return -1;
    }

    public int isNullable(int index) throws OdaException {
        return 2;
    }

    private void assertIndexValid(int index) throws OdaException {
        if (index > this.getColumnCount() || index < 1) {
            throw new OdaException(NLS.bind((String)Messages.HibernateResultSetMetaData_Invalid_index, (Object)new Integer(index).toString()));
        }
    }

    public String getColumnClass(int index) throws OdaException {
        this.assertIndexValid(index);
        return this.columnClass[index - 1];
    }
}

