/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.birt.oda.impl;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.EntityManagerImpl;
import org.jboss.tools.birt.oda.Messages;
import org.jboss.tools.birt.oda.impl.AbstractOdaFactory;

public class ServerOdaFactory
extends AbstractOdaFactory {
    private EntityManager manager;

    public ServerOdaFactory(Properties properties) throws OdaException {
        this.getSessionFactory(properties);
        String maxRowString = properties.getProperty("maxRows");
        try {
            this.setMaxRows(new Integer(maxRowString));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public Object getSessionFactory(Properties properties) throws OdaException {
        int index;
        String jndiName = properties.getProperty("jndiName");
        String configurationName = properties.getProperty("configuration");
        if (configurationName != null && (index = configurationName.indexOf("-ejb")) > 0) {
            configurationName = configurationName.substring(0, index);
        }
        if (jndiName == null || jndiName.length() <= 0) {
            jndiName = "java:/" + configurationName;
        }
        String entityFactoryName = "java:/" + configurationName + "EntityManagerFactory";
        if (this.sessionFactory == null) {
            InitialContext ctx = null;
            ctx = new InitialContext();
            try {
                Object object = ctx.lookup(jndiName);
                if (object instanceof SessionFactory) {
                    this.sessionFactory = (SessionFactory)object;
                    return this.sessionFactory;
                }
                if (object instanceof EntityManagerFactory) {
                    EntityManagerFactory entityManagerFactory = (EntityManagerFactory)object;
                    this.manager = entityManagerFactory.createEntityManager();
                    if (this.manager instanceof EntityManagerImpl) {
                        EntityManagerImpl hibernateManager = (EntityManagerImpl)this.manager;
                        this.sessionFactory = hibernateManager.getSession().getSessionFactory();
                        this.manager.close();
                        return this.sessionFactory;
                    }
                }
            }
            catch (Exception exception) {
                try {
                    Object object = ctx.lookup(entityFactoryName);
                    if (object instanceof SessionFactory) {
                        this.sessionFactory = (SessionFactory)object;
                        return this.sessionFactory;
                    }
                    if (object instanceof EntityManagerFactory) {
                        EntityManagerFactory entityManagerFactory = (EntityManagerFactory)object;
                        this.manager = entityManagerFactory.createEntityManager();
                        if (this.manager instanceof EntityManagerImpl) {
                            EntityManagerImpl hibernateManager = (EntityManagerImpl)this.manager;
                            this.sessionFactory = hibernateManager.getSession().getSessionFactory();
                            this.manager.close();
                            return this.sessionFactory;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new OdaException(Messages.ServerOdaFactory_Cannot_create_Hibernate_session_factory);
                }
            }
        }
        return this.sessionFactory;
    }

    public boolean isOpen() {
        return this.sessionFactory != null && !this.sessionFactory.isClosed();
    }
}

