/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.birt.oda.ui.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.jboss.tools.birt.oda.ui.Messages;

class TextMenuManager {
    private Hashtable htActions = new Hashtable();
    private MenuManager manager = new MenuManager();

    TextMenuManager(TextViewer viewer) {
        Separator separator = new Separator("undo");
        this.manager.add((IContributionItem)separator);
        separator = new Separator("copy");
        this.manager.add((IContributionItem)separator);
        separator = new Separator("select");
        this.manager.add((IContributionItem)separator);
        this.manager.appendToGroup("undo", (IAction)this.getAction("undo", viewer, Messages.TextMenuManager_Undo, 1));
        this.manager.appendToGroup("undo", (IAction)this.getAction("redo", viewer, Messages.TextMenuManager_Redo, 2));
        this.manager.appendToGroup("copy", (IAction)this.getAction("cut", viewer, Messages.TextMenuManager_Cut, 3));
        this.manager.appendToGroup("copy", (IAction)this.getAction("copy", viewer, Messages.TextMenuManager_Copy, 4));
        this.manager.appendToGroup("copy", (IAction)this.getAction("paste", viewer, Messages.TextMenuManager_Paste, 5));
        this.manager.appendToGroup("select", (IAction)this.getAction("selectall", viewer, Messages.TextMenuManager_Select_all, 7));
        this.manager.add((IContributionItem)new Separator("hql"));
        this.manager.appendToGroup("hql", (IAction)this.getAction("contentAssist", viewer, Messages.TextMenuManager_Content_Assist, 13));
        this.manager.appendToGroup("hql", (IAction)this.getAction("contentTip", viewer, Messages.TextMenuManager_Content_Tip, 14));
        this.manager.appendToGroup("hql", (IAction)this.getAction("format", viewer, Messages.TextMenuManager_Format_HQL_source, 15));
        this.manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Enumeration elements = TextMenuManager.this.htActions.elements();
                while (elements.hasMoreElements()) {
                    SourceViewerAction action = (SourceViewerAction)((Object)elements.nextElement());
                    action.update();
                }
            }
        });
    }

    public Menu getContextMenu(Control control) {
        return this.manager.createContextMenu(control);
    }

    private final SourceViewerAction getAction(String id, TextViewer viewer, String name, int operation) {
        SourceViewerAction action = (SourceViewerAction)((Object)this.htActions.get(id));
        if (action == null) {
            action = new SourceViewerAction(viewer, name, operation);
            this.htActions.put(id, action);
        }
        return action;
    }

    class SourceViewerAction
    extends Action {
        private int operationCode;
        private TextViewer viewer;

        public SourceViewerAction(TextViewer viewer, String text, int operationCode) {
            super(text);
            this.operationCode = -1;
            this.viewer = null;
            this.operationCode = operationCode;
            this.viewer = viewer;
        }

        public void run() {
            this.viewer.doOperation(this.operationCode);
        }

        public void update() {
            this.setEnabled(this.viewer.canDoOperation(this.operationCode));
        }
    }
}

